/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.servlet.WSMTOMSBAnnotationsTest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.AttachmentHelper;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;
import com.sun.ts.tests.webservices12.servlet.WSMTOMSBAnnotationsTest.DataType;
import com.sun.ts.tests.webservices12.servlet.WSMTOMSBAnnotationsTest.DataType3;
import com.sun.ts.tests.webservices12.servlet.WSMTOMSBAnnotationsTest.MTOMClientTwo;
import com.sun.ts.tests.webservices12.servlet.WSMTOMSBAnnotationsTest.MTOMTest;
import com.sun.ts.tests.webservices12.servlet.WSMTOMSBAnnotationsTest.MTOMTestService;
import com.sun.ts.tests.webservices12.servlet.WSMTOMSBAnnotationsTest.MTOMTestTwo;
import jakarta.activation.DataHandler;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.soap.SOAPBinding;
import java.awt.Image;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.webservices12.servlet.WSMTOMSBAnnotationsTest.";
    private static final String NAMESPACEURI = "http://mtomtestservice.org/wsdl";
    private static final String SERVICE_NAME = "MTOMTestService";
    private static final String PORT_NAME1 = "MTOMTestPort";
    private static final String PORT_NAME2 = "MTOMTestTwoPort";
    private QName SERVICE_QNAME = new QName("http://mtomtestservice.org/wsdl", "MTOMTestService");
    private QName PORT_QNAME1 = new QName("http://mtomtestservice.org/wsdl", "MTOMTestPort");
    private QName PORT_QNAME2 = new QName("http://mtomtestservice.org/wsdl", "MTOMTestTwoPort");
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL docURL1 = null;
    private URL docURL2 = null;
    private URL docURL3 = null;
    private URL docURL4 = null;
    private URL docURL11 = null;
    private URL docURL12 = null;
    private URL docURL13 = null;
    private URL docURL14 = null;
    private URL docURLBigJpeg = null;
    String SDOC1 = "text.xml";
    String SDOC2 = "application.xml";
    String SDOC3 = "attach.html";
    String SDOC4 = "attach.jpg";
    String SDOC11 = "text2.xml";
    String SDOC12 = "application2.xml";
    String SDOC13 = "attach2.html";
    String SDOC14 = "attach2.jpg";
    String SDOCBigJpeg = "big.jpg";
    private static final String ENDPOINT_URL = "wsservletmtomsoapbindingwithannotationstest.endpoint.1";
    private static final String WSDLLOC_URL = "wsservletmtomsoapbindingwithannotationstest.wsdlloc.1";
    private static final String CTXROOT = "wsservletmtomsoapbindingwithannotationstest.cntxroot.1";
    private String url = null;
    private String url3 = null;
    private URL wsdlurl = null;
    private String ctxroot = null;
    private MTOMTest port = null;
    private MTOMTestTwo port2 = null;
    private MTOMClientTwo client2;
    static MTOMTestService service = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXWS_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXWS_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        this.ctxroot = JAXWS_Util.getURLFromProp(CTXROOT);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
        TestUtil.logMsg((String)("Context Root:         " + this.ctxroot));
    }

    private void getPortJavaEE() throws Exception {
        TestUtil.logMsg((String)"Obtaining service via WebServiceRef annotation");
        TestUtil.logMsg((String)("service=" + service));
        this.port = (MTOMTest)service.getPort(MTOMTest.class);
        SOAPBinding binding = (SOAPBinding)((BindingProvider)this.port).getBinding();
        binding.setMTOMEnabled(true);
        TestUtil.logMsg((String)("port=" + this.port));
        TestUtil.logMsg((String)"Obtained port");
        JAXWS_Util.dumpTargetEndpointAddress(this.port);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        this.client2 = (MTOMClientTwo)ClientFactory.getClient(MTOMClientTwo.class, p, this, service);
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.modeProperty = p.getProperty(MODEPROP);
            TestUtil.logMsg((String)"Get WebServiceRef from specific vehicle");
            service = (MTOMTestService)((Object)this.getSharedObject());
            this.getTestURLs();
            this.getPortJavaEE();
            this.port2 = this.client2.returnPort();
            SOAPBinding binding = (SOAPBinding)((BindingProvider)this.port2).getBinding();
            binding.setMTOMEnabled(true);
            this.docURL1 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.ctxroot + "/" + this.SDOC1);
            this.docURL2 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.ctxroot + "/" + this.SDOC2);
            this.docURL3 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.ctxroot + "/" + this.SDOC3);
            this.docURL4 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.ctxroot + "/" + this.SDOC4);
            this.docURL11 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.ctxroot + "/" + this.SDOC11);
            this.docURL12 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.ctxroot + "/" + this.SDOC12);
            this.docURL13 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.ctxroot + "/" + this.SDOC13);
            this.docURL14 = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.ctxroot + "/" + this.SDOC14);
            this.docURLBigJpeg = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.ctxroot + "/" + this.SDOCBigJpeg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void MTOMInTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MTOMInTest");
        boolean pass = true;
        try {
            DataType data = new DataType();
            data.setDocName1(this.SDOC1);
            data.setDocName2(this.SDOC2);
            data.setDocName3(this.SDOC3);
            data.setDocName4(this.SDOC4);
            data.setDocUrl1(this.docURL1.toString());
            data.setDocUrl2(this.docURL2.toString());
            data.setDocUrl3(this.docURL3.toString());
            data.setDocUrl4(this.docURL4.toString());
            StreamSource doc1 = AttachmentHelper.getSourceDoc(this.docURL1);
            StreamSource doc2 = AttachmentHelper.getSourceDoc(this.docURL2);
            DataHandler doc3 = AttachmentHelper.getDataHandlerDoc(this.docURL3);
            Image doc4 = AttachmentHelper.getImageDoc(this.docURL4);
            data.setDoc1(doc1);
            data.setDoc2(doc2);
            data.setDoc3(doc3);
            data.setDoc4(doc4);
            TestUtil.logMsg((String)"Send 4 documents using MTOM via webservice method mtomIn()");
            TestUtil.logMsg((String)("Documents to send: [" + this.SDOC1 + "," + this.SDOC2 + "," + this.SDOC3 + "," + this.SDOC4 + "]"));
            String result = this.port.mtomIn(data);
            if (!result.equals("")) {
                TestUtil.logErr((String)"An error occurred with one or more of the attachments");
                TestUtil.logErr((String)("result=" + result));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occurred");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("MTOMInTest failed");
        }
    }

    public void MTOMInOutTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MTOMInOutTest");
        boolean pass = true;
        try {
            Holder hDocName1 = new Holder((Object)this.SDOC1);
            Holder hDocName2 = new Holder((Object)this.SDOC2);
            Holder hDocName3 = new Holder((Object)this.SDOC3);
            Holder hDocName4 = new Holder((Object)this.SDOC4);
            Holder hDocUrl1 = new Holder((Object)this.docURL1.toString());
            Holder hDocUrl2 = new Holder((Object)this.docURL2.toString());
            Holder hDocUrl3 = new Holder((Object)this.docURL3.toString());
            Holder hDocUrl4 = new Holder((Object)this.docURL4.toString());
            Holder hDocUrl11 = new Holder((Object)this.docURL11.toString());
            Holder hDocUrl12 = new Holder((Object)this.docURL12.toString());
            Holder hDocUrl13 = new Holder((Object)this.docURL13.toString());
            Holder hDocUrl14 = new Holder((Object)this.docURL14.toString());
            StreamSource doc1 = AttachmentHelper.getSourceDoc(this.docURL1);
            StreamSource doc2 = AttachmentHelper.getSourceDoc(this.docURL2);
            DataHandler doc3 = AttachmentHelper.getDataHandlerDoc(this.docURL3);
            Image doc4 = AttachmentHelper.getImageDoc(this.docURL4);
            Holder hDoc1 = new Holder((Object)doc1);
            Holder hDoc2 = new Holder((Object)doc2);
            Holder hDoc3 = new Holder((Object)doc3);
            Holder hDoc4 = new Holder((Object)doc4);
            Holder hResult = new Holder((Object)"");
            TestUtil.logMsg((String)"Send and receieve 4 documents using MTOM via webservice method mtomInOut()");
            TestUtil.logMsg((String)("Documents to send: [" + this.SDOC1 + "," + this.SDOC2 + "," + this.SDOC3 + "," + this.SDOC4 + "]"));
            TestUtil.logMsg((String)("Documents to receive: [" + this.SDOC11 + "," + this.SDOC12 + "," + this.SDOC13 + "," + this.SDOC14 + "]"));
            this.port.mtomInOut((Holder<String>)hDocName1, (Holder<String>)hDocName2, (Holder<String>)hDocName3, (Holder<String>)hDocName4, (Holder<String>)hDocUrl1, (Holder<String>)hDocUrl2, (Holder<String>)hDocUrl3, (Holder<String>)hDocUrl4, (Holder<String>)hDocUrl11, (Holder<String>)hDocUrl12, (Holder<String>)hDocUrl13, (Holder<String>)hDocUrl14, (Holder<Source>)hDoc1, (Holder<Source>)hDoc2, (Holder<DataHandler>)hDoc3, (Holder<Image>)hDoc4, (Holder<String>)hResult);
            if (!((String)hResult.value).equals("")) {
                TestUtil.logErr((String)("Server-side errors occurred:\n" + (String)hResult.value));
                pass = false;
            }
            TestUtil.logMsg((String)"Verify the contents of the received documents");
            doc1 = AttachmentHelper.getSourceDoc(this.docURL11);
            doc2 = AttachmentHelper.getSourceDoc(this.docURL12);
            doc3 = AttachmentHelper.getDataHandlerDoc(this.docURL13);
            doc4 = AttachmentHelper.getImageDoc(this.docURL14);
            String tmpRes = AttachmentHelper.validateAttachmentData(doc1, (Source)hDoc1.value, this.SDOC11);
            if (tmpRes != null) {
                TestUtil.logErr((String)("Client-side error: " + tmpRes));
                pass = false;
            }
            if ((tmpRes = AttachmentHelper.validateAttachmentData(doc2, (Source)hDoc2.value, this.SDOC12)) != null) {
                TestUtil.logErr((String)("Client-side error: " + tmpRes));
                pass = false;
            }
            if ((tmpRes = AttachmentHelper.validateAttachmentData(doc3, (DataHandler)hDoc3.value, this.SDOC13)) != null) {
                TestUtil.logErr((String)("Client-side error: " + tmpRes));
                pass = false;
            }
            if ((tmpRes = AttachmentHelper.validateAttachmentData(doc4, (Image)hDoc4.value, this.SDOC14)) != null) {
                TestUtil.logErr((String)("Client-side error: " + tmpRes));
                pass = false;
            }
            if (pass) {
                TestUtil.logMsg((String)"All received documents are as expected (ok)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occurred");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("MTOMInOutTest failed");
        }
    }

    public void MTOMOutTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MTOMOutTest");
        boolean pass = true;
        try {
            StreamSource doc1 = AttachmentHelper.getSourceDoc(this.docURL1);
            StreamSource doc2 = AttachmentHelper.getSourceDoc(this.docURL2);
            DataHandler doc3 = AttachmentHelper.getDataHandlerDoc(this.docURL3);
            Image doc4 = AttachmentHelper.getImageDoc(this.docURL4);
            String urls = this.docURL1.toString() + "," + this.docURL2.toString() + "," + this.docURL3.toString() + "," + this.docURL4.toString();
            TestUtil.logTrace((String)("urls=" + urls));
            TestUtil.logMsg((String)"Receive 4 documents using MTOM via webservice method mtomOut()");
            TestUtil.logMsg((String)("Documents to receive: [" + this.SDOC1 + "," + this.SDOC2 + "," + this.SDOC3 + "," + this.SDOC4 + "]"));
            DataType data = this.port.mtomOut(urls);
            TestUtil.logMsg((String)"Verify the contents of the received documents");
            String tmpRes = AttachmentHelper.validateAttachmentData(doc1, data.getDoc1(), this.SDOC1);
            if (tmpRes != null) {
                TestUtil.logErr((String)("Client-side error: " + tmpRes));
                pass = false;
            }
            if ((tmpRes = AttachmentHelper.validateAttachmentData(doc2, data.getDoc2(), this.SDOC2)) != null) {
                TestUtil.logErr((String)("Client-side error: " + tmpRes));
                pass = false;
            }
            if ((tmpRes = AttachmentHelper.validateAttachmentData(doc3, data.getDoc3(), this.SDOC3)) != null) {
                TestUtil.logErr((String)("Client-side error: " + tmpRes));
                pass = false;
            }
            if ((tmpRes = AttachmentHelper.validateAttachmentData(doc4, data.getDoc4(), this.SDOC4)) != null) {
                TestUtil.logErr((String)("Client-side error: " + tmpRes));
                pass = false;
            }
            if (pass) {
                TestUtil.logMsg((String)"All received documents are as expected (ok)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occurred");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("MTOMOutTest failed");
        }
    }

    public void MTOMIn2CheckHttpHeadersTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MTOMIn2CheckHttpHeadersTest");
        boolean pass = true;
        try {
            DataType3 data = new DataType3();
            Image doc = AttachmentHelper.getImageDoc(this.docURLBigJpeg);
            data.setDoc(doc);
            String result = "";
            try {
                TestUtil.logMsg((String)"Check Content-Type Request HTTP Request header for correctness");
                result = this.client2.mtomIn2(data);
            }
            catch (Exception e) {
                throw new EETest.Fault("Unable to invoke endpoint", e);
            }
            TestUtil.logMsg((String)"Verify Content-Type Request HTTP header");
            TestUtil.logMsg((String)("Content-Type Request HTTP header=" + result));
            if (result.equals("EXCEPTION")) {
                throw new EETest.Fault("Endpoint unable to process request ");
            }
            if (result.toLowerCase().indexOf("text/xml") < 0 || result.toLowerCase().indexOf("multipart/related") < 0 || result.toLowerCase().indexOf("application/xop+xml") < 0) {
                TestUtil.logErr((String)"Content-Type Request HTTP header was incorrect (ok)");
                TestUtil.logErr((String)"Expected (multipart/related,application/xop+xml,text/xml) in header");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Content-Type Request HTTP header was correct (ok)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occurred");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("MTOMIn2CheckHttpHeadersTest failed");
        }
    }

    public void MTOMOut2Test() throws EETest.Fault {
        TestUtil.logMsg((String)"MTOMOut2Test");
        boolean pass = true;
        try {
            Image doc = AttachmentHelper.getImageDoc(this.docURLBigJpeg);
            String urls = this.docURLBigJpeg.toString();
            TestUtil.logMsg((String)("urls=" + urls));
            TestUtil.logMsg((String)"Receive 1 document using MTOM via webservice method mtomOut2()");
            TestUtil.logMsg((String)("Document to receive: [" + this.SDOCBigJpeg + "]"));
            DataType3 data = this.port.mtomOut2(urls);
            TestUtil.logMsg((String)"Verify the content of the received document");
            String tmpRes = AttachmentHelper.validateAttachmentData(doc, data.getDoc(), this.SDOCBigJpeg);
            if (tmpRes != null) {
                TestUtil.logErr((String)("Client-side error: " + tmpRes));
                pass = false;
            }
            if (pass) {
                TestUtil.logMsg((String)"The received document is as expected (ok)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occurred");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("MTOMOut2Test failed");
        }
    }

    public void VerifySOAPProtocolBindingOnPorts() throws EETest.Fault {
        boolean pass;
        block11: {
            TestUtil.logMsg((String)"VerifySOAPProtocolBindingOnPorts");
            pass = true;
            try {
                BindingProvider bindingprovider1 = (BindingProvider)this.port;
                BindingProvider bindingprovider2 = (BindingProvider)this.port2;
                TestUtil.logMsg((String)("Binding for first port is " + bindingprovider1.getBinding()));
                TestUtil.logMsg((String)("Binding for second port is " + bindingprovider2.getBinding()));
                if (!(bindingprovider1.getBinding() instanceof SOAPBinding)) {
                    TestUtil.logErr((String)"First port is not instance of SOAPBinding");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"First port is an instance of SOAPBinding");
                }
                if (!(bindingprovider2.getBinding() instanceof SOAPBinding)) {
                    TestUtil.logErr((String)"Second port is not instance of SOAPBinding");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Second port is an instance of SOAPBinding");
                }
                if (!pass) break block11;
                SOAPFactory factory1 = ((SOAPBinding)bindingprovider1.getBinding()).getSOAPFactory();
                SOAPFactory factory2 = ((SOAPBinding)bindingprovider2.getBinding()).getSOAPFactory();
                TestUtil.logMsg((String)("SOAPFactory for first port is " + factory1));
                TestUtil.logMsg((String)("SOAPFactory for second port is " + factory2));
                SOAPFault soapfault = factory1.createFault();
                try {
                    soapfault.setFaultRole("http://myfault.org");
                    TestUtil.logErr((String)"SOAPFactory for first port is a based on SOAP1.2 protocol (Unexpected)");
                    pass = false;
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"SOAPFactory for first port is a based on SOAP1.1 protocol (Expected)");
                }
                soapfault = factory2.createFault();
                try {
                    soapfault.setFaultRole("http://myfault.org");
                    TestUtil.logErr((String)"SOAPFactory for second port is a based on SOAP1.2 protocol (Unexpected)");
                    pass = false;
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"SOAPFactory for second port is a based on SOAP1.1 protocol (Expected)");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception occurred");
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("VerifySOAPProtocolBindingOnPorts failed");
        }
    }

    public void VerifyMTOMEnabledOnPorts() throws EETest.Fault {
        TestUtil.logMsg((String)"VerifyMTOMEnabledOnPorts");
        boolean pass = true;
        try {
            BindingProvider bindingprovider1 = (BindingProvider)this.port;
            BindingProvider bindingprovider2 = (BindingProvider)this.port2;
            if (!((SOAPBinding)bindingprovider1.getBinding()).isMTOMEnabled()) {
                TestUtil.logErr((String)"First port does not have MTOM enabled");
                pass = false;
            } else {
                TestUtil.logMsg((String)"First port does have MTOM enabled");
            }
            if (!((SOAPBinding)bindingprovider2.getBinding()).isMTOMEnabled()) {
                TestUtil.logErr((String)"Second port does not have MTOM enabled");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Second port does have MTOM enabled");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occurred");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("VerifyMTOMEnabledOnPorts failed");
        }
    }
}

