/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.EntityGraph;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.EntityGraph.Department;
import com.sun.ts.tests.jpa.core.EntityGraph.Employee;
import com.sun.ts.tests.jpa.core.EntityGraph.Employee2;
import com.sun.ts.tests.jpa.core.EntityGraph.Employee3;
import jakarta.persistence.AttributeNode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    Employee3[] empRef = new Employee3[5];
    Department[] deptRef = new Department[2];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.displayMap(p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupEmployeeData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupOrderData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createEmployeeData();
            this.displayMap(p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void cleanupEmployeeData() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        this.cleanup();
    }

    public void addAttributeNodesStringArrayTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("firstName");
        expected.add("lastName");
        EntityGraph empEG = this.getEntityManager().createEntityGraph(Employee.class);
        empEG.addAttributeNodes(expected.toArray(new String[0]));
        List result = empEG.getAttributeNodes();
        ArrayList<String> actual = new ArrayList<String>();
        for (AttributeNode an : result) {
            actual.add(an.getAttributeName());
        }
        if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
            TestUtil.logTrace((String)"Received expected results");
            pass = true;
        } else {
            TestUtil.logErr((String)"Expected results");
            for (String s : expected) {
                TestUtil.logErr((String)("expected:" + s));
            }
            TestUtil.logErr((String)"Actual results");
            for (String s : actual) {
                TestUtil.logErr((String)("actual:" + s));
            }
        }
        if (!pass) {
            throw new EETest.Fault("addAttributeNodesStringArrayTest failed");
        }
    }

    public void addAttributeNodesStringArrayIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        EntityGraph empEG = this.getEntityManager().createEntityGraph(Employee2.class);
        try {
            empEG.addAttributeNodes(new String[]{"doesnotexist"});
            TestUtil.logErr((String)"Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
        }
        if (!pass) {
            throw new EETest.Fault("addAttributeNodesStringArrayIllegalArgumentExceptionTest failed");
        }
    }

    public void addAttributeNodesAttributeArrayTest() throws EETest.Fault {
        boolean pass = false;
        Metamodel mm = this.getEntityManager().getMetamodel();
        ManagedType mTypeOrder = mm.managedType(Employee.class);
        ArrayList<String> sExpected = new ArrayList<String>();
        sExpected.add("firstName");
        sExpected.add("lastName");
        ArrayList<Attribute> expected = new ArrayList<Attribute>();
        for (String s : sExpected) {
            expected.add(mTypeOrder.getDeclaredAttribute(s));
        }
        EntityGraph empEG = this.getEntityManager().createEntityGraph(Employee.class);
        empEG.addAttributeNodes(expected.toArray(new Attribute[0]));
        List result = empEG.getAttributeNodes();
        ArrayList<String> actual = new ArrayList<String>();
        for (AttributeNode an : result) {
            actual.add(an.getAttributeName());
        }
        if (actual.containsAll(sExpected) && sExpected.containsAll(actual) && actual.size() == sExpected.size()) {
            TestUtil.logTrace((String)"Received expected results");
            pass = true;
        } else {
            TestUtil.logErr((String)"Expected results");
            for (String s : sExpected) {
                TestUtil.logErr((String)("expected:" + s));
            }
            TestUtil.logErr((String)"Actual results");
            for (String s : actual) {
                TestUtil.logErr((String)("actual:" + s));
            }
        }
        if (!pass) {
            throw new EETest.Fault("addAttributeNodesAttributeArrayTest failed");
        }
    }

    public void createEntityGraphStringTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Test that the named entity graph is returned");
        EntityGraph eg = this.getEntityManager().createEntityGraph("first_last_graph");
        if (eg != null) {
            TestUtil.logTrace((String)("Received non-null EntityGraph:" + eg.getName()));
            pass1 = true;
        } else {
            TestUtil.logErr((String)"Null was returned for EntityGraph that does exist");
        }
        TestUtil.logMsg((String)"Test that null is returned");
        try {
            eg = this.getEntityManager().createEntityGraph("doesnotexist");
            if (eg == null) {
                TestUtil.logTrace((String)"Received expected null EntityGraph");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Non-null EntityGraph was returned instead of a null:" + eg.getName()));
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("createEntityGraphStringTest failed");
        }
    }

    public void getEntityGraphStringTest() throws EETest.Fault {
        boolean pass = false;
        EntityGraph eg = this.getEntityManager().getEntityGraph("first_last_graph");
        if (eg != null) {
            TestUtil.logTrace((String)("Received non-null EntityGraph:" + eg.getName()));
            pass = true;
        } else {
            TestUtil.logErr((String)"Null was returned for EntityGraph that does exist");
        }
        if (!pass) {
            throw new EETest.Fault("getEntityGraphStringTest failed");
        }
    }

    public void entityGraphGetNameTest() throws EETest.Fault {
        boolean pass = false;
        String expected = "first_last_graph";
        EntityGraph eg = this.getEntityManager().getEntityGraph(expected);
        if (eg != null) {
            if (eg.getName().equals(expected)) {
                TestUtil.logTrace((String)("Received expected EntityGraph name:" + eg.getName()));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected name: " + expected + ", actual:" + eg.getName()));
            }
        } else {
            TestUtil.logErr((String)"Null was returned for EntityGraph that does exist");
        }
        if (!pass) {
            throw new EETest.Fault("entityGraphGetNameTest failed");
        }
    }

    public void entityGraphGetNameNoNameExistsTest() throws EETest.Fault {
        boolean pass = false;
        List egs = this.getEntityManager().getEntityGraphs(Employee2.class);
        if (egs.size() == 1) {
            EntityGraph e = (EntityGraph)egs.get(0);
            if (e.getName().equals("Employee2")) {
                TestUtil.logTrace((String)("Received expected name:" + e.getName()));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected name: Employee2, actual:" + e.getName()));
            }
        } else {
            TestUtil.logErr((String)("Expected 1 graph to be returned, instead got:" + egs.size()));
        }
        if (!pass) {
            throw new EETest.Fault("entityGraphGetNameNoNameExistsTest failed");
        }
    }

    public void getNameTest() throws EETest.Fault {
        boolean pass = false;
        EntityGraph eg = this.getEntityManager().createEntityGraph(Employee2.class);
        if (eg.getName() == null) {
            TestUtil.logTrace((String)"Received expected null");
            pass = true;
        } else {
            TestUtil.logErr((String)("Expected name: null, actual:" + eg.getName()));
        }
        if (!pass) {
            throw new EETest.Fault("getNameTest failed");
        }
    }

    public void getEntityGraphStringIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityManager().getEntityGraph("doesnotexist");
            TestUtil.logErr((String)"Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
        }
        if (!pass) {
            throw new EETest.Fault("getEntityGraphStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getEntityGraphsClassTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("first_last_graph");
        expected.add("last_salary_graph");
        expected.add("lastname_department_subgraphs");
        ArrayList<String> actual = new ArrayList<String>();
        List eg = this.getEntityManager().getEntityGraphs(Employee3.class);
        if (eg.size() > 0) {
            for (EntityGraph e : eg) {
                actual.add(e.getName());
            }
            if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Expected results");
                for (String s : expected) {
                    TestUtil.logErr((String)("expected:" + s));
                }
                TestUtil.logErr((String)"Actual results");
                for (String s : actual) {
                    TestUtil.logErr((String)("actual:" + s));
                }
            }
        } else {
            TestUtil.logErr((String)"No named entity graphs were returned eventhough they exist in entity");
        }
        if (!pass) {
            throw new EETest.Fault("getEntityGraphsClassTest failed");
        }
    }

    public void addNamedEntityGraphStringEntityGraphTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        String sExpected = "new_named_entity_graph";
        TestUtil.logMsg((String)"add entity graph to EMF");
        EntityGraph eg = this.getEntityManager().createEntityGraph(Employee.class);
        eg.addAttributeNodes(new String[]{"id"});
        this.getEntityManager().getEntityManagerFactory().addNamedEntityGraph(sExpected, eg);
        EntityGraph eg2 = this.getEntityManager().getEntityGraph(sExpected);
        if (eg2 != null) {
            if (eg2.getName() != null) {
                if (eg2.getName().equals(sExpected)) {
                    TestUtil.logTrace((String)("Received expected entity graph:" + eg2.getName()));
                    pass1 = true;
                } else {
                    TestUtil.logErr((String)("Expected: named_entity_graph, actual:" + eg2.getName()));
                }
            } else {
                TestUtil.logErr((String)"getName() returned null for a named entity graph added via addNamedEntityGraph");
            }
        } else {
            TestUtil.logErr((String)"getEntityGraph() returned null");
        }
        TestUtil.logMsg((String)"verify nodes");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        ArrayList<String> actual = new ArrayList<String>();
        List listNodes = eg2.getAttributeNodes();
        for (AttributeNode an : listNodes) {
            actual.add(an.getAttributeName());
        }
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            TestUtil.logTrace((String)"Received expected AttributeNode");
            pass2 = true;
        } else {
            TestUtil.logErr((String)"Did not received expected AttributeNodes");
            TestUtil.logErr((String)"Expected results");
            for (String s : expected) {
                TestUtil.logErr((String)("expected:" + s));
            }
            TestUtil.logErr((String)"Actual results");
            for (String s : actual) {
                TestUtil.logErr((String)("actual:" + s));
            }
        }
        TestUtil.logMsg((String)"override previous entity graph");
        eg = this.getEntityManager().createEntityGraph(Employee.class);
        eg.addAttributeNodes(new String[]{"lastName"});
        this.getEntityManager().getEntityManagerFactory().addNamedEntityGraph(sExpected, eg);
        eg2 = this.getEntityManager().getEntityGraph(sExpected);
        if (eg2 != null) {
            if (eg2.getName() != null) {
                if (eg2.getName().equals(sExpected)) {
                    TestUtil.logTrace((String)("Received expected entity graph:" + eg2.getName()));
                    pass3 = true;
                } else {
                    TestUtil.logErr((String)("Expected: named_entity_graph, actual:" + eg2.getName()));
                }
            } else {
                TestUtil.logErr((String)"getName() returned null for a named entity graph added via addNamedEntityGraph");
            }
        } else {
            TestUtil.logErr((String)"getEntityGraph() returned null");
        }
        TestUtil.logMsg((String)"verify nodes of overriden named entity graph");
        expected = new ArrayList();
        expected.add("lastName");
        actual = new ArrayList();
        listNodes = eg2.getAttributeNodes();
        for (AttributeNode an : listNodes) {
            actual.add(an.getAttributeName());
        }
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            TestUtil.logTrace((String)"Received expected AttributeNode");
            pass4 = true;
        } else {
            TestUtil.logErr((String)"Did not received expected AttributeNodes");
            TestUtil.logErr((String)"Expected results");
            for (String s : expected) {
                TestUtil.logErr((String)("expected:" + s));
            }
            TestUtil.logErr((String)"Actual results");
            for (String s : actual) {
                TestUtil.logErr((String)("actual:" + s));
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("addNamedEntityGraphStringEntityGraphTest failed");
        }
    }

    public void getEntityGraphsClassIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityManager().getEntityGraphs(Client.class);
            TestUtil.logErr((String)"Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
        }
        if (!pass) {
            throw new EETest.Fault("getEntityGraphsClassIllegalArgumentExceptionTest failed");
        }
    }

    public void annotationsTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("lastName");
        expected.add("salary");
        ArrayList<String> actual = new ArrayList<String>();
        EntityGraph eg = this.getEntityManager().getEntityGraph("last_salary_graph");
        List listNodes = eg.getAttributeNodes();
        for (AttributeNode an : listNodes) {
            actual.add(an.getAttributeName());
        }
        if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
            TestUtil.logTrace((String)"Received expected results");
            pass = true;
        } else {
            TestUtil.logErr((String)"Expected results");
            for (String s : expected) {
                TestUtil.logErr((String)("expected:" + s));
            }
            TestUtil.logErr((String)"Actual results");
            for (String s : actual) {
                TestUtil.logErr((String)("actual:" + s));
            }
        }
        if (!pass) {
            throw new EETest.Fault("annotationsTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeData() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Creating Employees");
            Date d1 = this.getUtilDate("2000-02-14");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.deptRef[0] = new Department(1, "Marketing");
            this.deptRef[1] = new Department(2, "Administration");
            for (Department department : this.deptRef) {
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted department:" + department));
            }
            this.empRef[0] = new Employee3(1, "Alan", "Frechette", d1, 35000.0f);
            this.empRef[0].setDepartment(this.deptRef[0]);
            this.empRef[1] = new Employee3(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[1].setDepartment(this.deptRef[0]);
            this.empRef[2] = new Employee3(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[2].setDepartment(this.deptRef[1]);
            this.empRef[3] = new Employee3(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[3].setDepartment(this.deptRef[1]);
            this.empRef[4] = new Employee3(5, "Stephen", "DMilla", d5, 25000.0f);
            this.empRef[4].setDepartment(this.deptRef[1]);
            for (Department department : this.empRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted employee3:" + (Employee3)department));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

