/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.queueconn;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Message;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Properties;

public class QueueConnTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.appclient.queueconn.QueueConnTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        QueueConnTests theTests = new QueueConnTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
            this.queues = new ArrayList(2);
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                TestUtil.logMsg((String)"Cleanup: Closing Queue Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void connStoppedQueueTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.tool.getDefaultQueueConnection().stop();
            TestUtil.logTrace((String)"Creating 1 TextMessage");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("Message from connStoppedQueueTest");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "connStoppedQueueTest");
            TestUtil.logTrace((String)"Sending a TextMessage");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            this.tool.getDefaultQueueConnection().start();
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            TestUtil.logMsg((String)"Pass: Received correct message");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"connStoppedQueueTest failed: ", (Throwable)e);
            throw new EETest.Fault("connStoppedQueueTest", e);
        }
    }

    public void closedQueueConnectionNoForcedAckTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            QueueSession qSession = null;
            QueueReceiver qReceiver = null;
            QueueSender qSender = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            QueueConnection newConn = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(newConn);
            qSession = newConn.createQueueSession(false, 2);
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueSession().close();
            qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            qSender = qSession.createSender(this.tool.getDefaultQueue());
            TestUtil.logMsg((String)"create a new connection");
            newConn.start();
            TestUtil.logMsg((String)"Creating 1 TextMessage");
            messageSent = qSession.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "closedQueueConnectionNoForcedAckTest");
            TestUtil.logMsg((String)"Sending a TextMessage");
            qSender.send((Message)messageSent);
            TestUtil.logMsg((String)"Receive the TextMessage");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            qReceiver.close();
            TestUtil.logMsg((String)"Close the connection with no ack of message received");
            newConn.close();
            TestUtil.logMsg((String)"Use default connection to retrieve the unacknowledged message");
            qSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 2);
            qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"Fail: no message received.");
                pass = false;
            } else if (messageReceived.getText().equals(messageSent.getText())) {
                TestUtil.logMsg((String)"Pass: received correct msg");
            } else {
                TestUtil.logErr((String)"Fail: didnt get correct msg");
                pass = false;
            }
            try {
                messageReceived.acknowledge();
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)"Exception thrown on ack!", (Throwable)e);
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueConnectionNoForcedAckTest");
        }
    }
}

