/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.provider;

import com.sun.ts.lib.util.TestUtil;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;

public class MyJsonWriter
implements JsonWriter {
    private OutputStream out = null;
    private Writer writer = null;
    private Charset charset = Charset.forName("UTF-8");
    private static StringBuilder calls = new StringBuilder();

    private void dumpInstanceVars() {
        TestUtil.logTrace((String)("writer=" + this.writer));
        TestUtil.logTrace((String)("out=" + this.out));
        TestUtil.logTrace((String)("charset=" + this.charset));
    }

    public static String getCalls() {
        return calls.toString();
    }

    public static void clearCalls() {
        calls.delete(0, calls.length());
    }

    private static void addCalls(String s) {
        calls.append(s);
    }

    public MyJsonWriter() {
    }

    public MyJsonWriter(OutputStream out) {
        this.out = out;
    }

    public MyJsonWriter(Writer writer) {
        this.writer = writer;
    }

    public void close() {
        TestUtil.logTrace((String)"public void close()");
        MyJsonWriter.addCalls("public void close()");
    }

    public void write(JsonStructure value) {
        TestUtil.logTrace((String)"public void write(JsonStructure)");
        MyJsonWriter.addCalls("public void write(JsonStructure)");
    }

    public void writeArray(JsonArray array) {
        TestUtil.logTrace((String)"public void writeArray(JsonArray)");
        MyJsonWriter.addCalls("public void writeArray(JsonArray)");
    }

    public void writeObject(JsonObject object) {
        TestUtil.logTrace((String)"public void writeObject(JsonObject)");
        MyJsonWriter.addCalls("public void writeObject(JsonObject)");
    }
}

