/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.assembly.common;

import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import java.util.ArrayList;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.NamingException;

public class ConcurrentLookup {
    private static final Integer DEFAULT_LOOKUP_COUNT = 10;
    private Vector lookupResults = new Vector();

    public String concurrentLookup(String shortLookupName, Integer count) throws TestFailedException {
        if (count == null) {
            count = DEFAULT_LOOKUP_COUNT;
        }
        ArrayList<LookupThread> threads = new ArrayList<LookupThread>();
        for (int i = 0; i < count; ++i) {
            threads.add(new LookupThread(shortLookupName));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.lookupResults.size() != count.intValue()) {
            throw new TestFailedException("Expecting " + count + " lookups, but only got " + this.lookupResults.size() + " results: " + this.lookupResults);
        }
        for (Object e : this.lookupResults) {
            if (e != null && !(e instanceof Throwable)) continue;
            throw new TestFailedException("At least one lookup returned null or Throwable:" + this.lookupResults);
        }
        return "All " + count + " lookups returned good results: " + this.lookupResults;
    }

    class LookupThread
    extends Thread {
        private String shortLookupName;

        public LookupThread() {
        }

        public LookupThread(String shortLookupName) {
            this.shortLookupName = shortLookupName;
        }

        @Override
        public void run() {
            Object result = null;
            try {
                result = this.shortLookupName.startsWith("java:global/") ? ServiceLocator.lookup(this.shortLookupName, new Context[0]) : ServiceLocator.lookupByShortName(this.shortLookupName);
            }
            catch (NamingException ex) {
                result = ex;
            }
            ConcurrentLookup.this.lookupResults.add(result);
        }
    }
}

