/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.ee.entityManagerFactory;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entityManagerFactory.Order;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.util.Properties;

public class Client
extends PMClientBase {
    Properties props = null;

    public static void main(String[] args) {
        com.sun.ts.tests.jpa.core.entityManagerFactory.Client theTests = new com.sun.ts.tests.jpa.core.entityManagerFactory.Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setupNoData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupNoData");
        this.props = p;
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        this.props = p;
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createOrderTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void cleanupNoData() throws EETest.Fault {
        super.cleanup();
    }

    @Override
    public void cleanup() throws EETest.Fault {
        this.removeTestData();
        TestUtil.logTrace((String)"done cleanup, calling super.cleanup");
        super.cleanup();
    }

    @SetupMethod(name="setupNoData")
    @CleanupMethod(name="cleanupNoData")
    public void createEntityManagerFactoryStringTest() throws EETest.Fault {
        boolean pass = false;
        try {
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName());
            if (emf != null) {
                TestUtil.logTrace((String)"Received non-null EntityManagerFactory");
                pass = true;
            } else {
                TestUtil.logErr((String)"Received null EntityManagerFactory");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("createEntityManagerFactoryStringTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderTestData() {
        try {
            this.getEntityTransaction().begin();
            Order[] orders = new Order[]{new Order(1, 111), new Order(2, 222), new Order(3, 333), new Order(4, 444), new Order(5, 555)};
            for (Order o : orders) {
                TestUtil.logTrace((String)("Persisting order:" + o.toString()));
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

