/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.tx.cm.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeEJBLite;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;

public class RWTxBeanBase {
    protected CoffeeEJBLite postConstructCoffee;
    @PersistenceContext(unitName="ejblite-pu")
    protected EntityManager em;

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public void supports(CoffeeEJBLite c, boolean flush) {
        this.updatePersist(c, flush);
    }

    @TransactionAttribute(value=TransactionAttributeType.MANDATORY)
    public void mandatory(CoffeeEJBLite c, boolean flush) {
        this.updatePersist(c, flush);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void required(CoffeeEJBLite c, boolean flush) {
        this.updatePersist(c, flush);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void requiresNew(CoffeeEJBLite c, boolean flush) {
        this.updatePersist(c, flush);
    }

    public void requiredNoExistingTransaction(CoffeeEJBLite coffee, boolean flush) {
        this.updatePersist(coffee, flush);
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void postConstructTransaction(StringBuilder sb) {
        CoffeeEJBLite c = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)this.postConstructCoffee.getId());
        int expected = this.postConstructCoffee.getId();
        int actual = c.getId();
        Helper.assertEquals("Check the coffee persisted inside postConstruct method: ", expected, actual, sb);
    }

    protected void updatePersist(CoffeeEJBLite c, boolean flush) {
        c.setPrice(c.getPrice() + 100.0f);
        this.em.persist((Object)c);
        if (flush) {
            this.em.flush();
        }
    }
}

