/*
 * Decompiled with CFR 0.152.
 */
package javax.usb.util;

import javax.usb.UsbException;
import javax.usb.UsbIrp;

public class DefaultUsbIrp
implements UsbIrp {
    protected byte[] data = new byte[0];
    protected boolean complete = false;
    protected boolean acceptShortPacket = true;
    protected int offset = 0;
    protected int length = 0;
    protected int actualLength = 0;
    protected UsbException usbException = null;
    private Object waitLock = new Object();

    public DefaultUsbIrp() {
    }

    public DefaultUsbIrp(byte[] byArray) {
        this.setData(byArray);
    }

    public DefaultUsbIrp(byte[] byArray, int n, int n2, boolean bl) {
        this.setData(byArray, n, n2);
        this.setAcceptShortPacket(bl);
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getActualLength() {
        return this.actualLength;
    }

    @Override
    public void setData(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        if (null == byArray) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        this.data = byArray;
        this.setOffset(n);
        this.setLength(n2);
    }

    @Override
    public void setData(byte[] byArray) throws IllegalArgumentException {
        if (null == byArray) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        this.setData(byArray, 0, byArray.length);
    }

    @Override
    public void setOffset(int n) throws IllegalArgumentException {
        if (0 > n) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        this.offset = n;
    }

    @Override
    public void setLength(int n) throws IllegalArgumentException {
        if (0 > n) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        this.length = n;
    }

    @Override
    public void setActualLength(int n) throws IllegalArgumentException {
        if (0 > n) {
            throw new IllegalArgumentException("Actual length cannot be negative");
        }
        this.actualLength = n;
    }

    @Override
    public boolean isUsbException() {
        return null != this.getUsbException();
    }

    @Override
    public UsbException getUsbException() {
        return this.usbException;
    }

    @Override
    public void setUsbException(UsbException usbException) {
        this.usbException = usbException;
    }

    @Override
    public boolean getAcceptShortPacket() {
        return this.acceptShortPacket;
    }

    @Override
    public void setAcceptShortPacket(boolean bl) {
        this.acceptShortPacket = bl;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void setComplete(boolean bl) {
        this.complete = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        this.setComplete(true);
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilComplete() {
        Object object = this.waitLock;
        synchronized (object) {
            while (!this.isComplete()) {
                try {
                    this.waitLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilComplete(long l) {
        if (0L >= l) {
            this.waitUntilComplete();
            return;
        }
        long l2 = System.currentTimeMillis();
        Object object = this.waitLock;
        synchronized (object) {
            if (!this.isComplete() && System.currentTimeMillis() - l2 < l) {
                try {
                    this.waitLock.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

