/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.mbsa;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tigris.mtoolkit.iagent.internal.mbsa.DataFormater;
import org.tigris.mtoolkit.iagent.mbsa.MBSAException;

public abstract class MBSAWriter {
    private byte[] data;
    private ByteArrayOutputStream output = new ByteArrayOutputStream(64);

    public MBSAWriter() {
        this(null);
    }

    public MBSAWriter(byte[] data) {
        this.data = data;
    }

    public MBSAWriter writeByte(byte b) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeByte(this.output, b);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeByteArray(byte[] ba) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeByteArray(this.output, ba);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeShort(short sh) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeShort(this.output, sh);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeShortArray(short[] sha) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeShortArray(this.output, sha);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeInt(int i) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeInt(this.output, i);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeIntArray(int[] ia) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeIntArray(this.output, ia);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeLong(long l) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeLong(this.output, l);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeLongArray(long[] la) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeLongArray(this.output, la);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeWord(short w) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeWord(this.output, w);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeWordArray(short[] wa) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeWordArray(this.output, wa);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeDWord(int dw) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeDWord(this.output, dw);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeDWordArray(int[] dwa) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeDWordArray(this.output, dwa);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeQWord(long qw) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeQWord(this.output, qw);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeQWordArray(long[] qwa) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeQWordArray(this.output, qwa);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeString(String s) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeString(this.output, s);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeStringArray(String[] sa) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeStringArray(this.output, sa);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeChar(byte c) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeChar(this.output, c);
        }
        catch (IOException iOException) {}
        return this;
    }

    public MBSAWriter writeCharArray(byte[] ca) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        try {
            DataFormater.writeCharArray(this.output, ca);
        }
        catch (IOException iOException) {}
        return this;
    }

    protected void flush() {
        if (this.data == null) {
            this.data = this.output.toByteArray();
        }
    }

    public void validate() {
        if (this.data == null) {
            throw new IllegalStateException("Cannot write response to output, until it is flushed.");
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        this.validate();
        DataFormater.writeInt(os, this.data.length);
        os.write(this.data);
    }

    public byte[] getData() throws MBSAException {
        this.validate();
        byte[] copy = new byte[this.data.length];
        System.arraycopy(this.data, 0, copy, 0, this.data.length);
        return copy;
    }
}

