/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static final Logger s_logger = LoggerFactory.getLogger(NetUtil.class);

    public static String hardwareAddressToString(byte[] macAddress) {
        if (macAddress == null) {
            return "N/A";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < macAddress.length) {
            sb.append(String.format("%02X%s", macAddress[i], i < macAddress.length - 1 ? ":" : ""));
            ++i;
        }
        return sb.toString();
    }

    public static byte[] hardwareAddressToBytes(String macAddress) {
        if (macAddress == null || macAddress.isEmpty()) {
            return new byte[6];
        }
        macAddress = macAddress.replaceAll(":", "");
        byte[] mac = new byte[6];
        int i = 0;
        while (i < 6) {
            mac[i] = (byte)((Character.digit(macAddress.charAt(i * 2), 16) << 4) + Character.digit(macAddress.charAt(i * 2 + 1), 16));
            ++i;
        }
        return mac;
    }

    public static String getPrimaryMacAddress() {
        NetworkInterface firstInterface = null;
        Enumeration<NetworkInterface> nifs = null;
        try {
            NetworkInterface nif;
            nifs = NetworkInterface.getNetworkInterfaces();
            if (nifs != null) {
                while (nifs.hasMoreElements()) {
                    nif = nifs.nextElement();
                    if (!"eth0".equals(nif.getName()) && !"en0".equals(nif.getName())) continue;
                    return NetUtil.hardwareAddressToString(nif.getHardwareAddress());
                }
            }
            if ((nifs = NetworkInterface.getNetworkInterfaces()) != null) {
                while (nifs.hasMoreElements()) {
                    nif = nifs.nextElement();
                    if (nif.isVirtual() || nif.getHardwareAddress() == null) continue;
                    firstInterface = nif;
                    if (!nif.getName().startsWith("eth") && !nif.getName().startsWith("en")) continue;
                    return NetUtil.hardwareAddressToString(nif.getHardwareAddress());
                }
            }
            if (firstInterface != null) {
                return NetUtil.hardwareAddressToString(firstInterface.getHardwareAddress());
            }
        }
        catch (Exception e) {
            s_logger.warn("Exception while getting current IP", (Throwable)e);
        }
        return null;
    }

    public static InetAddress getCurrentInetAddress() {
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            if (nifs != null) {
                while (nifs.hasMoreElements()) {
                    NetworkInterface nif = nifs.nextElement();
                    if (nif.isLoopback() || !nif.isUp() || nif.isVirtual() || nif.getHardwareAddress() == null) continue;
                    Enumeration<InetAddress> nadrs = nif.getInetAddresses();
                    while (nadrs.hasMoreElements()) {
                        InetAddress adr = nadrs.nextElement();
                        if (adr == null || adr.isLoopbackAddress() || !nif.isPointToPoint() && adr.isLinkLocalAddress()) continue;
                        return adr;
                    }
                }
            }
        }
        catch (Exception e) {
            s_logger.warn("Exception while getting current IP", (Throwable)e);
        }
        return null;
    }
}

