/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.ssl;

import java.util.Map;

public class SslManagerServiceOptions {
    private static final String PROP_PROTOCOL = "ssl.default.protocol";
    private static final String PROP_TRUST_STORE = "ssl.default.trustStore";
    private static final String PROP_KEY_STORE = "ssl.default.keyStore";
    private static final String PROP_CIPHERS = "ssl.default.cipherSuites";
    private static final String PROP_HN_VERIFY = "ssl.hostname.verification";
    private static final String PROP_DEFAULT_PROTOCOL = "TLSv1";
    private static final Boolean PROP_DEFAULT_HN_VERIFY = true;
    private static final String PROP_DEFAULT_TRUST_STORE = "/opt/eurotech/security/cacerts";
    private static final String PROP_DEFAULT_KEY_STORE = "/opt/eurotech/security/keystore";
    private Map<String, Object> m_properties;

    SslManagerServiceOptions(Map<String, Object> properties) {
        this.m_properties = properties;
    }

    public String getSslProtocol() {
        if (this.m_properties != null && this.m_properties.get(PROP_PROTOCOL) != null && this.m_properties.get(PROP_PROTOCOL) instanceof String) {
            return (String)this.m_properties.get(PROP_PROTOCOL);
        }
        return PROP_DEFAULT_PROTOCOL;
    }

    public String getSslTrustStore() {
        if (this.m_properties != null && this.m_properties.get(PROP_TRUST_STORE) != null && this.m_properties.get(PROP_TRUST_STORE) instanceof String) {
            return (String)this.m_properties.get(PROP_TRUST_STORE);
        }
        return PROP_DEFAULT_TRUST_STORE;
    }

    public String getSslKeyStore() {
        if (this.m_properties != null && this.m_properties.get(PROP_KEY_STORE) != null && this.m_properties.get(PROP_KEY_STORE) instanceof String) {
            return (String)this.m_properties.get(PROP_KEY_STORE);
        }
        return PROP_DEFAULT_KEY_STORE;
    }

    public String getSslCiphers() {
        if (this.m_properties != null && this.m_properties.get(PROP_CIPHERS) != null && this.m_properties.get(PROP_CIPHERS) instanceof String) {
            return (String)this.m_properties.get(PROP_CIPHERS);
        }
        return null;
    }

    public Boolean isSslHostnameVerification() {
        if (this.m_properties != null && this.m_properties.get(PROP_HN_VERIFY) != null && this.m_properties.get(PROP_HN_VERIFY) instanceof Boolean) {
            return (Boolean)this.m_properties.get(PROP_HN_VERIFY);
        }
        return PROP_DEFAULT_HN_VERIFY;
    }
}

