/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.21.0", label="dataformat,transformation,hl7", title="FHIR XML")
@XmlRootElement(name="fhirXml")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FhirXmlDataFormat
extends DataFormatDefinition {
    @XmlTransient
    @Metadata(label="advanced")
    private Object fhirContext;
    @XmlAttribute
    @Metadata(enums="DSTU2,DSTU2_HL7ORG,DSTU2_1,DSTU3,R4", defaultValue="DSTU3")
    private String fhirVersion;

    public FhirXmlDataFormat() {
        super("fhirXml");
    }

    public Object getFhirContext() {
        return this.fhirContext;
    }

    public void setFhirContext(Object fhirContext) {
        this.fhirContext = fhirContext;
    }

    public String getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(String fhirVersion) {
        this.fhirVersion = fhirVersion;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.getContentTypeHeader() != null) {
            this.setProperty(camelContext, dataFormat, "contentTypeHeader", this.getContentTypeHeader());
        }
        if (this.getFhirContext() != null) {
            this.setProperty(camelContext, dataFormat, "fhirContext", this.getFhirContext());
        }
        if (this.getFhirVersion() != null) {
            this.setProperty(camelContext, dataFormat, "fhirVersion", this.getFhirVersion());
        }
    }
}

