/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.device;

import org.eclipse.equinox.device.DeviceMsg;
import org.eclipse.equinox.device.DeviceTracker;
import org.eclipse.equinox.device.DriverLocatorTracker;
import org.eclipse.equinox.device.DriverSelectorTracker;
import org.eclipse.equinox.device.DriverTracker;
import org.eclipse.equinox.device.LogTracker;
import org.eclipse.equinox.device.SecureAction;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer,
FrameworkListener,
Runnable {
    protected static final boolean DEBUG = false;
    protected BundleContext context;
    protected LogTracker log;
    protected volatile boolean running;
    protected Thread thread;
    protected DriverTracker drivers;
    protected DriverLocatorTracker locators;
    protected DriverSelectorTracker selectors;
    protected ServiceTracker devices;
    protected Filter deviceFilter;
    protected Filter driverFilter;
    private DeviceService head;
    private DeviceService tail;
    protected long updatewait;
    protected volatile boolean driverServiceRegistered;

    public void start(BundleContext contxt) throws Exception {
        Bundle systemBundle;
        this.context = contxt;
        this.running = false;
        this.log = new LogTracker(this.context, System.err);
        try {
            this.deviceFilter = this.context.createFilter("(|(objectClass=org.osgi.service.device.Device)(DEVICE_CATEGORY=*))");
            this.driverFilter = this.context.createFilter("(objectClass=org.osgi.service.device.Driver)");
        }
        catch (InvalidSyntaxException e) {
            this.log.log(1, NLS.bind((String)DeviceMsg.Unable_to_create_Filter_for_DeviceManager, (Object)((Object)e)));
            throw e;
        }
        this.updatewait = 5000L;
        String prop = this.context.getProperty("org.eclipse.equinox.device.updatewait");
        if (prop != null) {
            try {
                this.updatewait = Long.parseLong(prop) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((systemBundle = this.context.getBundle(0L)) != null && (systemBundle.getState() & 8) != 0) {
            this.context.addFrameworkListener((FrameworkListener)this);
        } else {
            this.startDeviceManager();
        }
        this.log.log(3, DeviceMsg.DeviceManager_started);
    }

    public void frameworkEvent(FrameworkEvent event) {
        switch (event.getType()) {
            case 1: {
                this.context.removeFrameworkListener((FrameworkListener)this);
                try {
                    this.startDeviceManager();
                    break;
                }
                catch (Throwable t) {
                    this.log.log(1, NLS.bind((String)DeviceMsg.DeviceManager_has_thrown_an_error, (Object)t));
                }
            }
        }
    }

    public void startDeviceManager() {
        if (!this.running) {
            this.head = null;
            this.tail = null;
            this.locators = new DriverLocatorTracker(this);
            this.selectors = new DriverSelectorTracker(this);
            this.drivers = new DriverTracker(this);
            this.devices = new ServiceTracker(this.context, this.deviceFilter, (ServiceTrackerCustomizer)this);
            this.devices.open();
            this.running = true;
            this.driverServiceRegistered = false;
            this.thread = new SecureAction().createThread(this, "DeviceManager");
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext contxt) throws Exception {
        this.context.removeFrameworkListener((FrameworkListener)this);
        if (this.running) {
            Thread t = this.thread;
            this.running = false;
            if (t != null) {
                t.interrupt();
                Thread thread = t;
                synchronized (thread) {
                    while (t.isAlive()) {
                        try {
                            t.wait(0L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        if (this.drivers != null) {
            this.drivers.close();
            this.drivers = null;
        }
        if (this.devices != null) {
            this.devices.close();
            this.devices = null;
        }
        if (this.locators != null) {
            this.locators.close();
            this.locators = null;
        }
        if (this.selectors != null) {
            this.selectors.close();
            this.selectors = null;
        }
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
        this.context = null;
    }

    public Object addingService(ServiceReference reference) {
        this.enqueue(new DeviceTracker(this, reference));
        return reference;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object object) {
    }

    public void refineIdleDevices() {
        ServiceReference[] references = this.devices.getServiceReferences();
        if (references != null) {
            int size = references.length;
            int i = 0;
            while (i < size) {
                ServiceReference device = references[i];
                this.enqueue(new DeviceTracker(this, device));
                ++i;
            }
        }
    }

    public void run() {
        while (this.running) {
            DeviceTracker device;
            try {
                device = this.dequeue();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            try {
                device.refine();
            }
            catch (Throwable t) {
                this.log.log(1, NLS.bind((String)DeviceMsg.DeviceManager_has_thrown_an_error, (Object)t));
            }
        }
    }

    public synchronized void enqueue(DeviceTracker device) {
        if (device != null) {
            DeviceService item = new DeviceService(device);
            if (this.head == null) {
                this.head = item;
                this.tail = item;
            } else {
                this.tail.next = item;
                this.tail = item;
            }
        }
        this.notify();
    }

    private synchronized DeviceTracker dequeue() throws InterruptedException {
        while (this.running && this.head == null) {
            this.locators.uninstallDriverBundles();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.running) {
            throw new InterruptedException();
        }
        DeviceService item = this.head;
        this.head = item.next;
        if (this.head == null) {
            this.tail = null;
        }
        return item.device;
    }

    static class DeviceService {
        final DeviceTracker device;
        DeviceService next;

        DeviceService(DeviceTracker device) {
            this.device = device;
            this.next = null;
        }
    }
}

