/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.drivers.assets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.configuration.HasConfiguration;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.AlertDialog;
import org.gwtbootstrap3.client.ui.Button;

public class ConfigurationUiButtons
extends Composite
implements HasConfiguration.Listener {
    private static ConfigurationUiButtonsUiBinder uiBinder = (ConfigurationUiButtonsUiBinder)GWT.create(ConfigurationUiButtonsUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    @UiField
    Button btnApply;
    @UiField
    Button btnReset;
    @UiField
    AlertDialog confirmDialog;
    private Listener listener;

    public ConfigurationUiButtons(HasConfiguration target) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.btnApply.setEnabled(target.isDirty());
        this.btnReset.setEnabled(target.isDirty());
        target.setListener(this);
        this.btnApply.addClickHandler(event -> {
            if (this.listener == null) {
                return;
            }
            if (!target.isValid()) {
                this.confirmDialog.show(MSGS.formWithErrorsOrIncomplete(), AlertDialog.Severity.ALERT, null);
                return;
            }
            this.confirmDialog.show(MSGS.deviceConfigConfirmationNoName(), () -> this.listener.onApply());
        });
        this.btnReset.addClickHandler(event -> {
            if (this.listener == null) {
                return;
            }
            this.confirmDialog.show(MSGS.deviceConfigDirty(), () -> this.listener.onReset());
        });
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public void onConfigurationChanged(HasConfiguration hasConfiguration) {
    }

    @Override
    public void onDirtyStateChanged(HasConfiguration hasConfiguration) {
        boolean isDirty = hasConfiguration.isDirty();
        this.btnApply.setEnabled(isDirty);
        this.btnReset.setEnabled(isDirty);
    }

    static interface ConfigurationUiButtonsUiBinder
    extends UiBinder<Widget, ConfigurationUiButtons> {
    }

    public static interface Listener {
        public void onApply();

        public void onReset();
    }
}

