/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.cloud.factory.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.script.ScriptException;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ServiceStatus;
import org.apache.camel.core.osgi.OsgiDefaultCamelContext;
import org.apache.camel.core.osgi.OsgiServiceRegistry;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.Registry;
import org.eclipse.kura.camel.bean.PayloadFactory;
import org.eclipse.kura.camel.camelcloud.DefaultCamelCloudService;
import org.eclipse.kura.camel.cloud.KuraCloudComponent;
import org.eclipse.kura.camel.cloud.factory.internal.ServiceConfiguration;
import org.eclipse.kura.camel.utils.CamelContexts;
import org.eclipse.kura.cloud.CloudService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlCamelCloudService {
    private static final Logger logger = LoggerFactory.getLogger(XmlCamelCloudService.class);
    private final BundleContext context;
    private final String pid;
    private final ServiceConfiguration configuration;
    private DefaultCamelCloudService service;
    private OsgiDefaultCamelContext router;
    private ServiceRegistration<CloudService> handle;

    public XmlCamelCloudService(BundleContext context, String pid, ServiceConfiguration configuration) {
        this.context = context;
        this.pid = pid;
        this.configuration = configuration;
    }

    public void start() throws Exception {
        SimpleRegistry simpleRegistry = new SimpleRegistry();
        simpleRegistry.put((Object)"payloadFactory", (Object)new PayloadFactory());
        CompositeRegistry registry = new CompositeRegistry();
        registry.addRegistry((Registry)new OsgiServiceRegistry(this.context));
        registry.addRegistry((Registry)simpleRegistry);
        this.router = new OsgiDefaultCamelContext(this.context, (Registry)registry);
        if (!this.configuration.isEnableJmx()) {
            this.router.disableJMX();
        }
        this.callInitCode((CamelContext)this.router);
        this.service = new DefaultCamelCloudService((CamelContext)this.router);
        KuraCloudComponent cloudComponent = new KuraCloudComponent((CamelContext)this.router, (CloudService)this.service);
        this.router.addComponent("kura-cloud", (Component)cloudComponent);
        RoutesDefinition routesDefinition = this.router.loadRoutesDefinition((InputStream)new ByteArrayInputStream(this.configuration.getXml().getBytes()));
        this.router.addRouteDefinitions((Collection)routesDefinition.getRoutes());
        logger.debug("Starting router...");
        this.router.start();
        ServiceStatus status = this.router.getStatus();
        logger.debug("Starting router... {} ({}, {})", new Object[]{status, status == ServiceStatus.Started, this.service.isConnected()});
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", this.pid);
        ((Dictionary)props).put("service.factoryPid", "org.eclipse.kura.camel.cloud.factory.CamelFactory");
        ((Dictionary)props).put("kura.service.pid", this.pid);
        ((Dictionary)props).put("kura.cloud.service.factory.pid", "org.eclipse.kura.camel.cloud.factory.CamelCloudServiceFactory");
        this.handle = this.context.registerService(CloudService.class, (Object)this.service, props);
    }

    public void stop() throws Exception {
        if (this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
        if (this.service != null) {
            this.service.dispose();
            this.service = null;
        }
        if (this.router != null) {
            this.router.stop();
            this.router = null;
        }
    }

    private void callInitCode(CamelContext router) throws ScriptException {
        CamelContexts.scriptInitCamelContext((CamelContext)router, (String)this.configuration.getInitCode(), (ClassLoader)XmlCamelCloudService.class.getClassLoader());
    }
}

