/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloudconnection.raw.mqtt.subscriber;

import java.util.Map;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.raw.mqtt.cloud.Qos;
import org.eclipse.kura.cloudconnecton.raw.mqtt.util.Property;
import org.eclipse.kura.core.util.MqttTopicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeOptions {
    private static final Logger logger = LoggerFactory.getLogger(SubscribeOptions.class);
    public static final Property<String> TOPIC_FILTER_PROP = new Property<String>("topic.filter", String.class).validate(SubscribeOptions::validateTopicFilter);
    public static final Property<Qos> QOS_PROP = new Property<Integer>("qos", 0).map(Qos.class, Qos::valueOf);
    private final String topicFilter;
    private final Qos qos;

    public SubscribeOptions(Map<String, Object> properties) throws KuraException {
        this.topicFilter = TOPIC_FILTER_PROP.get(properties);
        this.qos = QOS_PROP.get(properties);
    }

    public String getTopicFilter() {
        return this.topicFilter;
    }

    public Qos getQos() {
        return this.qos;
    }

    private static boolean validateTopicFilter(String filter) {
        try {
            MqttTopicUtil.validate((String)filter, (boolean)true);
            return true;
        }
        catch (Exception e) {
            logger.warn("invalid topic filter", (Throwable)e);
            return false;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.qos == null ? 0 : this.qos.hashCode());
        result = 31 * result + (this.topicFilter == null ? 0 : this.topicFilter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscribeOptions other = (SubscribeOptions)obj;
        if (this.qos != other.qos) {
            return false;
        }
        return !(this.topicFilter == null ? other.topicFilter != null : !this.topicFilter.equals(other.topicFilter));
    }
}

