/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.channel;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.annotation.NotThreadSafe;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ChannelType;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@NotThreadSafe
@ProviderType
public class Channel {
    private final transient Map<String, Object> configuration;
    private String name;
    private ChannelType type;
    private DataType valueType;
    private double valueScale;
    private double valueOffset;
    private String unit;
    private boolean isEnabled = true;

    public Channel(String name, ChannelType type, DataType valueType, Map<String, Object> config) {
        Objects.requireNonNull(name, "Channel name cannot be null");
        Objects.requireNonNull(type, "Channel type cannot be null");
        Objects.requireNonNull(valueType, "Channel value type cannot be null");
        Objects.requireNonNull(config, "Channel configuration cannot be null");
        this.configuration = Collections.unmodifiableMap(config);
        this.name = name;
        this.type = type;
        this.valueType = valueType;
        this.valueScale = 1.0;
        this.valueOffset = 0.0;
        this.unit = "";
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public ChannelType getType() {
        return this.type;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public double getValueScale() {
        return this.valueScale;
    }

    public double getValueOffset() {
        return this.valueOffset;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setName(String name) {
        Objects.requireNonNull(name, "Channel name cannot be null");
        this.name = name;
    }

    public void setType(ChannelType type) {
        Objects.requireNonNull(type, "Channel type cannot be null");
        this.type = type;
    }

    public void setValueType(DataType valueType) {
        Objects.requireNonNull(valueType, "Channel value type cannot be null");
        this.valueType = valueType;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setScale(double scale) {
        this.valueScale = scale;
    }

    public void setOffset(double offset) {
        this.valueOffset = offset;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String toString() {
        return "Channel [configuration=" + this.configuration + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", valueType=" + (Object)((Object)this.valueType) + ", valueScale=" + this.valueScale + ", valueOffset=" + this.valueOffset + ", valueType=" + (Object)((Object)this.valueType) + ", unit=" + this.unit + "]";
    }

    public ChannelRecord createReadRecord() {
        ChannelRecord result = ChannelRecord.createReadRecord(this.name, this.valueType, this.unit);
        result.setChannelConfig(this.configuration);
        return result;
    }

    public ChannelRecord createWriteRecord(TypedValue<?> value) {
        Objects.requireNonNull(value, "Value cannot be null");
        if (value.getType() != this.valueType) {
            throw new IllegalArgumentException("The value type of the argument must match the channel value type");
        }
        ChannelRecord result = ChannelRecord.createWriteRecord(this.name, value);
        result.setChannelConfig(this.configuration);
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isEnabled ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.valueOffset);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.valueScale);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.valueType == null ? 0 : this.valueType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Channel other = (Channel)obj;
        if (this.isEnabled != other.isEnabled) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        if (Double.doubleToLongBits(this.valueOffset) != Double.doubleToLongBits(other.valueOffset)) {
            return false;
        }
        if (Double.doubleToLongBits(this.valueScale) != Double.doubleToLongBits(other.valueScale)) {
            return false;
        }
        return this.valueType == other.valueType;
    }
}

