/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore.rest.provider;

import java.util.List;
import java.util.Objects;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.kura.core.keystore.rest.provider.CsrReadRequest;
import org.eclipse.kura.core.keystore.rest.provider.CsrResponse;
import org.eclipse.kura.core.keystore.rest.provider.DeleteRequest;
import org.eclipse.kura.core.keystore.rest.provider.KeyPairWriteRequest;
import org.eclipse.kura.core.keystore.rest.provider.TrustedCertificateWriteRequest;
import org.eclipse.kura.core.keystore.util.EntryInfo;
import org.eclipse.kura.core.keystore.util.KeystoreRemoteService;
import org.eclipse.kura.rest.utils.Validable;
import org.eclipse.kura.security.keystore.KeystoreInfo;
import org.osgi.service.useradmin.UserAdmin;

@Path(value="/keystores/v1")
public class KeystoreRestService
extends KeystoreRemoteService {
    private static final String BAD_REQUEST_MESSAGE = "Bad request, ";
    private static final String BAD_WRITE_REQUEST_ERROR_MESSAGE = "Bad request, expected request format: {\"keystoreServicePid\": \"MyKeystoreName\", \"alias\": \"MyAlias\", \"type\": \"TrustedCertificate\", \"certificate\": \"...\"}";
    private static final String BAD_GET_CSR_REQUEST_ERROR_MESSAGE = "Bad request, expected request format: {\"keystoreServicePid\": \"MyKeystoreName\", \"alias\": \"MyAlias\", \"signatureAlgorithm\": \"...\", \"attributes\": \"...\"}";
    private static final String BAD_DELETE_REQUEST_ERROR_MESSAGE = "Bad request, expected request format: {\"keystoreServicePid\": \"MyKeystoreName\", \"alias\": \"MyAlias\"}";

    public void setUserAdmin(UserAdmin userAdmin) {
        userAdmin.createRole("kura.permission.rest.keystores", 2);
    }

    @GET
    @RolesAllowed(value={"keystores"})
    @Produces(value={"application/json"})
    public List<KeystoreInfo> listKeystores() {
        return this.listKeystoresInternal();
    }

    @GET
    @Path(value="/entries")
    @RolesAllowed(value={"keystores"})
    @Produces(value={"application/json"})
    public List<EntryInfo> getEntries(@QueryParam(value="keystoreServicePid") String keystoreServicePid, @QueryParam(value="alias") String alias) {
        if (Objects.isNull(keystoreServicePid) && Objects.isNull(alias)) {
            return this.getKeysInternal();
        }
        if (!Objects.isNull(keystoreServicePid)) {
            return this.getKeysByPidInternal(keystoreServicePid);
        }
        return this.getKeysByAliasInternal(alias);
    }

    @GET
    @Path(value="/entries/entry")
    @RolesAllowed(value={"keystores"})
    @Produces(value={"application/json"})
    public EntryInfo getEntry(@QueryParam(value="keystoreServicePid") String keystoreServicePid, @QueryParam(value="alias") String alias) {
        return this.getKeyInternal(keystoreServicePid, alias);
    }

    @POST
    @Path(value="/entries/csr")
    @RolesAllowed(value={"keystores"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CsrResponse getCSR(CsrReadRequest csrReadRequest) {
        Validable.validate((Validable)csrReadRequest, (String)BAD_GET_CSR_REQUEST_ERROR_MESSAGE);
        return new CsrResponse(this.getCSRInternal(csrReadRequest));
    }

    @POST
    @Path(value="/entries/certificate")
    @RolesAllowed(value={"keystores"})
    @Consumes(value={"application/json"})
    public void storeTrustedCertificateEntry(TrustedCertificateWriteRequest writeRequest) {
        Validable.validate((Validable)writeRequest, (String)BAD_WRITE_REQUEST_ERROR_MESSAGE);
        this.storeTrustedCertificateEntryInternal(writeRequest);
    }

    @POST
    @Path(value="/entries/keypair")
    @RolesAllowed(value={"keystores"})
    @Consumes(value={"application/json"})
    public void storeKeypairEntry(KeyPairWriteRequest writeRequest) {
        Validable.validate((Validable)writeRequest, (String)BAD_WRITE_REQUEST_ERROR_MESSAGE);
        this.storeKeyPairEntryInternal(writeRequest);
    }

    @DELETE
    @Path(value="/entries")
    @RolesAllowed(value={"keystores"})
    @Consumes(value={"application/json"})
    public void deleteKeyEntry(DeleteRequest deleteRequest) {
        Validable.validate((Validable)deleteRequest, (String)BAD_DELETE_REQUEST_ERROR_MESSAGE);
        this.deleteKeyEntryInternal(deleteRequest.getKeystoreServicePid(), deleteRequest.getAlias());
    }
}

