/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLUtil {
    private static final Logger logger = LoggerFactory.getLogger(CRLUtil.class);

    private CRLUtil() {
    }

    /*
     * Exception decompiling
     */
    public static Set<URI> getCrlURIs(X509Certificate cert) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static CompletableFuture<X509CRL> fetchCRL(Set<URI> uris, ExecutorService executor) {
        CompletableFuture<X509CRL> result = new CompletableFuture<X509CRL>();
        executor.execute(() -> {
            for (URI uri : uris) {
                logger.info("fetching CRL from: {}...", (Object)uri);
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStream in = CRLUtil.openConnection(uri);){
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        X509CRL crl = (X509CRL)cf.generateCRL(in);
                        logger.info("fetching CRL from: {}...done", (Object)uri);
                        result.complete(crl);
                        return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    logger.warn("failed to fetch CRL from {}", (Object)uri, (Object)e);
                    if (!Thread.interrupted()) continue;
                    logger.warn("interrupted");
                    result.completeExceptionally(new InterruptedException());
                    return;
                }
            }
            result.completeExceptionally(new IOException("failed to download CRL from: " + uris));
        });
        return result;
    }

    private static InputStream openConnection(URI uri) throws IOException {
        URLConnection connection = uri.toURL().openConnection();
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setRequestProperty("Accept", "*/*");
            ((HttpURLConnection)connection).setRequestProperty("Connection", "Close");
        }
        return connection.getInputStream();
    }

    private static Optional<URI> parseURI(String value) {
        try {
            return Optional.of(new URI(value));
        }
        catch (Exception e) {
            logger.warn("failed to parse distribution point URL", (Throwable)e);
            return Optional.empty();
        }
    }
}

