/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLEngine;
import org.bouncycastle.jsse.provider.ProvSSLEngine_8;
import org.bouncycastle.jsse.provider.ReflectionUtil;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.SSLSessionUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLEngineUtil {
    private static final Method getHandshakeSession;
    private static final Method getSSLParameters;
    private static final boolean useEngine8;

    SSLEngineUtil() {
    }

    static SSLEngine create(ContextData contextData) {
        return useEngine8 ? new ProvSSLEngine_8(contextData) : new ProvSSLEngine(contextData);
    }

    static SSLEngine create(ContextData contextData, String string, int n) {
        return useEngine8 ? new ProvSSLEngine_8(contextData, string, n) : new ProvSSLEngine(contextData, string, n);
    }

    static BCExtendedSSLSession importHandshakeSession(SSLEngine sSLEngine) {
        SSLSession sSLSession;
        if (sSLEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sSLEngine)).getBCHandshakeSession();
        }
        if (null != sSLEngine && null != getHandshakeSession && null != (sSLSession = (SSLSession)ReflectionUtil.invokeGetter(sSLEngine, getHandshakeSession))) {
            return SSLSessionUtil.importSSLSession(sSLSession);
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLEngine sSLEngine) {
        if (sSLEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sSLEngine)).getParameters();
        }
        if (null == sSLEngine || null == getSSLParameters) {
            return null;
        }
        SSLParameters sSLParameters = (SSLParameters)ReflectionUtil.invokeGetter(sSLEngine, getSSLParameters);
        if (null == sSLParameters) {
            throw new RuntimeException("SSLEngine.getSSLParameters returned null");
        }
        return SSLParametersUtil.importSSLParameters(sSLParameters);
    }

    static {
        Method[] methodArray = ReflectionUtil.getMethods("javax.net.ssl.SSLEngine");
        getHandshakeSession = ReflectionUtil.findMethod(methodArray, "getHandshakeSession");
        getSSLParameters = ReflectionUtil.findMethod(methodArray, "getSSLParameters");
        useEngine8 = ReflectionUtil.hasMethod(methodArray, "getApplicationProtocol");
    }
}

