/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsMapContaining<K, V>
extends TypeSafeMatcher<Map<K, V>> {
    private final Matcher<K> keyMatcher;
    private final Matcher<V> valueMatcher;

    public IsMapContaining(Matcher<K> keyMatcher, Matcher<V> valueMatcher) {
        this.keyMatcher = keyMatcher;
        this.valueMatcher = valueMatcher;
    }

    @Override
    public boolean matchesSafely(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!this.keyMatcher.matches(entry.getKey()) || !this.valueMatcher.matches(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("map containing [").appendDescriptionOf(this.keyMatcher).appendText("->").appendDescriptionOf(this.valueMatcher).appendText("]");
    }

    @Factory
    public static <K, V> Matcher<Map<K, V>> hasEntry(Matcher<K> keyMatcher, Matcher<V> valueMatcher) {
        return new IsMapContaining<K, V>(keyMatcher, valueMatcher);
    }

    @Factory
    public static <K, V> Matcher<Map<K, V>> hasEntry(K key, V value) {
        return IsMapContaining.hasEntry(IsEqual.equalTo(key), IsEqual.equalTo(value));
    }

    @Factory
    public static <K, V> Matcher<Map<K, V>> hasKey(Matcher<K> keyMatcher) {
        return IsMapContaining.hasEntry(keyMatcher, IsAnything.anything());
    }

    @Factory
    public static <K, V> Matcher<Map<K, V>> hasKey(K key) {
        return IsMapContaining.hasKey(IsEqual.equalTo(key));
    }

    @Factory
    public static <K, V> Matcher<Map<K, V>> hasValue(Matcher<V> valueMatcher) {
        return IsMapContaining.hasEntry(IsAnything.anything(), valueMatcher);
    }

    @Factory
    public static <K, V> Matcher<Map<K, V>> hasValue(V value) {
        return IsMapContaining.hasValue(IsEqual.equalTo(value));
    }
}

