/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.linux.executor.privileged;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.io.Charsets;
import org.eclipse.kura.core.internal.linux.executor.ExecutorUtil;
import org.eclipse.kura.core.linux.executor.LinuxExitStatus;
import org.eclipse.kura.core.linux.executor.LinuxSignal;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandStatus;
import org.eclipse.kura.executor.ExitStatus;
import org.eclipse.kura.executor.Pid;
import org.eclipse.kura.executor.PrivilegedExecutorService;
import org.eclipse.kura.executor.Signal;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegedExecutorServiceImpl
implements PrivilegedExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(PrivilegedExecutorServiceImpl.class);
    private static final LinuxSignal DEFAULT_SIGNAL = LinuxSignal.SIGTERM;
    private ExecutorUtil executorUtil;
    private ComponentContext ctx;

    public void activate(ComponentContext componentContext) {
        logger.info("activate...");
        this.ctx = componentContext;
        this.executorUtil = new ExecutorUtil();
    }

    public void deactivate(ComponentContext componentContext) {
        logger.info("deactivate...");
        this.ctx = null;
    }

    public CommandStatus execute(Command command) {
        if (command.getCommandLine() == null || command.getCommandLine().length == 0) {
            return this.buildErrorStatus(command);
        }
        if (command.getSignal() == null) {
            command.setSignal((Signal)DEFAULT_SIGNAL);
        }
        return this.executorUtil.executePrivileged(command);
    }

    public void execute(Command command, Consumer<CommandStatus> callback) {
        if (command.getCommandLine() == null || command.getCommandLine().length == 0) {
            callback.accept(this.buildErrorStatus(command));
            return;
        }
        if (command.getSignal() == null) {
            command.setSignal((Signal)DEFAULT_SIGNAL);
        }
        this.executorUtil.executePrivileged(command, callback);
    }

    public boolean stop(Pid pid, Signal signal) {
        boolean isStopped = false;
        isStopped = signal == null ? this.executorUtil.stopPrivileged(pid, DEFAULT_SIGNAL) : this.executorUtil.stopPrivileged(pid, signal);
        return isStopped;
    }

    public boolean kill(String[] commandLine, Signal signal) {
        boolean isKilled = false;
        isKilled = signal == null ? this.executorUtil.killPrivileged(commandLine, DEFAULT_SIGNAL) : this.executorUtil.killPrivileged(commandLine, signal);
        return isKilled;
    }

    public boolean isRunning(Pid pid) {
        return this.executorUtil.isRunning(pid);
    }

    public boolean isRunning(String[] commandLine) {
        return this.executorUtil.isRunning(commandLine);
    }

    public Map<String, Pid> getPids(String[] commandLine) {
        return this.executorUtil.getPids(commandLine);
    }

    private CommandStatus buildErrorStatus(Command command) {
        CommandStatus status = new CommandStatus(command, (ExitStatus)new LinuxExitStatus(1));
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            err.write("The commandLine cannot be empty or not defined".getBytes(Charsets.UTF_8));
        }
        catch (IOException e) {
            logger.error("Cannot write to error stream", (Throwable)e);
        }
        status.setErrorStream((OutputStream)err);
        return status;
    }
}

