/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.broker.artemis.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public final class UserAuthentication {
    private final String defaultUser;
    private final Set<User> users;

    private UserAuthentication(String defaultUser, Set<User> users) {
        this.defaultUser = defaultUser;
        this.users = Collections.unmodifiableSet(users);
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    /* synthetic */ UserAuthentication(String string, Set set, UserAuthentication userAuthentication) {
        this(string, set);
    }

    public static class Builder {
        private String defaultUser;
        private final Set<User> users = new HashSet<User>();

        public Builder defaultUser(String defaultUser) {
            this.defaultUser = defaultUser;
            return this;
        }

        public Builder addUser(String name, String password, Set<String> roles) {
            return this.addUser(new User(name, password, roles));
        }

        public Builder addUser(User user) {
            this.users.add(Objects.requireNonNull(user));
            return this;
        }

        public Builder parseUsers(String string) {
            if (string == null || string.isEmpty()) {
                return this;
            }
            Properties p = new Properties();
            try {
                p.load(new StringReader(string));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (String key : p.stringPropertyNames()) {
                String value = p.getProperty(key);
                String[] toks = value.split("\\|", 2);
                if (toks.length != 2) continue;
                String password = toks[0];
                String[] roles = toks[1].split("\\s*,\\s*");
                this.addUser(key, password, new HashSet<String>(Arrays.asList(roles)));
            }
            return this;
        }

        public UserAuthentication build() {
            return new UserAuthentication(this.defaultUser, this.users, null);
        }
    }

    public static class User {
        private final String name;
        private final String password;
        private final Set<String> roles;

        public User(String name, String password, Set<String> roles) {
            this.name = Objects.requireNonNull(name);
            this.password = Objects.requireNonNull(password);
            this.roles = Collections.unmodifiableSet(new HashSet(Objects.requireNonNull(roles)));
        }

        public String getName() {
            return this.name;
        }

        public String getPassword() {
            return this.password;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            User other = (User)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

