/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.ContentModelPlugin;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lemminx.settings.AllXMLSettings;
import org.eclipse.lemminx.settings.InitializationOptionsSettings;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.InitializeParams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLFileAssociationsDiagnosticsTest
extends AbstractCacheBasedTest {
    @Test
    public void validationOnRoot() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setRootURI("src/test/resources/xsd/");
            contentModelManager.setFileAssociations(XMLFileAssociationsDiagnosticsTest.createXSDAssociationsNoNamespaceSchemaLocationLike(""));
        };
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n  <Bad-Root></Bad-Root>";
        XMLFileAssociationsDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.d(1, 3, 1, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n  <Configuration></Configuration>";
        XMLFileAssociationsDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/Test.Format.ps1xml", configuration, new Diagnostic[0]);
    }

    @Test
    public void testNoValidationOnFileAssociationNotChanged() throws BadLocationException {
        String json1 = "{\r\n\t\"settings\": {\r\n\t\t\"xml\": {\r\n\t\t\t\"fileAssociations\": [\r\n\t\t\t\t{\r\n\t\t\t\t\t\"systemId\": \"src\\\\test\\\\resources\\\\xsd\\\\spring-beans-3.0.xsd\",\r\n\t\t\t\t\t\"pattern\": \"**/test*.xml\"\r\n\t\t\t\t},\r\n\t\t\t\t{\r\n\t\t\t\t\t\"systemId\": \"src\\\\test\\\\resources\\\\xsd\\\\projectDescription.xsd\",\r\n\t\t\t\t\t\"pattern\": \"projectDescription.xml\"\r\n\t\t\t\t}\r\n\t\t\t],\r\n\t\t\t\"catalogs\": [\r\n\t\t\t\t\"src\\\\test\\\\resources\\\\catalogs\\\\catalog.xml\"\r\n\t\t\t]\r\n\t\t}\r\n\t}\r\n}";
        InitializeParams params = XMLFileAssociationsDiagnosticsTest.createInitializeParams(json1);
        Object initializationOptionsSettings = InitializationOptionsSettings.getSettings((InitializeParams)params);
        Object settings = AllXMLSettings.getAllXMLSettings((Object)initializationOptionsSettings);
        ContentModelSettings cmSettings = ContentModelSettings.getContentModelXMLSettings((Object)settings);
        XMLAssert.SettingsSaveContext context = new XMLAssert.SettingsSaveContext(settings);
        ContentModelPlugin cmPlugin = new ContentModelPlugin();
        cmPlugin.start(null, new XMLExtensionsRegistry());
        cmPlugin.contentModelManager.setFileAssociations(cmSettings.getFileAssociations());
        cmPlugin.doSave((ISaveContext)context);
        boolean last = cmPlugin.contentModelManager.setFileAssociations(cmSettings.getFileAssociations());
        Assertions.assertFalse((boolean)last);
    }

    @Test
    public void testValidationOnFileAssociationUpdate() throws BadLocationException {
        String json1 = "{\r\n\t\"settings\": {\r\n\t\t\"xml\": {\r\n\t\t\t\"fileAssociations\": [\r\n\t\t\t\t{\r\n\t\t\t\t\t\"systemId\": \"src\\\\test\\\\resources\\\\xsd\\\\spring-beans-3.0.xsd\",\r\n\t\t\t\t\t\"pattern\": \"**/test*.xml\"\r\n\t\t\t\t},\r\n\t\t\t\t{\r\n\t\t\t\t\t\"systemId\": \"src\\\\test\\\\resources\\\\xsd\\\\projectDescription.xsd\",\r\n\t\t\t\t\t\"pattern\": \"projectDescription.xml\"\r\n\t\t\t\t}\r\n\t\t\t],\r\n\t\t\t\"catalogs\": [\r\n\t\t\t\t\"src\\\\test\\\\resources\\\\catalogs\\\\catalog.xml\"\r\n\t\t\t]\r\n\t\t}\r\n\t}\r\n}";
        String json2 = "{\r\n\t\"settings\": {\r\n\t\t\"xml\": {\r\n\t\t\t\"fileAssociations\": [\r\n\t\t\t\t{\r\n\t\t\t\t\t\"systemId\": \"src\\\\test\\\\resources\\\\xsd\\\\spring-beans-6000.0.xsd\",\r\n\t\t\t\t\t\"pattern\": \"**/test*.xml\"\r\n\t\t\t\t}\r\n\t\t\t],\r\n\t\t\t\"catalogs\": [\r\n\t\t\t\t\"src\\\\test\\\\resources\\\\catalogs\\\\catalog.xml\"\r\n\t\t\t]\r\n\t\t}\r\n\t}\r\n}";
        InitializeParams params = XMLFileAssociationsDiagnosticsTest.createInitializeParams(json1);
        Object initializationOptionsSettings = InitializationOptionsSettings.getSettings((InitializeParams)params);
        Object settings = AllXMLSettings.getAllXMLSettings((Object)initializationOptionsSettings);
        ContentModelSettings cmSettings = ContentModelSettings.getContentModelXMLSettings((Object)settings);
        XMLAssert.SettingsSaveContext context = new XMLAssert.SettingsSaveContext(settings);
        ContentModelPlugin cmPlugin = new ContentModelPlugin();
        cmPlugin.start(null, new XMLExtensionsRegistry());
        cmPlugin.contentModelManager.setFileAssociations(cmSettings.getFileAssociations());
        cmPlugin.doSave((ISaveContext)context);
        params = XMLFileAssociationsDiagnosticsTest.createInitializeParams(json2);
        initializationOptionsSettings = InitializationOptionsSettings.getSettings((InitializeParams)params);
        settings = AllXMLSettings.getAllXMLSettings((Object)initializationOptionsSettings);
        cmSettings = ContentModelSettings.getContentModelXMLSettings((Object)settings);
        boolean last = cmPlugin.contentModelManager.setFileAssociations(cmSettings.getFileAssociations());
        Assertions.assertTrue((boolean)last);
    }

    @Test
    public void validationOnRootWithRequiredAttr() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setRootURI("src/test/resources/xsd/");
            contentModelManager.setFileAssociations(XMLFileAssociationsDiagnosticsTest.createXSDAssociationsNoNamespaceSchemaLocationLike(""));
        };
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n  <Bad-Root></Bad-Root>";
        XMLFileAssociationsDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/resources.xml", configuration, XMLAssert.d(1, 3, 1, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n  <resources></resources>";
        XMLFileAssociationsDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/resources.xml", configuration, XMLAssert.d(1, 3, 1, 12, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_4));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n  <resources variant=\"\" ></resources>";
        XMLFileAssociationsDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/resources.xml", configuration, new Diagnostic[0]);
    }

    @Test
    public void validationAfterRoot() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setRootURI("src/test/resources/xsd/");
            contentModelManager.setFileAssociations(XMLFileAssociationsDiagnosticsTest.createXSDAssociationsNoNamespaceSchemaLocationLike(""));
        };
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<resources variant=\"\" >\r\n  <resource>\r\n  </resource>\r\n</resources>";
        XMLFileAssociationsDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/resources.xml", configuration, XMLAssert.d(2, 3, 2, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_4));
    }

    private static XMLFileAssociation[] createXSDAssociationsNoNamespaceSchemaLocationLike(String baseSystemId) {
        XMLFileAssociation format = new XMLFileAssociation();
        format.setPattern("**/*.Format.ps1xml");
        format.setSystemId(baseSystemId + "Format.xsd");
        XMLFileAssociation resources = new XMLFileAssociation();
        resources.setPattern("**/*resources*.xml");
        resources.setSystemId(baseSystemId + "resources.xsd");
        return new XMLFileAssociation[]{format, resources};
    }

    @Test
    public void validationWithExternalXSDAndNS() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLFileAssociationsDiagnosticsTest.createXSDAssociationsSchemaLocationLike("src/test/resources/xsd/"));
        };
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\">\r\n\t<XXX></XXX>\r\n</project>";
        XMLFileAssociationsDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/pom.xml", configuration, XMLAssert.d(1, 2, 1, 5, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_a));
    }

    private static XMLFileAssociation[] createXSDAssociationsSchemaLocationLike(String baseSystemId) {
        XMLFileAssociation maven = new XMLFileAssociation();
        maven.setPattern("**/pom.xml");
        maven.setSystemId(baseSystemId + "maven-4.0.0.xsd");
        return new XMLFileAssociation[]{maven};
    }

    @Test
    public void invalidXSD() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLFileAssociationsDiagnosticsTest.createXSDAssociationsSchemaLocationLike("invalid/"));
        };
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<foo>\r\n    <bar>\r\n        <meh></meh>\r\n    </bar>\r\n</foo>";
        XMLFileAssociationsDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/pom.xml", configuration, XMLAssert.d(1, 1, 1, 4, (IXMLErrorCode)XMLSchemaErrorCode.schema_reference_4), XMLAssert.d(1, 1, 1, 4, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a));
    }

    @Test
    public void validationWithExternalDTD() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLFileAssociationsDiagnosticsTest.createDTDAssociations("src/test/resources/dtd/"));
        };
        String xml = "<root />";
        XMLFileAssociationsDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/web.xml", configuration, XMLAssert.d(0, 1, 0, 5, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED));
        xml = "<web-app><bad-element /></web-app>";
        XMLFileAssociationsDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/web.xml", configuration, XMLAssert.d(0, 10, 0, 21, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED), XMLAssert.d(0, 1, 0, 8, (IXMLErrorCode)DTDErrorCode.MSG_CONTENT_INVALID));
    }

    private static XMLFileAssociation[] createDTDAssociations(String baseSystemId) {
        XMLFileAssociation webApp = new XMLFileAssociation();
        webApp.setPattern("web.xml");
        webApp.setSystemId(baseSystemId + "web-app_2_3.dtd");
        return new XMLFileAssociation[]{webApp};
    }

    private static void testDiagnosticsFor(String xml, String fileURI, Consumer<XMLLanguageService> configuration, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, null, configuration, fileURI, expected);
    }

    private static InitializeParams createInitializeParams(String json) {
        InitializeParams initializeParams = new InitializeParams();
        Object initializationOptions = new Gson().fromJson(json, JsonObject.class);
        initializeParams.setInitializationOptions(initializationOptions);
        return initializeParams;
    }
}

