/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.internal.files;

import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public final class PathPatternMatcher {
    private @Nullable List<PathMatcher> pathMatchers;
    private final String pattern;
    private final @Nullable Path basePath;

    public PathPatternMatcher(String pattern, @Nullable Path basePath) {
        this.pattern = pattern;
        this.basePath = basePath;
    }

    public String getPattern() {
        return this.pattern;
    }

    public @Nullable Path getBasePath() {
        return this.basePath;
    }

    public boolean matches(URI uri) {
        return this.internalMatches(Paths.get(uri));
    }

    public boolean matches(Path path) {
        return this.internalMatches(path);
    }

    private boolean internalMatches(Path pathToMatch) {
        if (this.pattern.isEmpty()) {
            return false;
        }
        List<PathMatcher> pathMatchers = this.pathMatchers;
        if (pathMatchers == null) {
            pathMatchers = this.pathMatchers = this.createPathMatchers();
        }
        for (PathMatcher pathMatcher : pathMatchers) {
            try {
                if (!pathMatcher.matches(pathToMatch)) continue;
                return true;
            }
            catch (Exception exception) {
                try {
                }
                catch (Exception exception2) {
                    // empty catch block
                    break;
                }
            }
        }
        return false;
    }

    private synchronized List<PathMatcher> createPathMatchers() {
        String glob = this.pattern.replace("\\", "/");
        List<String> expandedPatterns = PathPatternMatcher.expandPatterns(glob);
        ArrayList<PathMatcher> compiledMatchers = new ArrayList<PathMatcher>();
        for (String expandedPattern : expandedPatterns) {
            try {
                PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + expandedPattern);
                compiledMatchers.add(pathMatcher);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return compiledMatchers;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathPatternMatcher other = (PathPatternMatcher)obj;
        return Objects.equals(this.basePath, other.basePath) && Objects.equals(this.pathMatchers, other.pathMatchers) && Objects.equals(this.pattern, other.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.basePath, this.pathMatchers, this.pattern);
    }

    public static List<String> expandPatterns(String pattern) {
        Parts parts = PathPatternMatcher.getParts(pattern);
        if (parts != null) {
            ArrayList<String> expanded = new ArrayList<String>();
            List<int[]> combinations = PathPatternMatcher.generateCombinations(parts.cols().size());
            for (int[] combination : combinations) {
                ArrayList<String> expand = new ArrayList<String>(parts.parts());
                int i = 0;
                while (i < combination.length) {
                    if (combination[i] == 0) {
                        int col = parts.cols().get(i);
                        expand.set(col, "");
                    }
                    ++i;
                }
                expanded.add(String.join((CharSequence)"", expand));
            }
            return expanded;
        }
        return Collections.singletonList(pattern);
    }

    private static @Nullable Parts getParts(String pattern) {
        int from = 0;
        int index = PathPatternMatcher.getNextIndex(pattern, from);
        if (index != -1) {
            ArrayList<Integer> cols = new ArrayList<Integer>();
            ArrayList<String> parts = new ArrayList<String>();
            while (index != -1) {
                String s = pattern.substring(from, index);
                if (!s.isEmpty()) {
                    parts.add(s);
                }
                cols.add(parts.size());
                from = index + 3;
                parts.add(pattern.substring(index, from));
                index += 3;
                index = PathPatternMatcher.getNextIndex(pattern, index);
            }
            parts.add(pattern.substring(from));
            return new Parts(parts, cols);
        }
        return null;
    }

    private static int getNextIndex(String pattern, int fromIndex) {
        int startSlashIndex = pattern.indexOf("**/", fromIndex);
        int endSlashIndex = pattern.indexOf("/**", fromIndex);
        if (startSlashIndex != -1 || endSlashIndex != -1) {
            if (startSlashIndex == -1) {
                return endSlashIndex;
            }
            if (endSlashIndex == -1) {
                return startSlashIndex;
            }
            return Math.min(startSlashIndex, endSlashIndex);
        }
        return -1;
    }

    private static List<int[]> generateCombinations(int count) {
        ArrayList<int[]> combinations = new ArrayList<int[]>();
        PathPatternMatcher.generateCombinationsHelper(count, new int[count], 0, combinations);
        return combinations;
    }

    private static void generateCombinationsHelper(int count, int[] combination, int index, List<int[]> combinations) {
        if (index == count) {
            combinations.add((int[])combination.clone());
        } else {
            combination[index] = 0;
            PathPatternMatcher.generateCombinationsHelper(count, combination, index + 1, combinations);
            combination[index] = 1;
            PathPatternMatcher.generateCombinationsHelper(count, combination, index + 1, combinations);
        }
    }

    private record Parts(List<String> parts, List<Integer> cols) {
    }
}

