/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.debug.util.Preconditions;
import org.eclipse.lsp4j.debug.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

/**
 * An ExceptionFilterOptions is used to specify an exception filter together with a condition for the
 * 'setExceptionBreakpoints' request.
 * <p>
 * Since 1.43
 */
@SuppressWarnings("all")
public class ExceptionFilterOptions {
  /**
   * ID of an exception filter returned by the 'exceptionBreakpointFilters' capability.
   */
  @NonNull
  private String filterId;

  /**
   * An expression for conditional exceptions.
   * <p>
   * The exception breaks into the debugger if the result of the condition is true.
   * <p>
   * This is an optional property.
   */
  private String condition;

  /**
   * ID of an exception filter returned by the 'exceptionBreakpointFilters' capability.
   */
  @NonNull
  public String getFilterId() {
    return this.filterId;
  }

  /**
   * ID of an exception filter returned by the 'exceptionBreakpointFilters' capability.
   */
  public void setFilterId(@NonNull final String filterId) {
    this.filterId = Preconditions.checkNotNull(filterId, "filterId");
  }

  /**
   * An expression for conditional exceptions.
   * <p>
   * The exception breaks into the debugger if the result of the condition is true.
   * <p>
   * This is an optional property.
   */
  public String getCondition() {
    return this.condition;
  }

  /**
   * An expression for conditional exceptions.
   * <p>
   * The exception breaks into the debugger if the result of the condition is true.
   * <p>
   * This is an optional property.
   */
  public void setCondition(final String condition) {
    this.condition = condition;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("filterId", this.filterId);
    b.add("condition", this.condition);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ExceptionFilterOptions other = (ExceptionFilterOptions) obj;
    if (this.filterId == null) {
      if (other.filterId != null)
        return false;
    } else if (!this.filterId.equals(other.filterId))
      return false;
    if (this.condition == null) {
      if (other.condition != null)
        return false;
    } else if (!this.condition.equals(other.condition))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.filterId== null) ? 0 : this.filterId.hashCode());
    return prime * result + ((this.condition== null) ? 0 : this.condition.hashCode());
  }
}
