/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.IRepositoryCommit;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithWorkingTreeHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        if (selection.isEmpty()) {
            return null;
        }
        RevCommit commit = (RevCommit)selection.getFirstElement();
        HistoryPageInput historyInput = this.getPage(event).getInputInternal();
        Object input = historyInput.getSingleFile();
        IWorkbenchPage workbenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
        if (input instanceof IFile) {
            IFile file = (IFile)input;
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
            if (mapping != null && !mapping.getRepository().isBare()) {
                String gitPath = mapping.getRepoRelativePath((IResource)file);
                String commitPath = this.getRenamedPath(gitPath, (ObjectId)commit);
                ITypedElement right = CompareUtils.getFileRevisionTypedElement(commitPath, commit, mapping.getRepository());
                GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(SaveableCompareEditorInput.createFileElement((IFile)file), right, null);
                CompareUtils.openInCompare(workbenchPage, (CompareEditorInput)in);
            }
        } else if (input instanceof File) {
            File file = (File)input;
            Repository repo = this.getRepository(event);
            if (repo != null && !repo.isBare()) {
                String leftCommitPath = this.getRepoRelativePath(repo, file);
                String rightCommitPath = this.getRenamedPath(leftCommitPath, (ObjectId)commit);
                ITypedElement right = CompareUtils.getFileRevisionTypedElement(rightCommitPath, commit, repo);
                GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput((ITypedElement)new LocalNonWorkspaceTypedElement(repo, (IPath)new Path(file.getAbsolutePath())), right, null);
                CompareUtils.openInCompare(workbenchPage, (CompareEditorInput)in);
            }
        } else {
            Repository repo = this.getRepository(event);
            if (repo != null && !repo.isBare()) {
                File[] files;
                HashSet paths = new HashSet();
                IResource[] resources = historyInput.getItems();
                if (resources != null) {
                    Arrays.stream(resources).map(IResource::getLocation).filter(Objects::nonNull).forEach(paths::add);
                }
                if ((files = historyInput.getFileList()) != null) {
                    Arrays.stream(files).map(File::getAbsolutePath).map(Path::fromOSString).forEach(paths::add);
                }
                GitCompareEditorInput comparison = new GitCompareEditorInput(null, commit.name(), repo, paths.toArray(new IPath[0]));
                CompareUtils.openInCompare(workbenchPage, comparison);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        IStructuredSelection selection = this.getSelection(page);
        if (selection.size() != 1) {
            return false;
        }
        IRepositoryCommit commit = (IRepositoryCommit)Adapters.adapt((Object)selection.getFirstElement(), IRepositoryCommit.class);
        if (commit != null) {
            return !commit.getRepository().isBare();
        }
        return false;
    }
}

