/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.util;

import org.eclipse.gmf.runtime.common.core.internal.CommonCoreDebugOptions;
import org.eclipse.gmf.runtime.common.core.internal.CommonCorePlugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;

public class RequestCollapser {
    private Runnable request;
    private Thread thread = new PostedThread();

    protected void executeRequest(Runnable runnable) {
        runnable.run();
    }

    protected synchronized Runnable getRequest() {
        Runnable req = this.request;
        this.request = null;
        return req;
    }

    public synchronized void postRequest(Runnable runnable) {
        this.request = runnable;
        this.notify();
    }

    public RequestCollapser() {
        this.thread.setDaemon(true);
    }

    public synchronized void start() {
        this.thread.start();
    }

    public synchronized void stop() {
        this.request = null;
        this.thread.interrupt();
        this.thread = null;
    }

    private class PostedThread
    extends Thread {
        private PostedThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable req = null;
            while (!this.isInterrupted()) {
                req = null;
                RequestCollapser requestCollapser = RequestCollapser.this;
                synchronized (requestCollapser) {
                    while ((req = RequestCollapser.this.getRequest()) == null) {
                        try {
                            RequestCollapser.this.wait();
                        }
                        catch (InterruptedException ie) {
                            Trace.catching(CommonCorePlugin.getDefault(), CommonCoreDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), "run", ie);
                            Log.info(CommonCorePlugin.getDefault(), 0, "PostedThread received interruption");
                            return;
                        }
                    }
                }
                RequestCollapser.this.executeRequest(req);
            }
        }
    }
}

