/*
 * Decompiled with CFR 0.152.
 */
package adaptorinterface;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ShaclPropertyDataType implements Enumerator
{
    BOOLEAN(0, "Boolean", "Boolean"),
    STRING(1, "String", "String"),
    DATE_TIME(2, "DateTime", "DateTime"),
    XML_LITERAL(3, "XMLLiteral", "XMLLiteral"),
    RESOURCE(4, "Resource", "Resource"),
    URI(6, "URI", "URI"),
    DOUBLE(7, "Double", "Double"),
    FLOAT(8, "Float", "Float"),
    INTEGER(9, "Integer", "Integer");

    public static final int BOOLEAN_VALUE = 0;
    public static final int STRING_VALUE = 1;
    public static final int DATE_TIME_VALUE = 2;
    public static final int XML_LITERAL_VALUE = 3;
    public static final int RESOURCE_VALUE = 4;
    public static final int URI_VALUE = 6;
    public static final int DOUBLE_VALUE = 7;
    public static final int FLOAT_VALUE = 8;
    public static final int INTEGER_VALUE = 9;
    private static final ShaclPropertyDataType[] VALUES_ARRAY;
    public static final List<ShaclPropertyDataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ShaclPropertyDataType[]{BOOLEAN, STRING, DATE_TIME, XML_LITERAL, RESOURCE, URI, DOUBLE, FLOAT, INTEGER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ShaclPropertyDataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShaclPropertyDataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShaclPropertyDataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShaclPropertyDataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShaclPropertyDataType get(int value) {
        switch (value) {
            case 0: {
                return BOOLEAN;
            }
            case 1: {
                return STRING;
            }
            case 2: {
                return DATE_TIME;
            }
            case 3: {
                return XML_LITERAL;
            }
            case 4: {
                return RESOURCE;
            }
            case 6: {
                return URI;
            }
            case 7: {
                return DOUBLE;
            }
            case 8: {
                return FLOAT;
            }
            case 9: {
                return INTEGER;
            }
        }
        return null;
    }

    private ShaclPropertyDataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

