/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.transform.ecore;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemVersion;
import org.eclipse.mdht.uml.term.core.profile.ValueSetConstraint;
import org.eclipse.mdht.uml.term.core.util.CodeSystemConstraintUtil;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.mdht.uml.term.core.util.ValueSetConstraintUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.IEcoreProfileReflection;
import org.eclipse.mdht.uml.transform.ecore.TransformPropertyConstraint;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class TransformPropertyTerminologyConstraint
extends TransformPropertyConstraint {
    public TransformPropertyTerminologyConstraint(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
    }

    protected TransformPropertyConstraint.PropertyConstraintHandler createConstraintHandler(IEcoreProfileReflection.ValidationStereotypeKind stereotypeKind) {
        TransformPropertyConstraint.PropertyConstraintHandler result = null;
        switch (stereotypeKind) {
            case CODE_SYSTEM: {
                result = new CodeSystemConstraintHandler("CS");
                break;
            }
            case VALUE_SET: {
                result = new ValueSetConstraintHandler("VS");
            }
        }
        return result;
    }

    protected boolean isCodedType(Property property) {
        Classifier type = (Classifier)property.getType();
        if (type == null) {
            Property baseProperty = this.getBaseProperty(property);
            if (baseProperty != null) {
                type = (Classifier)baseProperty.getType();
            } else {
                return false;
            }
        }
        ArrayList<Classifier> allTypes = new ArrayList<Classifier>((Collection<Classifier>)type.allParents());
        allTypes.add(0, type);
        for (Classifier classifier : allTypes) {
            if (!"datatypes::CD".equals(classifier.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isSimpleCodedType(Property property) {
        return TermProfileUtil.isCSType((Property)property);
    }

    private boolean isPropAndTermNull(Property property) {
        IEcoreProfileReflection.ValidationSeverityKind propSeverity = this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.PROPERTY);
        IEcoreProfileReflection.ValidationSeverityKind csSeverity = this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.CODE_SYSTEM);
        IEcoreProfileReflection.ValidationSeverityKind vsSeverity = this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.VALUE_SET);
        return propSeverity == null && csSeverity == null && vsSeverity == null;
    }

    class CodeSystemConstraintHandler
    extends TransformPropertyConstraint.PropertyConstraintHandler {
        CodeSystemConstraintHandler(String suffix) {
            super((TransformPropertyConstraint)TransformPropertyTerminologyConstraint.this, IEcoreProfileReflection.ValidationStereotypeKind.CODE_SYSTEM, suffix);
        }

        protected boolean addAnnotation(TransformPropertyConstraint.PropertyContext context) {
            Property property = context.property();
            boolean result = false;
            String codeSystem = null;
            String codeSystemName = null;
            String codeSystemVersion = null;
            String code = null;
            String displayName = null;
            CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)property);
            if (codeSystemConstraint != null) {
                if (codeSystemConstraint.getReference() != null) {
                    codeSystem = codeSystemConstraint.getReference().getIdentifier();
                    codeSystemName = codeSystemConstraint.getReference().getEnumerationName();
                } else {
                    codeSystem = codeSystemConstraint.getIdentifier();
                    codeSystemName = codeSystemConstraint.getName();
                }
                code = codeSystemConstraint.getCode();
                displayName = codeSystemConstraint.getDisplayName();
                result = this.addAnnotation(property, IEcoreProfileReflection.ValidationStereotypeKind.CODE_SYSTEM, codeSystem, codeSystemName, code, displayName, codeSystemVersion);
            }
            return result;
        }

        protected Constraint addConstraint(TransformPropertyConstraint.PropertyContext context) {
            Property property = context.property();
            Constraint result = null;
            CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)property);
            if (codeSystemConstraint != null) {
                result = this.addVocabConstraint(context, IEcoreProfileReflection.ValidationStereotypeKind.CODE_SYSTEM, CodeSystemConstraintUtil.getOCL((Property)property));
            } else if (TransformPropertyTerminologyConstraint.this.isPropAndTermNull(property)) {
                for (Property override : property.getRedefinedProperties()) {
                    CodeSystemConstraint redfineCodeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)override);
                    if (redfineCodeSystemConstraint == null) continue;
                    result = this.addVocabConstraint(context, IEcoreProfileReflection.ValidationStereotypeKind.CODE_SYSTEM, "true");
                    break;
                }
            }
            return result;
        }

        protected boolean isDuplicateInitialization(Property property) {
            CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)property);
            boolean isDuplicate = false;
            for (Property redefinedProperty : property.getRedefinedProperties()) {
                CodeSystemConstraint redefinedcodeSystemConstraint;
                if (redefinedProperty.getDefault() != null && redefinedProperty.getDefault().equals(property.getDefault())) {
                    isDuplicate = true;
                }
                if (codeSystemConstraint == null || (redefinedcodeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)redefinedProperty)) == null || redefinedcodeSystemConstraint.getCode() == null || !redefinedcodeSystemConstraint.getCode().equals(codeSystemConstraint.getCode())) continue;
                isDuplicate = true;
            }
            return isDuplicate;
        }
    }

    class ValueSetConstraintHandler
    extends TransformPropertyConstraint.PropertyConstraintHandler {
        ValueSetConstraintHandler(String suffix) {
            super((TransformPropertyConstraint)TransformPropertyTerminologyConstraint.this, IEcoreProfileReflection.ValidationStereotypeKind.VALUE_SET, suffix);
        }

        protected boolean addAnnotation(TransformPropertyConstraint.PropertyContext context) {
            Property property = context.property();
            boolean result = false;
            ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)property);
            String codeSystem = null;
            String codeSystemName = null;
            String codeSystemVersion = null;
            String code = null;
            String displayName = null;
            if (valueSetConstraint != null) {
                if (valueSetConstraint.getReference() != null && valueSetConstraint.getReference().getCodeSystem() != null) {
                    CodeSystemVersion codeSystemDef = valueSetConstraint.getReference().getCodeSystem();
                    codeSystem = codeSystemDef.getIdentifier();
                    codeSystemName = codeSystemDef.getEnumerationName();
                }
                result = this.addAnnotation(property, IEcoreProfileReflection.ValidationStereotypeKind.VALUE_SET, codeSystem, codeSystemName, code, displayName, codeSystemVersion);
            }
            return result;
        }

        protected Constraint addConstraint(TransformPropertyConstraint.PropertyContext context) {
            Property property = context.property();
            Constraint result = null;
            ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)property);
            if (valueSetConstraint != null) {
                result = this.addVocabConstraint(context, IEcoreProfileReflection.ValidationStereotypeKind.VALUE_SET, ValueSetConstraintUtil.getOCL((Property)property));
            } else if (TransformPropertyTerminologyConstraint.this.isPropAndTermNull(property)) {
                for (Property override : property.getRedefinedProperties()) {
                    ValueSetConstraint redfineValueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)override);
                    if (redfineValueSetConstraint == null) continue;
                    result = this.addVocabConstraint(context, IEcoreProfileReflection.ValidationStereotypeKind.VALUE_SET, "true");
                    break;
                }
            }
            return result;
        }

        protected boolean isDuplicateInitialization(Property property) {
            boolean isDuplicate = false;
            for (Property redefinedProperty : property.getRedefinedProperties()) {
                if (redefinedProperty.getDefault() == null || !redefinedProperty.getDefault().equals(property.getDefault())) continue;
                isDuplicate = true;
            }
            return isDuplicate;
        }
    }
}

