/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.emf.runtime.resource.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.mdht.emf.runtime.resource.DOMElementHandler;

public class DOMElementHandlerRegistryImpl
implements DOMElementHandler.Registry {
    private Map<String, List<DOMElementHandler>> handlers = new HashMap<String, List<DOMElementHandler>>();
    private DOMElementHandler.Registry delegate;

    public DOMElementHandlerRegistryImpl() {
        this(DOMElementHandler.Registry.INSTANCE);
    }

    public DOMElementHandlerRegistryImpl(DOMElementHandler.Registry delegate) {
        this.delegate = delegate;
    }

    protected List<DOMElementHandler> basicGetHandlers(EPackage epackage) {
        List<DOMElementHandler> result = this.handlers.get(epackage.getNsURI());
        if (result == null) {
            result = new ArrayList<DOMElementHandler>();
            if (this.delegate != null) {
                for (DOMElementHandler next : this.delegate.getHandlers(epackage)) {
                    result.add(next);
                }
            }
            this.handlers.put(epackage.getNsURI(), result);
        }
        return result;
    }

    @Override
    public Iterable<DOMElementHandler> getHandlers(EPackage epackage) {
        return Collections.unmodifiableCollection(this.basicGetHandlers(epackage));
    }

    @Override
    public DOMElementHandler.Registry registerHandler(EPackage epackage, DOMElementHandler handler) {
        List<DOMElementHandler> handlers = this.basicGetHandlers(epackage);
        if (!handlers.contains(handler)) {
            handlers.add(handler);
        }
        return this;
    }
}

