/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.core.util;

import org.eclipse.mdht.uml.term.core.profile.CodeSystemVersion;
import org.eclipse.mdht.uml.term.core.profile.ValueSetCode;
import org.eclipse.mdht.uml.term.core.profile.ValueSetConstraint;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;

public class ValueSetConstraintUtil {
    public static String getOCL(Property property) {
        String result = property.getType() instanceof Enumeration ? ValueSetConstraintUtil.getOCLForEnumeration(property) : ValueSetConstraintUtil.getOCLForCD(property);
        return result;
    }

    private static String getOCLForCD(Property property) {
        StringBuffer body = new StringBuffer();
        boolean needsAnd = false;
        ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint(property);
        if (valueSetConstraint == null) {
            return null;
        }
        if (valueSetConstraint.getReference() != null && valueSetConstraint.getReference().getCodeSystem() != null) {
            Iterable<EnumerationLiteral> literals;
            CodeSystemVersion codeSystem = valueSetConstraint.getReference().getCodeSystem();
            String id = codeSystem.getIdentifier();
            String name = codeSystem.getEnumerationName();
            if (id != null && id.length() > 0 && !TermProfileUtil.isCSType(property)) {
                if (needsAnd) {
                    body.append(" and ");
                }
                body.append("value.codeSystem = '");
                body.append(id);
                body.append("'");
                needsAnd = true;
            }
            if (!(id != null && id.length() != 0 || name == null || name.length() <= 0 || TermProfileUtil.isCSType(property))) {
                if (needsAnd) {
                    body.append(" and ");
                }
                body.append("value.codeSystemName = '");
                body.append(name);
                body.append("'");
                needsAnd = true;
            }
            Iterable<EnumerationLiteral> iterable = literals = valueSetConstraint.getReference().getBase_Enumeration() != null ? TermProfileUtil.getSmallEnumeration(valueSetConstraint.getReference().getBase_Enumeration()) : null;
            if (literals != null) {
                if (needsAnd) {
                    body.append(" and (");
                }
                boolean firstCode = true;
                for (EnumerationLiteral literal : literals) {
                    if (firstCode) {
                        firstCode = false;
                    } else {
                        body.append(" or ");
                    }
                    body.append("value.code = '");
                    body.append(literal.getName());
                    body.append("'");
                }
                if (needsAnd) {
                    body.append(")");
                }
            } else {
                if (needsAnd) {
                    body.append(" and ");
                }
                body.append("not value.code.oclIsUndefined()");
            }
        }
        return body.toString();
    }

    private static String getOCLForEnumeration(Property property) {
        StringBuilder result = null;
        ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint(property);
        if (valueSetConstraint != null && valueSetConstraint.getReference() != null) {
            result = new StringBuilder();
            String enumTypeName = property.getType().getQualifiedName();
            Enumeration base = valueSetConstraint.getReference().getBase_Enumeration();
            Iterable<EnumerationLiteral> literals = TermProfileUtil.getSmallEnumeration(base);
            if (literals != null) {
                boolean needsOr = false;
                for (EnumerationLiteral next : base.getOwnedLiterals()) {
                    ValueSetCode code = TermProfileUtil.getValueSetCode(next);
                    if (code == null) continue;
                    if (needsOr) {
                        result.append(" or ");
                    }
                    result.append("value = ");
                    result.append(enumTypeName).append("::").append(next.getName());
                    needsOr = true;
                }
            }
            if (result.length() == 0) {
                result.append("not value.oclIsUndefined()");
            }
        }
        return result == null ? null : result.toString();
    }
}

