/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.ui.properties;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.common.ui.search.IElementFilter;
import org.eclipse.mdht.uml.common.ui.util.UMLUIUtil;
import org.eclipse.mdht.uml.term.core.profile.BindingKind;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemVersion;
import org.eclipse.mdht.uml.term.core.profile.TermPackage;
import org.eclipse.mdht.uml.term.core.profile.ValueSetType;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.mdht.uml.ui.properties.sections.ResettableModelerPropertySection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class ValueSetVersionSection
extends ResettableModelerPropertySection {
    private Enumeration umlEnumeration;
    private Text idText;
    private boolean idModified = false;
    private Text nameText;
    private boolean nameModified = false;
    private Text fullNameText;
    private boolean fullNameModified = false;
    private Text versionText;
    private boolean versionModified = false;
    private Text sourceText;
    private boolean sourceModified = false;
    private Text urlText;
    private boolean urlModified = false;
    private CCombo typeCombo;
    private boolean typeModified = false;
    private CCombo bindingCombo;
    private boolean bindingModified = false;
    private Text effectiveDateText;
    private boolean effectiveDateModified = false;
    private Text releaseDateText;
    private boolean releaseDateModified = false;
    private Text definitionText;
    private boolean definitionModified = false;
    private CLabel codeSystemRefLabel;
    private Button codeSystemRefButton;
    private Button codeSystemRefDeleteButton;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (ValueSetVersionSection.this.idText == event.getSource()) {
                ValueSetVersionSection.this.idModified = true;
            }
            if (ValueSetVersionSection.this.nameText == event.getSource()) {
                ValueSetVersionSection.this.nameModified = true;
            }
            if (ValueSetVersionSection.this.versionText == event.getSource()) {
                ValueSetVersionSection.this.versionModified = true;
            }
            if (ValueSetVersionSection.this.fullNameText == event.getSource()) {
                ValueSetVersionSection.this.fullNameModified = true;
            }
            if (ValueSetVersionSection.this.sourceText == event.getSource()) {
                ValueSetVersionSection.this.sourceModified = true;
            }
            if (ValueSetVersionSection.this.urlText == event.getSource()) {
                ValueSetVersionSection.this.urlModified = true;
            }
            if (ValueSetVersionSection.this.effectiveDateText == event.getSource()) {
                ValueSetVersionSection.this.effectiveDateModified = true;
            }
            if (ValueSetVersionSection.this.releaseDateText == event.getSource()) {
                ValueSetVersionSection.this.releaseDateModified = true;
            }
            if (ValueSetVersionSection.this.definitionText == event.getSource()) {
                ValueSetVersionSection.this.definitionModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                ValueSetVersionSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            ValueSetVersionSection.this.modifyFields();
        }
    };

    private void modifyFields() {
        if (!(this.idModified || this.nameModified || this.versionModified || this.fullNameModified || this.sourceModified || this.urlModified || this.effectiveDateModified || this.releaseDateModified || this.typeModified || this.bindingModified || this.definitionModified)) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumeration);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Profile ctsProfile = TermProfileUtil.getTerminologyProfile((ResourceSet)ValueSetVersionSection.this.umlEnumeration.eResource().getResourceSet());
                    if (ctsProfile == null) {
                        return Status.CANCEL_STATUS;
                    }
                    Enumeration bindingKind = (Enumeration)ctsProfile.getOwnedType("BindingKind");
                    Enumeration valueSetType = (Enumeration)ctsProfile.getOwnedType("ValueSetType");
                    ValueSetVersion valueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)ValueSetVersionSection.this.umlEnumeration);
                    if (valueSetVersion == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (ValueSetVersionSection.this.idModified) {
                        ValueSetVersionSection.this.idModified = false;
                        this.setLabel("Set ValueSet ID");
                        String value = ValueSetVersionSection.this.idText.getText().trim();
                        valueSetVersion.setIdentifier(value.length() > 0 ? value : null);
                    } else if (ValueSetVersionSection.this.nameModified) {
                        ValueSetVersionSection.this.nameModified = false;
                        this.setLabel("Set ValueSet Name");
                        String value = ValueSetVersionSection.this.nameText.getText().trim();
                        valueSetVersion.setEnumerationName(value.length() > 0 ? value : null);
                    } else if (ValueSetVersionSection.this.fullNameModified) {
                        ValueSetVersionSection.this.fullNameModified = false;
                        this.setLabel("Set ValueSet Full Name");
                        String value = ValueSetVersionSection.this.fullNameText.getText().trim();
                        valueSetVersion.setFullName(value.length() > 0 ? value : null);
                    } else if (ValueSetVersionSection.this.versionModified) {
                        ValueSetVersionSection.this.versionModified = false;
                        this.setLabel("Set Value Set Version");
                        String value = ValueSetVersionSection.this.versionText.getText().trim();
                        valueSetVersion.setVersion(value.length() > 0 ? value : null);
                    } else if (ValueSetVersionSection.this.sourceModified) {
                        ValueSetVersionSection.this.sourceModified = false;
                        this.setLabel("Set ValueSet Source");
                        String value = ValueSetVersionSection.this.sourceText.getText().trim();
                        valueSetVersion.setSource(value.length() > 0 ? value : null);
                    } else if (ValueSetVersionSection.this.urlModified) {
                        ValueSetVersionSection.this.urlModified = false;
                        this.setLabel("Set ValueSet URL");
                        String value = ValueSetVersionSection.this.urlText.getText().trim();
                        valueSetVersion.setUrl(value.length() > 0 ? value : null);
                    } else if (ValueSetVersionSection.this.effectiveDateModified) {
                        ValueSetVersionSection.this.effectiveDateModified = false;
                        this.setLabel("Set ValueSet Effective Date");
                        String value = ValueSetVersionSection.this.effectiveDateText.getText().trim();
                        valueSetVersion.setEffectiveDate(value.length() > 0 ? value : null);
                    } else if (ValueSetVersionSection.this.releaseDateModified) {
                        ValueSetVersionSection.this.releaseDateModified = false;
                        this.setLabel("Set ValueSet Release Date");
                        String value = ValueSetVersionSection.this.releaseDateText.getText().trim();
                        valueSetVersion.setReleaseDate(value.length() > 0 ? value : null);
                    } else if (ValueSetVersionSection.this.definitionModified) {
                        ValueSetVersionSection.this.definitionModified = false;
                        this.setLabel("Set ValueSet Definition");
                        String value = ValueSetVersionSection.this.definitionText.getText().trim();
                        valueSetVersion.setDefinition(value.length() > 0 ? value : null);
                    } else if (ValueSetVersionSection.this.typeModified && valueSetType != null) {
                        ValueSetVersionSection.this.typeModified = false;
                        this.setLabel("Set Value Set Type");
                        if (ValueSetVersionSection.this.typeCombo.getSelectionIndex() == 0) {
                            valueSetVersion.setType(null);
                        } else {
                            EnumerationLiteral literal = (EnumerationLiteral)valueSetType.getOwnedLiterals().get(ValueSetVersionSection.this.typeCombo.getSelectionIndex());
                            valueSetVersion.setType(ValueSetType.getByName((String)literal.getName()));
                        }
                    } else if (ValueSetVersionSection.this.bindingModified && bindingKind != null) {
                        ValueSetVersionSection.this.bindingModified = false;
                        this.setLabel("Set Binding");
                        if (ValueSetVersionSection.this.bindingCombo.getSelectionIndex() == 0) {
                            valueSetVersion.setBinding(null);
                        } else {
                            EnumerationLiteral literal = (EnumerationLiteral)bindingKind.getOwnedLiterals().get(ValueSetVersionSection.this.bindingCombo.getSelectionIndex());
                            valueSetVersion.setBinding(BindingKind.getByName((String)literal.getName()));
                        }
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    ValueSetVersionSection.this.updateViews();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected void resetFields() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumeration);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Restore Default Values"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ValueSetVersion valueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)ValueSetVersionSection.this.umlEnumeration);
                    if (valueSetVersion == null) {
                        return Status.CANCEL_STATUS;
                    }
                    valueSetVersion.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_VERSION__IDENTIFIER);
                    valueSetVersion.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_VERSION__FULL_NAME);
                    valueSetVersion.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_VERSION__VERSION);
                    valueSetVersion.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_VERSION__SOURCE);
                    valueSetVersion.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_VERSION__URL);
                    valueSetVersion.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_VERSION__EFFECTIVE_DATE);
                    valueSetVersion.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_VERSION__RELEASE_DATE);
                    valueSetVersion.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_VERSION__DEFINITION);
                    valueSetVersion.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_VERSION__TYPE);
                    valueSetVersion.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_VERSION__BINDING);
                    ValueSetVersionSection.this.updateViews();
                    ValueSetVersionSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void addCodeSystemReference() {
        IElementFilter filter = new IElementFilter(){

            public boolean accept(Element element) {
                return element instanceof Enumeration && TermProfileUtil.getCodeSystemVersion((Enumeration)((Enumeration)element)) != null;
            }
        };
        Enumeration codeSystemEnum = (Enumeration)DialogLaunchUtil.chooseElement((IElementFilter)filter, (ResourceSet)UMLUIUtil.loadModelsfromWorkspace(), (Shell)this.getPart().getSite().getShell(), null, (String)"Select a Code System");
        if (codeSystemEnum == null) {
            return;
        }
        Stereotype codeSystemStereotype = TermProfileUtil.getAppliedStereotype((Element)codeSystemEnum, (String)"CodeSystemVersion");
        if (codeSystemStereotype == null) {
            MessageDialog.openError((Shell)this.getPart().getSite().getShell(), (String)"Invalid Enumeration", (String)"The selected Enumertion must be a <<CodeSystemVersion>>");
            return;
        }
        final CodeSystemVersion codeSystem = (CodeSystemVersion)codeSystemEnum.getStereotypeApplication(codeSystemStereotype);
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumeration);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ValueSetVersion valueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)ValueSetVersionSection.this.umlEnumeration);
                    if (valueSetVersion == null) {
                        return Status.CANCEL_STATUS;
                    }
                    this.setLabel("Set CodeSystem reference");
                    valueSetVersion.setCodeSystem(codeSystem);
                    ValueSetVersionSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void deleteCodeSystemReference() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumeration);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ValueSetVersion valueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)ValueSetVersionSection.this.umlEnumeration);
                    if (valueSetVersion == null) {
                        return Status.CANCEL_STATUS;
                    }
                    this.setLabel("Remove CodeSystem reference");
                    valueSetVersion.setCodeSystem(null);
                    ValueSetVersionSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 10;
        int charHeight = point.y;
        gc.dispose();
        shell.dispose();
        Group composite = this.getWidgetFactory().createGroup(parent, "Value Set Version");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 4;
        layout.spacing = 7;
        composite.setLayout((Layout)layout);
        int numberOfRows = 10;
        FormData data = null;
        this.codeSystemRefLabel = this.getWidgetFactory().createCLabel((Composite)composite, "");
        this.codeSystemRefButton = this.getWidgetFactory().createButton((Composite)composite, "Select Code System...", 8);
        this.codeSystemRefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ValueSetVersionSection.this.addCodeSystemReference();
            }
        });
        this.codeSystemRefDeleteButton = this.getWidgetFactory().createButton((Composite)composite, "X", 8);
        this.codeSystemRefDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ValueSetVersionSection.this.deleteCodeSystemReference();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.height = buttonHeight;
        this.codeSystemRefButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.codeSystemRefButton, 0);
        data.height = buttonHeight;
        data.top = new FormAttachment((Control)this.codeSystemRefButton, 0, 0x1000000);
        this.codeSystemRefDeleteButton.setLayoutData((Object)data);
        this.createRestoreDefaultsButton((Composite)composite);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.codeSystemRefLabel, 0, 0x1000000);
        this.restoreDefaultsButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.codeSystemRefDeleteButton, 0);
        data.right = new FormAttachment((Control)this.restoreDefaultsButton, 5);
        data.top = new FormAttachment((Control)this.codeSystemRefButton, 0, 0x1000000);
        this.codeSystemRefLabel.setLayoutData((Object)data);
        this.nameText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel nameLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.nameText, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)nameLabel, 0);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment(1, numberOfRows, 4);
        this.nameText.setLayoutData((Object)data);
        this.idText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel idLabel = this.getWidgetFactory().createCLabel((Composite)composite, "ID:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.nameText, 5);
        data.top = new FormAttachment((Control)this.nameText, 0, 0x1000000);
        idLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)idLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(1, numberOfRows, 4);
        this.idText.setLayoutData((Object)data);
        this.fullNameText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel fullNameLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Full Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.fullNameText, 0, 0x1000000);
        fullNameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)fullNameLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(2, numberOfRows, 4);
        this.fullNameText.setLayoutData((Object)data);
        this.sourceText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel sourceLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Source:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.sourceText, 0, 0x1000000);
        sourceLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)sourceLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(3, numberOfRows, 4);
        this.sourceText.setLayoutData((Object)data);
        this.urlText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel urlLabel = this.getWidgetFactory().createCLabel((Composite)composite, "URL:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.urlText, 0, 0x1000000);
        urlLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)urlLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(4, numberOfRows, 4);
        this.urlText.setLayoutData((Object)data);
        this.typeCombo = this.getWidgetFactory().createCCombo((Composite)composite, 0x800808);
        this.typeCombo.setItems(new String[]{"Extensional", "Intensional"});
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ValueSetVersionSection.this.typeModified = true;
                ValueSetVersionSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                ValueSetVersionSection.this.typeModified = true;
                ValueSetVersionSection.this.modifyFields();
            }
        });
        CLabel typeLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Type:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.typeCombo, 0, 0x1000000);
        typeLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)typeLabel, 0);
        data.top = new FormAttachment(5, numberOfRows, 4);
        this.typeCombo.setLayoutData((Object)data);
        this.bindingCombo = this.getWidgetFactory().createCCombo((Composite)composite, 0x800808);
        this.bindingCombo.setItems(new String[]{"Static", "Dynamic"});
        this.bindingCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ValueSetVersionSection.this.bindingModified = true;
                ValueSetVersionSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                ValueSetVersionSection.this.bindingModified = true;
                ValueSetVersionSection.this.modifyFields();
            }
        });
        CLabel bindingLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Binding:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.typeCombo, 5);
        data.top = new FormAttachment((Control)this.bindingCombo, 0, 0x1000000);
        bindingLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)bindingLabel, 0);
        data.top = new FormAttachment(5, numberOfRows, 4);
        this.bindingCombo.setLayoutData((Object)data);
        this.versionText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel versionLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Version:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.bindingCombo, 5);
        data.top = new FormAttachment((Control)this.versionText, 0, 0x1000000);
        versionLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)versionLabel, 0);
        data.right = new FormAttachment(70, 0);
        data.top = new FormAttachment(5, numberOfRows, 4);
        this.versionText.setLayoutData((Object)data);
        this.releaseDateText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel releaseDateLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Release Date:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.releaseDateText, 0, 0x1000000);
        releaseDateLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)releaseDateLabel, 0);
        data.right = new FormAttachment(25, 0);
        data.top = new FormAttachment(6, numberOfRows, 4);
        this.releaseDateText.setLayoutData((Object)data);
        this.effectiveDateText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel effectiveDateLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Effective Date:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.releaseDateText, 5);
        data.top = new FormAttachment((Control)this.releaseDateText, 0, 0x1000000);
        effectiveDateLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)effectiveDateLabel, 0);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment(6, numberOfRows, 4);
        this.effectiveDateText.setLayoutData((Object)data);
        this.definitionText = this.getWidgetFactory().createText((Composite)composite, "", 576);
        CLabel definitionLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Definition:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.releaseDateText, 0, 1024);
        definitionLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)definitionLabel, 0);
        data.width = 300;
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.releaseDateText, 0, 1024);
        data.height = charHeight * 4;
        this.definitionText.setLayoutData((Object)data);
    }

    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.umlEnumeration != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumeration)) != null && editingDomain.isReadOnly(this.umlEnumeration.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof Enumeration));
        this.umlEnumeration = (Enumeration)element;
    }

    public void dispose() {
        super.dispose();
    }

    public void refresh() {
        int index;
        EnumerationLiteral literal;
        String date;
        String name;
        Profile ctsProfile = TermProfileUtil.getTerminologyProfile((ResourceSet)this.umlEnumeration.eResource().getResourceSet());
        if (ctsProfile == null) {
            return;
        }
        Enumeration bindingKindEnum = (Enumeration)ctsProfile.getOwnedType("BindingKind");
        Enumeration valueSetTypeEnum = (Enumeration)ctsProfile.getOwnedType("ValueSetType");
        ValueSetVersion valueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)this.umlEnumeration);
        CodeSystemVersion codeSystem = null;
        if (valueSetVersion != null && valueSetVersion.getCodeSystem() != null) {
            codeSystem = valueSetVersion.getCodeSystem();
            this.codeSystemRefLabel.setText(codeSystem.getEnumerationQualifiedName());
            this.codeSystemRefLabel.layout();
        } else {
            this.codeSystemRefLabel.setText("");
        }
        this.idText.removeModifyListener(this.modifyListener);
        this.idText.removeKeyListener(this.keyListener);
        this.idText.removeFocusListener(this.focusListener);
        if (valueSetVersion != null) {
            String id = valueSetVersion.getIdentifier();
            this.idText.setText(id != null ? id : "");
        } else {
            this.idText.setText("");
        }
        this.idText.addModifyListener(this.modifyListener);
        this.idText.addKeyListener(this.keyListener);
        this.idText.addFocusListener(this.focusListener);
        this.nameText.removeModifyListener(this.modifyListener);
        this.nameText.removeKeyListener(this.keyListener);
        this.nameText.removeFocusListener(this.focusListener);
        if (valueSetVersion != null) {
            name = valueSetVersion.getEnumerationName();
            this.nameText.setText(name != null ? name : "");
        } else {
            this.nameText.setText("");
        }
        this.nameText.addModifyListener(this.modifyListener);
        this.nameText.addKeyListener(this.keyListener);
        this.nameText.addFocusListener(this.focusListener);
        this.fullNameText.removeModifyListener(this.modifyListener);
        this.fullNameText.removeKeyListener(this.keyListener);
        this.fullNameText.removeFocusListener(this.focusListener);
        if (valueSetVersion != null) {
            name = valueSetVersion.getFullName();
            this.fullNameText.setText(name != null ? name : "");
        } else {
            this.fullNameText.setText("");
        }
        this.fullNameText.addModifyListener(this.modifyListener);
        this.fullNameText.addKeyListener(this.keyListener);
        this.fullNameText.addFocusListener(this.focusListener);
        this.sourceText.removeModifyListener(this.modifyListener);
        this.sourceText.removeKeyListener(this.keyListener);
        this.sourceText.removeFocusListener(this.focusListener);
        if (valueSetVersion != null) {
            String source = valueSetVersion.getSource();
            this.sourceText.setText(source != null ? source : "");
        } else {
            this.sourceText.setText("");
        }
        this.sourceText.addModifyListener(this.modifyListener);
        this.sourceText.addKeyListener(this.keyListener);
        this.sourceText.addFocusListener(this.focusListener);
        this.urlText.removeModifyListener(this.modifyListener);
        this.urlText.removeKeyListener(this.keyListener);
        this.urlText.removeFocusListener(this.focusListener);
        if (valueSetVersion != null) {
            String url = valueSetVersion.getUrl();
            this.urlText.setText(url != null ? url : "");
        } else {
            this.urlText.setText("");
        }
        this.urlText.addModifyListener(this.modifyListener);
        this.urlText.addKeyListener(this.keyListener);
        this.urlText.addFocusListener(this.focusListener);
        this.versionText.removeModifyListener(this.modifyListener);
        this.versionText.removeKeyListener(this.keyListener);
        this.versionText.removeFocusListener(this.focusListener);
        if (valueSetVersion != null) {
            String version = valueSetVersion.getVersion();
            this.versionText.setText(version != null ? version : "");
        } else {
            this.versionText.setText("");
        }
        this.versionText.addModifyListener(this.modifyListener);
        this.versionText.addKeyListener(this.keyListener);
        this.versionText.addFocusListener(this.focusListener);
        this.releaseDateText.removeModifyListener(this.modifyListener);
        this.releaseDateText.removeKeyListener(this.keyListener);
        this.releaseDateText.removeFocusListener(this.focusListener);
        if (valueSetVersion != null) {
            date = valueSetVersion.getReleaseDate();
            this.releaseDateText.setText(date != null ? date : "");
        } else {
            this.releaseDateText.setText("");
        }
        this.releaseDateText.addModifyListener(this.modifyListener);
        this.releaseDateText.addKeyListener(this.keyListener);
        this.releaseDateText.addFocusListener(this.focusListener);
        this.effectiveDateText.removeModifyListener(this.modifyListener);
        this.effectiveDateText.removeKeyListener(this.keyListener);
        this.effectiveDateText.removeFocusListener(this.focusListener);
        if (valueSetVersion != null) {
            date = valueSetVersion.getEffectiveDate();
            this.effectiveDateText.setText(date != null ? date : "");
        } else {
            this.effectiveDateText.setText("");
        }
        this.effectiveDateText.addModifyListener(this.modifyListener);
        this.effectiveDateText.addKeyListener(this.keyListener);
        this.effectiveDateText.addFocusListener(this.focusListener);
        this.definitionText.removeModifyListener(this.modifyListener);
        this.definitionText.removeKeyListener(this.keyListener);
        this.definitionText.removeFocusListener(this.focusListener);
        if (valueSetVersion != null) {
            String definition = valueSetVersion.getDefinition();
            this.definitionText.setText(definition != null ? definition : "");
        } else {
            this.definitionText.setText("");
        }
        this.definitionText.addModifyListener(this.modifyListener);
        this.definitionText.addKeyListener(this.keyListener);
        this.definitionText.addFocusListener(this.focusListener);
        this.typeCombo.select(0);
        if (valueSetVersion != null) {
            ValueSetType valueSetType = valueSetVersion.getType();
            if (valueSetTypeEnum != null && valueSetType != null) {
                literal = valueSetTypeEnum.getOwnedLiteral(valueSetType.getName());
                index = valueSetTypeEnum.getOwnedLiterals().indexOf((Object)literal);
                this.typeCombo.select(index);
            }
        }
        this.bindingCombo.select(0);
        if (valueSetVersion != null) {
            BindingKind binding = valueSetVersion.getBinding();
            if (bindingKindEnum != null && binding != null) {
                literal = bindingKindEnum.getOwnedLiteral(binding.getName());
                index = bindingKindEnum.getOwnedLiterals().indexOf((Object)literal);
                this.bindingCombo.select(index);
            }
        }
        if (this.isReadOnly()) {
            this.codeSystemRefLabel.setEnabled(false);
            this.idText.setEnabled(false);
            this.nameText.setEnabled(false);
            this.fullNameText.setEnabled(false);
            this.sourceText.setEnabled(false);
            this.urlText.setEnabled(false);
            this.versionText.setEnabled(false);
            this.releaseDateText.setEnabled(false);
            this.effectiveDateText.setEnabled(false);
            this.definitionText.setEnabled(false);
            this.typeCombo.setEnabled(false);
            this.bindingCombo.setEnabled(false);
            this.restoreDefaultsButton.setEnabled(false);
        } else {
            this.codeSystemRefLabel.setEnabled(true);
            this.idText.setEnabled(true);
            this.nameText.setEnabled(true);
            this.fullNameText.setEnabled(true);
            this.sourceText.setEnabled(true);
            this.urlText.setEnabled(true);
            this.versionText.setEnabled(true);
            this.releaseDateText.setEnabled(true);
            this.effectiveDateText.setEnabled(true);
            this.definitionText.setEnabled(true);
            this.typeCombo.setEnabled(true);
            this.bindingCombo.setEnabled(true);
            this.restoreDefaultsButton.setEnabled(valueSetVersion != null);
        }
    }

    public void update(Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!ValueSetVersionSection.this.isDisposed() && ValueSetVersionSection.this.umlEnumeration.eResource() != null) {
                        ValueSetVersionSection.this.refresh();
                    }
                }
            });
        }
    }

    protected void updateViews() {
        NotificationImpl notification = new NotificationImpl(1, null, this.umlEnumeration.getName()){

            public Object getNotifier() {
                return ValueSetVersionSection.this.umlEnumeration;
            }

            public int getFeatureID(Class expectedClass) {
                return 5;
            }
        };
        this.umlEnumeration.eNotify((Notification)notification);
    }
}

