/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.dita;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mdht.uml.cda.Act;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.CDAPackage;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.Observation;
import org.eclipse.mdht.uml.cda.ObservationMedia;
import org.eclipse.mdht.uml.cda.Organizer;
import org.eclipse.mdht.uml.cda.Procedure;
import org.eclipse.mdht.uml.cda.RegionOfInterest;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.SubstanceAdministration;
import org.eclipse.mdht.uml.cda.Supply;
import org.eclipse.mdht.uml.cda.core.profile.SeverityKind;
import org.eclipse.mdht.uml.cda.core.profile.Validation;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.dita.TransformAbstract;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.hl7.datatypes.CD;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.datatypes.util.DatatypesSwitch;
import org.eclipse.mdht.uml.hl7.rim.InfrastructureRoot;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class TableGenerator {
    private Map<String, EPackage> packageURIMap = new HashMap<String, EPackage>();
    String[] severities = new String[]{"SHALL", "SHOULD", "MAY"};

    public TableGenerator() {
        CDAUtil.loadPackages();
    }

    private EPackage getEPackageForURI(String ePackageURI) {
        EPackage ePackage = this.packageURIMap.get(ePackageURI);
        if (!this.packageURIMap.containsKey(ePackageURI)) {
            ePackage = EPackage.Registry.INSTANCE.getEPackage(ePackageURI);
            this.packageURIMap.put(ePackageURI, ePackage);
            if (ePackage == null) {
                System.err.println("Cannot load EPackage for: " + ePackageURI);
            }
        }
        return ePackage;
    }

    public EClass getEClass(Type umlType) {
        EClassifier eClassifier;
        EPackage ePackage;
        String ePackageURI = CDAModelUtil.getEcorePackageURI((Element)umlType);
        if (ePackageURI != null && (ePackage = this.getEPackageForURI(ePackageURI)) != null && (eClassifier = ePackage.getEClassifier(UML2Util.getValidJavaIdentifier((String)umlType.getName()))) instanceof EClass) {
            return (EClass)eClassifier;
        }
        return null;
    }

    private String getSeverity(SeverityKind sk) {
        if (sk.getValue() < 3) {
            return this.severities[sk.getValue()];
        }
        return sk.getLiteral();
    }

    private Validation getValidation(Class umlClass, String property) {
        Property umlProperty = umlClass.getAttribute(property, null);
        if (umlProperty != null) {
            EObject appliedStereotype;
            for (Stereotype stereotype : umlProperty.getAppliedStereotypes()) {
                appliedStereotype = umlProperty.getStereotypeApplication(stereotype);
                if (!(appliedStereotype instanceof Validation)) continue;
                return (Validation)appliedStereotype;
            }
            if (umlProperty.getAssociation() != null) {
                for (Stereotype stereotype : umlProperty.getAssociation().getAppliedStereotypes()) {
                    appliedStereotype = umlProperty.getAssociation().getStereotypeApplication(stereotype);
                    if (!(appliedStereotype instanceof Validation)) continue;
                    return (Validation)appliedStereotype;
                }
            }
            for (Generalization generalization : umlClass.getGeneralizations()) {
                Validation validation;
                if (!(generalization.getGeneral() instanceof Class) || (validation = this.getValidation((Class)generalization.getGeneral(), property)) == null) continue;
                return validation;
            }
        }
        return null;
    }

    private String getCodeSystem(Class umlClass, String property) {
        StringBuffer codeSystemBuffer = new StringBuffer();
        this.getCodeSystem(umlClass, property, codeSystemBuffer);
        return codeSystemBuffer.toString();
    }

    private void getCodeSystem(Class umlClass, String property, StringBuffer codeSystemBuffer) {
        CodeSystemConstraint csc;
        Property umlProperty = umlClass.getAttribute(property, null);
        if (umlProperty != null && (csc = TermProfileUtil.getCodeSystemConstraint((Property)umlProperty)) != null) {
            if (csc.getReference() != null) {
                codeSystemBuffer.append(String.format("%s %s", csc.getReference().getEnumerationName(), csc.getReference().getIdentifier()));
            } else {
                codeSystemBuffer.append(String.format("%s %s", csc.getName(), csc.getIdentifier()));
            }
        }
        for (Generalization generalization : umlClass.getGeneralizations()) {
            if (!(generalization.getGeneral() instanceof Class)) continue;
            this.getCodeSystem((Class)generalization.getGeneral(), property, codeSystemBuffer);
        }
    }

    public static String getPath(EObject eObject) {
        String path = "";
        while (eObject != null && !(eObject instanceof ClinicalDocument)) {
            EStructuralFeature feature = eObject.eContainingFeature();
            String query = "";
            if (feature != null && feature.getEType() instanceof EClass) {
                EClass foo = (EClass)feature.getEType();
                for (EAttribute eAttribute : foo.getEAllAttributes()) {
                    eAttribute.getDefaultValueLiteral();
                }
                for (EReference eReference : foo.getEAllContainments()) {
                    String templateID;
                    if (eReference.getDefaultValueLiteral() != null || !eReference.getName().equals("templateId") || (templateID = TableGenerator.getFeatureValue(eObject, (EStructuralFeature)eReference)) == null || templateID.length() <= 0) continue;
                    query = String.valueOf(query) + "cda:templateId/@root = " + templateID;
                }
                if (query.length() > 0) {
                    query = "[" + query + "]";
                }
            }
            path = "/cda:" + feature.getName() + (query.length() > 0 ? query : "") + path;
            eObject = eObject.eContainer();
        }
        return "/cda:ClinicalDocument" + path;
    }

    private static String getFeatureValue(EObject eObject, EStructuralFeature feature) {
        String result = "";
        if (feature != null) {
            Object value = null;
            if (feature.getDefaultValue() != null) {
                value = feature.getDefaultValue();
            } else if (feature.isMany()) {
                List list = (List)eObject.eGet(feature);
                if (list.size() > 0) {
                    value = list.get(list.size() - 1);
                }
            } else {
                value = eObject.eGet(feature);
            }
            if (value != null) {
                if (value instanceof EObject) {
                    DatatypesValue datatypesValue = new DatatypesValue();
                    datatypesValue.doSwitch((EObject)value);
                    result = datatypesValue.result;
                } else {
                    result = value.toString();
                }
            }
        }
        return result;
    }

    public String getDataTypeName(String dataTypeName) {
        if ("EBooleanObject".equals(dataTypeName)) {
            return "Boolean";
        }
        if ("EString".equals(dataTypeName)) {
            return "String";
        }
        return dataTypeName;
    }

    public String createTable(Class umlClass) {
        Class cdaClass = CDAModelUtil.getCDAClass((Classifier)umlClass);
        if (cdaClass == null || umlClass.isAbstract()) {
            return "";
        }
        StringBuffer tableBuffer = new StringBuffer();
        final EClass eClass = this.getEClass((Type)umlClass);
        String startingXPath = "";
        EObject eObject = null;
        if (eClass == null) {
            System.out.println("no eclass " + umlClass.getQualifiedName());
            return null;
        }
        ClinicalDocument doc = CDAFactory.eINSTANCE.createClinicalDocument();
        eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        try {
            Method initMethod = eObject.getClass().getDeclaredMethod("init", new java.lang.Class[0]);
            if (initMethod != null) {
                initMethod.invoke((Object)eObject, new Object[0]);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (CDAModelUtil.isSection((Type)umlClass) && CDAModelUtil.getCDAClass((Classifier)umlClass) != null) {
            doc.addSection((Section)eObject);
            startingXPath = TableGenerator.getPath(eObject);
        } else {
            startingXPath = umlClass != null && cdaClass != null && CDAModelUtil.getCDAClass((Classifier)umlClass).getName() != null ? "cda::" + CDAModelUtil.getCDAClass((Classifier)umlClass).getName().toLowerCase() : "cda::nullumlclassname";
            EStructuralFeature templateId = eObject.eClass().getEStructuralFeature("templateId");
            if (templateId != null) {
                startingXPath = String.valueOf(startingXPath) + "[cda:templateId/@root = " + TableGenerator.getFeatureValue(eObject, templateId) + "]";
            }
        }
        tableBuffer.append("<section id=\"tableconformance\"><p><table frame=\"all\" scale=\"80\" pgwide=\"1\" ><tgroup cols=\"6\" align=\"left\" colsep = \"1\" rowsep = \"1\" > ");
        tableBuffer.append("<colspec colname=\"col0\" colnum=\"0\" colwidth=\"3*\"  />");
        tableBuffer.append("<colspec colname=\"col1\" colnum=\"1\" colwidth=\"1*\"  />");
        tableBuffer.append("<colspec colname=\"col2\" colnum=\"2\" colwidth=\"1*\"  />");
        tableBuffer.append("<colspec colname=\"col3\" colnum=\"3\" colwidth=\"2*\"  />");
        tableBuffer.append("<colspec colname=\"col4\" colnum=\"4\" colwidth=\"2*\"  />");
        tableBuffer.append("<colspec colname=\"col5\" colnum=\"5\" colwidth=\"3*\"  />");
        tableBuffer.append("<thead> <row><entry namest=\"col0\" nameend=\"col5\" >" + umlClass.getQualifiedName() + "</entry>  </row>  <row><entry namest=\"col0\" nameend=\"col5\" >" + startingXPath + "/" + "</entry>  </row> <row><entry>XPath</entry><entry>Card.</entry><entry>Verb</entry><entry>Data Type</entry><entry>CONF#</entry><entry>Fixed Value</entry></row></thead><tbody>");
        Hashtable<String, Element> elements = new Hashtable<String, Element>();
        this.getTableRows(umlClass, elements);
        ArrayList<Element> elementlist = new ArrayList<Element>(elements.values());
        Comparator<Element> elementSorter = new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                if (!(o1 instanceof Property)) {
                    return -1;
                }
                if (!(o2 instanceof Property)) {
                    return 1;
                }
                if (eClass == null) {
                    return 0;
                }
                Property leftProperty = (Property)o1;
                EStructuralFeature leftFeature = eClass.getEStructuralFeature(leftProperty.getName());
                Property rightProperty = (Property)o2;
                EStructuralFeature rightFeature = eClass.getEStructuralFeature(rightProperty.getName());
                if (leftFeature instanceof EAttribute && rightFeature instanceof EAttribute) {
                    return NamedElementUtil.getBusinessName((NamedElement)leftProperty).compareToIgnoreCase(NamedElementUtil.getBusinessName((NamedElement)rightProperty));
                }
                if (!(leftFeature instanceof EAttribute) && !(rightFeature instanceof EAttribute)) {
                    if (CDAModelUtil.isDatatypeModel((Element)leftProperty.getType()) && CDAModelUtil.isDatatypeModel((Element)rightProperty.getType()) || !CDAModelUtil.isDatatypeModel((Element)leftProperty.getType()) && !CDAModelUtil.isDatatypeModel((Element)rightProperty.getType())) {
                        return NamedElementUtil.getBusinessName((NamedElement)leftProperty).compareToIgnoreCase(NamedElementUtil.getBusinessName((NamedElement)rightProperty));
                    }
                    if (CDAModelUtil.isDatatypeModel((Element)leftProperty.getType())) {
                        return -1;
                    }
                    return 1;
                }
                if (leftFeature instanceof EAttribute) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(elementlist, elementSorter);
        for (Element element : elementlist) {
            if (!(element instanceof NamedElement)) continue;
            this.addRow(tableBuffer, element, eClass, eObject);
        }
        tableBuffer.append("</tbody></tgroup></table></p></section>");
        return tableBuffer.toString();
    }

    private String getRelativeXPath(Section section, InfrastructureRoot ir) {
        return "";
    }

    private static void initEObject(EObject eObject) {
        try {
            Method initMethod = eObject.getClass().getDeclaredMethod("init", new java.lang.Class[0]);
            if (initMethod != null) {
                initMethod.invoke((Object)eObject, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addRow(StringBuffer tableBuffer, Element element, EClass eClass, EObject eObject) {
        if (element instanceof Property && element.getOwner() instanceof Class) {
            Property property = (Property)element;
            EStructuralFeature feature = eClass.getEStructuralFeature(property.getName());
            boolean isAttribute = feature instanceof EAttribute;
            NamedElementUtil.getBusinessName((NamedElement)property);
            String relativePath = null;
            if (eObject != null && eObject instanceof Section && CDAModelUtil.isClinicalStatement((Type)property.getType())) {
                Section section = (Section)eObject;
                String startingPath = TableGenerator.getPath(eObject);
                EClass ePropertyClass = this.getEClass(property.getType());
                Class cdaClass = CDAModelUtil.getCDAClass((Classifier)((Class)property.getType()));
                if (cdaClass != null && ePropertyClass != null && !ePropertyClass.isAbstract()) {
                    EObject eClinicalStatementInstance = ePropertyClass.getEPackage().getEFactoryInstance().create(ePropertyClass);
                    TableGenerator.initEObject(eClinicalStatementInstance);
                    if ("Act".equals(cdaClass.getName())) {
                        section.addAct((Act)eClinicalStatementInstance);
                        relativePath = TableGenerator.getPath(eClinicalStatementInstance);
                    }
                    if ("Encounter".equals(cdaClass.getName())) {
                        section.addEncounter((Encounter)eClinicalStatementInstance);
                        relativePath = TableGenerator.getPath(eClinicalStatementInstance);
                    }
                    if ("Observation".equals(cdaClass.getName())) {
                        section.addObservation((Observation)eClinicalStatementInstance);
                        relativePath = TableGenerator.getPath(eClinicalStatementInstance);
                    }
                    if ("ObservationMedia".equals(cdaClass.getName())) {
                        section.addObservationMedia((ObservationMedia)eClinicalStatementInstance);
                        relativePath = TableGenerator.getPath(eClinicalStatementInstance);
                    }
                    if ("Organizer".equals(cdaClass.getName())) {
                        section.addOrganizer((Organizer)eClinicalStatementInstance);
                        relativePath = TableGenerator.getPath(eClinicalStatementInstance);
                    }
                    if (CDAPackage.eINSTANCE.getProcedure().isSuperTypeOf(ePropertyClass)) {
                        section.addProcedure((Procedure)eClinicalStatementInstance);
                        relativePath = TableGenerator.getPath(eClinicalStatementInstance);
                    }
                    if ("RegionOfInterest".equals(cdaClass.getName())) {
                        section.addRegionOfInterest((RegionOfInterest)eClinicalStatementInstance);
                        relativePath = TableGenerator.getPath(eClinicalStatementInstance);
                    }
                    if ("Section".equals(cdaClass.getName())) {
                        section.addSection((Section)eClinicalStatementInstance);
                        relativePath = TableGenerator.getPath(eClinicalStatementInstance);
                    }
                    if ("SubstanceAdministration".equals(cdaClass.getName())) {
                        section.addSubstanceAdministration((SubstanceAdministration)eClinicalStatementInstance);
                        relativePath = TableGenerator.getPath(eClinicalStatementInstance);
                    }
                    if ("Supply".equals(cdaClass.getName())) {
                        section.addSupply((Supply)eClinicalStatementInstance);
                        relativePath = TableGenerator.getPath(eClinicalStatementInstance);
                    }
                    if (relativePath != null && startingPath != null && relativePath.length() > startingPath.length() + 2) {
                        relativePath = relativePath.substring(startingPath.length() + 1);
                    }
                }
            }
            if (relativePath != null) {
                tableBuffer.append(String.format("<row><entry>%s</entry>", relativePath));
            } else {
                tableBuffer.append(String.format("<row><entry>%s</entry>", String.valueOf(isAttribute ? "@" : "") + property.getName()));
            }
            tableBuffer.append(String.format("<entry>%s..%s</entry>", property.getLower(), property.getUpper() >= 0 ? Integer.valueOf(property.getUpper()) : "*"));
            Validation validation = this.getValidation((Class)element.getOwner(), property.getName());
            tableBuffer.append(String.format("<entry>%s</entry>", validation != null ? this.getSeverity(validation.getSeverity()) : ""));
            String datatype = "";
            if (property.getType() != null) {
                Class cdaDatatype;
                datatype = property.getType() instanceof Class ? ((cdaDatatype = CDAModelUtil.getCDADatatype((Classifier)((Classifier)property.getType()))) != null ? cdaDatatype.getName() : property.getType().getName()) : property.getType().getName();
            }
            tableBuffer.append(String.format("<entry>%s</entry>", datatype));
            StringBuffer conformanceRules = new StringBuffer();
            if (validation != null) {
                for (String ruleId : validation.getRuleId()) {
                    conformanceRules.append(ruleId);
                }
            }
            tableBuffer.append(String.format("<entry>%s</entry>", conformanceRules.toString()));
            tableBuffer.append(String.format("<entry>%s %s</entry></row> \n", this.getCodeSystem((Class)element.getOwner(), property.getName()), TableGenerator.getFeatureValue(eObject, feature)));
        }
    }

    void getTableRows(Class umlClass, Hashtable<String, Element> elements) {
        for (Property property : umlClass.getOwnedAttributes()) {
            if (CDAProfileUtil.getValidation((Element)property) == null || elements.containsKey(property.getName())) continue;
            elements.put(property.getName(), (Element)property);
        }
        for (Association association : umlClass.getAssociations()) {
            for (Property property : association.getMemberEnds()) {
                if (property.getName() == null || elements.containsKey(property.getName())) continue;
                elements.put(property.getName(), (Element)property);
            }
        }
    }

    String getAnXref(Package aPackage, Class aClass) {
        String xref = CDAModelUtil.computeXref((Element)aPackage, (Classifier)aClass);
        String format = xref != null && xref.endsWith(".html") ? "format=\"html\" " : "";
        return "<xref " + format + "href=\"" + xref + "\">" + TransformAbstract.getPublicationName((NamedElement)aClass) + "</xref>";
    }

    public String createTable2(Class umlClass) {
        Class cdaClass = CDAModelUtil.getCDAClass((Classifier)umlClass);
        if (cdaClass == null || umlClass.isAbstract()) {
            return "";
        }
        StringBuffer tableBuffer = new StringBuffer();
        tableBuffer.append("<section id=\"contextTable\"><p><table frame=\"all\" scale=\"80\" pgwide=\"1\" ><tgroup cols=\"2\" align=\"left\" colsep = \"1\" rowsep = \"1\" > ");
        tableBuffer.append("<colspec colname=\"col0\" colnum=\"0\" />");
        tableBuffer.append("<colspec colname=\"col1\" colnum=\"1\" />");
        tableBuffer.append("<thead><row><entry namest=\"col0\" nameend=\"col0\" >Contained By</entry><entry namest=\"col1\" nameend=\"col1\" >Contains</entry></row></thead><tbody>");
        AssociationSwitch associationSwitch = new AssociationSwitch(umlClass);
        Package topPackage = UMLUtil.getTopPackage((Element)umlClass);
        for (Element element : topPackage.getOwnedElements()) {
            associationSwitch.doSwitch((EObject)element);
        }
        associationSwitch.sort();
        int maxRows = associationSwitch.getRowCount();
        if (maxRows > 0) {
            int rowCtr = 0;
            while (rowCtr < maxRows) {
                String containedBy = "";
                String contains = "";
                if (rowCtr < associationSwitch.getContainedBy().size()) {
                    containedBy = this.getAnXref(topPackage, (Class)associationSwitch.getContainedBy().get(rowCtr));
                }
                if (rowCtr < associationSwitch.getContains().size()) {
                    contains = this.getAnXref(topPackage, (Class)associationSwitch.getContains().get(rowCtr));
                }
                if (!StringUtils.isEmpty((String)contains) || !StringUtils.isEmpty((String)containedBy)) {
                    tableBuffer.append("<row><entry>" + containedBy + "</entry><entry>" + contains + "</entry></row>");
                }
                ++rowCtr;
            }
        } else {
            tableBuffer.append("<row><entry> </entry><entry> </entry></row>");
        }
        tableBuffer.append("</tbody></tgroup></table></p></section>");
        return tableBuffer.toString();
    }

    private static class AssociationSwitch
    extends UMLSwitch<String> {
        Class umlClass;
        ArrayList<Type> containedBy = new ArrayList();
        Set<Type> containedBySet = new HashSet<Type>();
        ArrayList<Type> contains = new ArrayList();
        Set<Type> containsSet = new HashSet<Type>();

        int getRowCount() {
            if (this.containsSet.size() > this.containedBySet.size()) {
                return this.containsSet.size();
            }
            return this.containedBySet.size();
        }

        public ArrayList<Type> getContainedBy() {
            return this.containedBy;
        }

        public ArrayList<Type> getContains() {
            return this.contains;
        }

        public AssociationSwitch(Class umlClass) {
            this.umlClass = umlClass;
        }

        public void sort() {
            Comparator<Type> compare = new Comparator<Type>(){

                @Override
                public int compare(Type o1, Type o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            Collections.sort(this.containedBy, compare);
            Collections.sort(this.contains, compare);
        }

        private void addContains(Type type) {
            if (this.containsSet.add(type)) {
                this.contains.add(type);
            }
        }

        private void addContainedBy(Type type) {
            if (this.containedBySet.add(type)) {
                this.containedBy.add(type);
            }
        }

        public String caseAssociation(Association association) {
            Type from = null;
            Type to = null;
            for (NamedElement ne : association.getMembers()) {
                Property p;
                if (!(ne instanceof Property) || (p = (Property)ne).getType() == null) continue;
                if (p.getName() == null) {
                    from = p.getType();
                    continue;
                }
                to = p.getType();
            }
            if (from != null && from.getQualifiedName().equals(this.umlClass.getQualifiedName()) && to instanceof Class) {
                Class toClass = (Class)to;
                if (CDAModelUtil.isPublishSeperately((Class)toClass)) {
                    this.addContains((Type)toClass);
                }
                if (CDAModelUtil.getTemplateId((Class)toClass) != null) {
                    this.addContains((Type)toClass);
                }
            }
            if (to != null && to.getQualifiedName().equals(this.umlClass.getQualifiedName())) {
                if (from instanceof Class) {
                    Class fromClass = (Class)from;
                    if (CDAModelUtil.isPublishSeperately((Class)fromClass)) {
                        this.addContainedBy((Type)fromClass);
                    }
                    if (CDAModelUtil.getTemplateId((Class)fromClass) != null) {
                        this.addContainedBy((Type)fromClass);
                    }
                }
                if (to instanceof Class && CDAModelUtil.isInlineClass((Class)((Class)to)) && !CDAModelUtil.isPublishSeperately((Class)((Class)to))) {
                    this.walkInlineClass((Class)to);
                }
            }
            return (String)super.caseAssociation(association);
        }

        void walkInlineClass(Class inlineClass) {
            for (Property p : inlineClass.getOwnedAttributes()) {
                if (p.getType() instanceof Class) {
                    Class toClass = (Class)p.getType();
                    if (CDAModelUtil.isPublishSeperately((Class)toClass)) {
                        this.addContains((Type)toClass);
                    }
                    if (CDAModelUtil.getTemplateId((Class)toClass) != null) {
                        this.addContains((Type)toClass);
                    }
                }
                if (!(p.getType() instanceof Class) || !CDAModelUtil.isInlineClass((Class)((Class)p.getType())) || CDAModelUtil.isPublishSeperately((Class)((Class)p.getType()))) continue;
                this.walkInlineClass((Class)p.getType());
            }
        }
    }

    private static class DatatypesValue
    extends DatatypesSwitch<Object> {
        public String result;

        private DatatypesValue() {
        }

        public Object caseII(II object) {
            this.result = object.getRoot();
            return object;
        }

        public Object defaultCase(EObject object) {
            this.result = "MISSINGTYPE";
            return object;
        }

        public Object caseCD(CD object) {
            this.result = object.getCode();
            return object;
        }
    }
}

