/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.validation.internal.packages;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.validation.provider.AbstractMultiConstraint;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class PackageImportConstraints
extends AbstractMultiConstraint {
    public IStatus validatePackageHasExpectedImports(IValidationContext context) {
        IStatus result = null;
        Package package_ = (Package)context.getTarget();
        Set<Package> referenceClosure = this.getUsedPackages(package_);
        Set<Package> allImported = this.getAllImportedPackages(package_);
        referenceClosure.removeAll(allImported);
        if (!referenceClosure.isEmpty()) {
            result = context.createFailureStatus(new Object[]{package_, referenceClosure});
        }
        return result == null ? context.createSuccessStatus() : result;
    }

    private Set<Package> getAllImportedPackages(Package package_) {
        HashSet<Package> result = new HashSet<Package>();
        result.addAll((Collection<Package>)package_.getImportedPackages());
        for (Package nesting : package_.allOwningPackages()) {
            result.addAll((Collection<Package>)nesting.getImportedPackages());
        }
        return result;
    }

    private Set<Package> getUsedPackages(Package package_) {
        HashSet<Package> result = new HashSet<Package>();
        TreeIterator iter = package_.eAllContents();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof Package) {
                iter.prune();
                continue;
            }
            if (!(next instanceof Element)) continue;
            for (EObject xref : ((Element)next).eCrossReferences()) {
                if (!(xref instanceof Classifier)) continue;
                result.add(((Classifier)xref).getNearestPackage());
            }
        }
        result.remove(null);
        result.remove(package_);
        result.removeAll((Collection<?>)package_.allOwningPackages());
        return result;
    }

    public IStatus validatePackageHasCDAImports(IValidationContext context) {
        IStatus result = null;
        Package package_ = (Package)context.getTarget();
        boolean cdaFound = false;
        boolean datatypesFound = false;
        for (Package imported : this.getAllImportedPackages(package_)) {
            if (!cdaFound) {
                cdaFound = CDAModelUtil.isCDAModel((Element)imported);
            }
            if (!datatypesFound) {
                datatypesFound = CDAModelUtil.isDatatypeModel((Element)imported);
            }
            if (cdaFound && datatypesFound) break;
        }
        if (cdaFound && datatypesFound) {
            this.passNested(package_, context);
        } else {
            result = context.createFailureStatus(new Object[]{package_});
        }
        return result == null ? context.createSuccessStatus() : result;
    }

    private void passNested(Package package_, IValidationContext context) {
        for (Package next : package_.getNestedPackages()) {
            context.skipCurrentConstraintFor((EObject)package_);
            this.passNested(next, context);
        }
    }
}

