/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.edit.command.UMLCommandWrapper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class AddCommandWrapper
implements UMLCommandWrapper {
    @Override
    public boolean canWrap(Class<? extends Command> requestedType, CommandParameter parameter) {
        return requestedType == AddCommand.class;
    }

    @Override
    public Command wrap(final Command addCommand, CommandParameter parameter) {
        Resource targetResource;
        CompoundCommand result = new CompoundCommand(addCommand.getLabel(), addCommand.getDescription());
        result.append(addCommand);
        EObject owner = parameter.getEOwner();
        Resource resource = targetResource = owner == null ? null : owner.eResource();
        if (targetResource != null) {
            result.append((Command)new CommandWrapper(){

                protected Command createCommand() {
                    IdentityCommand result = IdentityCommand.INSTANCE;
                    Collection objectsToDetach = AddCommandWrapper.getObjectsToDetach(addCommand.getResult(), targetResource);
                    if (!objectsToDetach.isEmpty()) {
                        result = new RemoveCommand(null, targetResource.getContents(), objectsToDetach);
                    }
                    return result;
                }
            });
            final Collection objectsToAdd = parameter.getCollection();
            result.append((Command)new CommandWrapper(){

                protected Command createCommand() {
                    Object result = IdentityCommand.INSTANCE;
                    final ArrayList<EObject> addedObjects = new ArrayList<EObject>();
                    ArrayList<? extends EObject> stereotypeApplications = new ArrayList<EObject>();
                    TreeIterator iter = EcoreUtil.getAllContents((Collection)objectsToAdd);
                    while (iter.hasNext()) {
                        Object next = iter.next();
                        if (!(next instanceof EObject)) continue;
                        EObject owner = (EObject)next;
                        addedObjects.add(owner);
                        Collection<? extends EObject> stereotypesToAdd = StereotypesCache.getStereotypeApplications(owner);
                        stereotypeApplications.addAll(stereotypesToAdd);
                    }
                    if (!stereotypeApplications.isEmpty()) {
                        result = new CommandWrapper((Command)new AddCommand(null, targetResource.getContents(), stereotypeApplications)){

                            public void execute() {
                                super.execute();
                                for (EObject next : addedObjects) {
                                    StereotypesCache.clearStereotypeApplications(next);
                                }
                            }
                        };
                    }
                    return result;
                }
            });
            result.append((Command)new CommandWrapper(){

                protected Command createCommand() {
                    Object result = IdentityCommand.INSTANCE;
                    result = new AbstractCommand(){

                        public boolean canExecute() {
                            return true;
                        }

                        public boolean canUndo() {
                            return true;
                        }

                        public Collection<?> getResult() {
                            return super.getResult();
                        }

                        protected boolean prepare() {
                            return true;
                        }

                        public void execute() {
                            TreeIterator iter = EcoreUtil.getAllContents((Collection)objectsToAdd);
                            while (iter.hasNext()) {
                                Object next = iter.next();
                                if (!(next instanceof NamedElement)) continue;
                                NamedElement owner = (NamedElement)next;
                                String businessName = BusinessNamesCache.getCachedBusinessNames((EObject)owner);
                                if (businessName != null) {
                                    NamedElementUtil.setBusinessName((NamedElement)owner, (String)businessName);
                                }
                                BusinessNamesCache.clearBusinessNames((EObject)owner);
                            }
                        }

                        public void redo() {
                        }
                    };
                    return result;
                }
            });
        }
        return result.unwrap();
    }

    private static Collection<EObject> getObjectsToDetach(Collection<?> objects, Resource targetResource) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Object next : objects) {
            if (!(next instanceof InternalEObject) || ((InternalEObject)next).eDirectResource() != targetResource) continue;
            result.add((EObject)next);
        }
        return result;
    }

    static class BusinessNamesCache
    extends AdapterImpl {
        String businesName;

        public BusinessNamesCache(String businesName) {
            this.businesName = businesName;
        }

        static void setBusinessNames(EObject element, String businessName) {
            BusinessNamesCache.clearBusinessNames(element);
            element.eAdapters().add((Object)new BusinessNamesCache(businessName));
        }

        static void clearBusinessNames(EObject element) {
            Iterator iter = element.eAdapters().iterator();
            while (iter.hasNext()) {
                if (!((Adapter)iter.next()).isAdapterForType(BusinessNamesCache.class)) continue;
                iter.remove();
                break;
            }
        }

        static String getCachedBusinessNames(EObject element) {
            String result = null;
            Adapter existing = EcoreUtil.getExistingAdapter((Notifier)element, BusinessNamesCache.class);
            if (existing instanceof BusinessNamesCache) {
                result = ((BusinessNamesCache)existing).businesName;
            }
            return result;
        }

        String getBusinessNames(EObject element) {
            String result = null;
            if (element instanceof Element) {
                result = element.eResource() != null ? NamedElementUtil.getPropertyValue((NamedElement)((NamedElement)element), (String)"label") : BusinessNamesCache.getCachedBusinessNames(element);
            }
            return result;
        }

        public boolean isAdapterForType(Object type) {
            return type == BusinessNamesCache.class;
        }

        EObject getETarget() {
            EObject result = null;
            Notifier target = this.getTarget();
            if (target instanceof EObject) {
                result = (EObject)target;
            }
            return result;
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            EObject target = this.getETarget();
            if (target != null && target.eResource() == null) {
                target.eAdapters().remove((Object)this);
            }
        }
    }

    static class StereotypesCache
    extends AdapterImpl {
        private final Collection<? extends EObject> stereotypApplications;

        private StereotypesCache(Collection<? extends EObject> stereotypeApplications) {
            this.stereotypApplications = stereotypeApplications;
        }

        static void setStereotypeApplications(EObject element, Collection<? extends EObject> stereotypApplications) {
            StereotypesCache.clearStereotypeApplications(element);
            element.eAdapters().add((Object)new StereotypesCache(stereotypApplications));
        }

        static void clearStereotypeApplications(EObject element) {
            Iterator iter = element.eAdapters().iterator();
            while (iter.hasNext()) {
                if (!((Adapter)iter.next()).isAdapterForType(StereotypesCache.class)) continue;
                iter.remove();
                break;
            }
        }

        static Collection<? extends EObject> getCachedStereotypeApplications(EObject element) {
            Adapter existing = EcoreUtil.getExistingAdapter((Notifier)element, StereotypesCache.class);
            Collection<Object> result = existing instanceof StereotypesCache ? ((StereotypesCache)existing).stereotypApplications : Collections.emptyList();
            return result;
        }

        static Collection<? extends EObject> getStereotypeApplications(EObject element) {
            EList result = element instanceof Element && element.eResource() != null ? ((Element)element).getStereotypeApplications() : StereotypesCache.getCachedStereotypeApplications(element);
            return result;
        }

        public boolean isAdapterForType(Object type) {
            return type == StereotypesCache.class;
        }

        EObject getETarget() {
            EObject result = null;
            Notifier target = this.getTarget();
            if (target instanceof EObject) {
                result = (EObject)target;
            }
            return result;
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            EObject target = this.getETarget();
            if (target != null && target.eResource() == null) {
                target.eAdapters().remove((Object)this);
            }
        }
    }
}

