/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.mdht.uml.common.notation.NotationUtil;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.edit.IUMLTableProperties;
import org.eclipse.mdht.uml.edit.provider.TrojanHorse;
import org.eclipse.mdht.uml.edit.provider.UML2ExtendedAdapterFactory;
import org.eclipse.mdht.uml.edit.provider.operations.NamedElementOperations;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.edit.providers.ClassItemProvider;

public class ClassExtItemProvider
extends ClassItemProvider
implements ITableItemLabelProvider,
ICellModifier {
    private Collection<? extends EStructuralFeature> myChildrenFeatures;

    public ClassExtItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getImage(Object object) {
        Object elementImage = NotationUtil.getElementImage((Element)((Class)object));
        if (elementImage == null) {
            elementImage = super.getImage(object);
        }
        return elementImage;
    }

    protected String getName(NamedElement namedElement) {
        AdapterFactory adapterFactory = this.getAdapterFactory();
        return adapterFactory instanceof UML2ExtendedAdapterFactory && ((UML2ExtendedAdapterFactory)adapterFactory).isShowBusinessNames() ? NamedElementUtil.getBusinessName((NamedElement)namedElement) : namedElement.getName();
    }

    public String getText(Object object) {
        String label = this.getName((NamedElement)((Class)object));
        return label == null || label.length() == 0 ? this.getString("_UI_Class_type") : label;
    }

    public Collection<Object> getChildren(Object object) {
        Class clazz = (Class)object;
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll((Collection<Object>)clazz.getOwnedComments());
        for (Property property : clazz.getOwnedAttributes()) {
            if (property.getAssociation() != null) continue;
            children.add(property);
        }
        for (Property property : clazz.getOwnedAttributes()) {
            if (property.getAssociation() == null || property.getOtherEnd() == null || property.getOtherEnd().getType() != clazz) continue;
            children.add(property.getAssociation());
        }
        for (Association association : clazz.getAssociations()) {
            if (children.contains(association) || association.getOwnedEnds().size() != 2) continue;
            children.add(association);
        }
        children.addAll((Collection<Object>)clazz.getOwnedOperations());
        for (Classifier classifier : clazz.getNestedClassifiers()) {
            if (children.contains(classifier)) continue;
            children.add(classifier);
        }
        children.addAll((Collection<Object>)clazz.getOwnedRules());
        children.addAll((Collection<Object>)clazz.getClientDependencies());
        children.addAll((Collection<Object>)clazz.getGeneralizations());
        return children;
    }

    private Collection<? extends EStructuralFeature> getMyChildrenFeatures(Object object) {
        if (this.myChildrenFeatures == null) {
            ArrayList<? extends EStructuralFeature> features = new ArrayList<EStructuralFeature>(6);
            features.add((EStructuralFeature)UMLPackage.Literals.ELEMENT__OWNED_COMMENT);
            features.add((EStructuralFeature)UMLPackage.Literals.STRUCTURED_CLASSIFIER__OWNED_ATTRIBUTE);
            features.add((EStructuralFeature)UMLPackage.Literals.CLASS__NESTED_CLASSIFIER);
            features.add((EStructuralFeature)UMLPackage.Literals.NAMESPACE__OWNED_RULE);
            features.add((EStructuralFeature)UMLPackage.Literals.NAMED_ELEMENT__CLIENT_DEPENDENCY);
            features.add((EStructuralFeature)UMLPackage.Literals.CLASSIFIER__GENERALIZATION);
            this.myChildrenFeatures = features;
        }
        return this.myChildrenFeatures;
    }

    protected Command factorMoveCommand(EditingDomain domain, CommandParameter commandParameter) {
        UnexecutableCommand result;
        EObject owner = commandParameter.getEOwner();
        Object child = commandParameter.getValue();
        int index = commandParameter.getIndex();
        boolean isAssociation = child instanceof Association;
        Object toMove = isAssociation ? this.getOwnedEnd(owner, (Association)child) : child;
        EStructuralFeature feature = this.getChildFeature(owner, toMove);
        if (feature != null && feature.isMany()) {
            for (EStructuralFeature eStructuralFeature : this.getMyChildrenFeatures(owner)) {
                if (eStructuralFeature == feature) break;
                if (eStructuralFeature.isMany()) {
                    index -= ((Collection)owner.eGet(eStructuralFeature)).size();
                    continue;
                }
                if (owner.eGet(eStructuralFeature) == null) continue;
                --index;
            }
            if (toMove instanceof Property) {
                Class clazz = (Class)owner;
                List<? extends Property> sortedProperties = this.sortOwnedAttributes(clazz);
                if (index >= 0 && index < sortedProperties.size()) {
                    Property precursor = sortedProperties.get(index);
                    int adjustedIndex = clazz.getOwnedAttributes().indexOf((Object)precursor);
                    result = this.createMoveCommand(domain, owner, feature, toMove, adjustedIndex);
                } else {
                    result = UnexecutableCommand.INSTANCE;
                }
            } else {
                result = this.createMoveCommand(domain, owner, feature, toMove, index);
            }
        } else {
            result = UnexecutableCommand.INSTANCE;
        }
        return result;
    }

    private Property getOwnedEnd(EObject owner, Association association) {
        Property result = null;
        for (Property next : association.getMemberEnds()) {
            if (!EcoreUtil.isAncestor((EObject)owner, (EObject)next)) continue;
            result = next;
            break;
        }
        return result;
    }

    private List<? extends Property> sortOwnedAttributes(Class clazz) {
        EList ownedAttributes = clazz.getOwnedAttributes();
        ArrayList<Property> result = new ArrayList<Property>(ownedAttributes.size());
        for (Property next : ownedAttributes) {
            if (next.getAssociation() != null) continue;
            result.add(next);
        }
        for (Property next : ownedAttributes) {
            if (next.getAssociation() == null || next.getOtherEnd() == null || next.getOtherEnd().getType() != clazz) continue;
            result.add(next);
        }
        return result;
    }

    public Object getColumnImage(Object object, int columnIndex) {
        Class classifier = (Class)object;
        switch (columnIndex) {
            case 0: {
                return this.getImage(object);
            }
            case 5: {
                return NotationUtil.getAnnotationImage((Element)classifier);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Class classifier = (Class)element;
        switch (columnIndex) {
            case 0: {
                return this.getName((NamedElement)classifier);
            }
            case 4: {
                if (VisibilityKind.PUBLIC_LITERAL == classifier.getVisibility()) {
                    return "";
                }
                return classifier.getVisibility().getName();
            }
            case 5: {
                return NotationUtil.getAnnotation((Element)classifier);
            }
            case 6: {
                String text = NotationUtil.getShortDescription((Element)classifier);
                return text == null ? "" : text;
            }
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        if (IUMLTableProperties.NAME_PROPERTY.equals(property)) {
            return true;
        }
        return IUMLTableProperties.VISIBILITY_PROPERTY.equals(property);
    }

    public Object getValue(Object element, String property) {
        Classifier classifier = (Classifier)element;
        if (IUMLTableProperties.NAME_PROPERTY.equals(property)) {
            return classifier.getName();
        }
        if (IUMLTableProperties.VISIBILITY_PROPERTY.equals(property)) {
            return new Integer(classifier.getVisibility().getValue());
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        NamedElementOperations.modify(element, property, value);
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        IdentityCommand result;
        ArrayList<Association> associations = new ArrayList<Association>();
        for (Object next : collection) {
            if (!(next instanceof Association)) continue;
            associations.add((Association)next);
        }
        if (!associations.isEmpty()) {
            ArrayList<Association> newCollection = new ArrayList<Association>(collection);
            newCollection.removeAll(associations);
            collection = newCollection;
        }
        Object object = result = collection.isEmpty() && !associations.isEmpty() ? IdentityCommand.INSTANCE : super.createAddCommand(domain, owner, feature, collection, index);
        if (!associations.isEmpty() && result.canExecute()) {
            Package nearestPackage = ((Class)owner).getNearestPackage();
            CompoundCommand compound = new CompoundCommand(Integer.MAX_VALUE);
            compound.append((Command)result);
            result = compound;
            compound.append(AddCommand.create((EditingDomain)domain, (Object)nearestPackage, (Object)UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT, TrojanHorse.wrap(associations, (Object)owner, feature, this.adapterFactory)));
            if (owner.eResource() != nearestPackage.eResource()) {
                compound.append((Command)new AddCommand(domain, owner.eResource().getContents(), associations));
            }
            ArrayList<Property> navigableEnds = new ArrayList<Property>();
            for (Association next : associations) {
                for (Property end : next.getMemberEnds()) {
                    if (end.getOwner() != null) continue;
                    navigableEnds.add(end);
                }
            }
            if (!navigableEnds.isEmpty()) {
                compound.append(AddCommand.create((EditingDomain)domain, (Object)owner, (Object)UMLPackage.Literals.STRUCTURED_CLASSIFIER__OWNED_ATTRIBUTE, navigableEnds));
                Type type = (Type)owner;
                for (Property next : navigableEnds) {
                    Property other = next.getOtherEnd();
                    if (other == null) continue;
                    compound.append(SetCommand.create((EditingDomain)domain, (Object)other, (Object)UMLPackage.Literals.TYPED_ELEMENT__TYPE, (Object)type));
                }
            }
        }
        return result;
    }
}

