/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.ui.actions.UML2AbstractAction;
import org.eclipse.mdht.uml.ui.internal.Logger;
import org.eclipse.mdht.uml.ui.internal.l10n.UML2UIMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;

public class AddStereotypeAction
extends UML2AbstractAction {
    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.isReadOnly()) {
            action.setEnabled(false);
        }
    }

    public void run(IAction action) {
        try {
            final Element element = this.getSelectedElement();
            if (element instanceof Profile) {
                final Profile profile = (Profile)element;
                AbstractEMFOperation operation = new AbstractEMFOperation(this.editingDomain, UML2UIMessages.AddStereotype_operation_title){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                        String stereotypeName = null;
                        InputDialog inputDialog = new InputDialog(AddStereotypeAction.this.activePart.getSite().getShell(), "New Stereotype", "Enter stereotype name", "", null);
                        if (inputDialog.open() == 0) {
                            stereotypeName = inputDialog.getValue();
                        }
                        if (stereotypeName == null || stereotypeName.length() == 0) {
                            return Status.CANCEL_STATUS;
                        }
                        Stereotype newStereotype = UMLFactory.eINSTANCE.createStereotype();
                        newStereotype.setName(stereotypeName);
                        profile.getOwnedTypes().add((Object)newStereotype);
                        Class metaclass = DialogLaunchUtil.chooseUMLMetaclass((ResourceSet)element.eResource().getResourceSet(), (Shell)AddStereotypeAction.this.activePart.getSite().getShell(), (String)"Metaclass Selection", (String)"Select UML metaclass for extension:");
                        if (metaclass != null) {
                            if (!profile.getReferencedMetaclasses().contains((Object)metaclass) && !profile.getReferencedMetamodels().contains((Object)metaclass.getModel())) {
                                profile.createMetaclassReference((PackageableElement)metaclass);
                            }
                            newStereotype.createExtension(metaclass, false);
                        }
                        if (AddStereotypeAction.this.activePart instanceof ISetSelectionTarget) {
                            ((ISetSelectionTarget)AddStereotypeAction.this.activePart).selectReveal((ISelection)new StructuredSelection((Object)newStereotype));
                        }
                        return Status.OK_STATUS;
                    }
                };
                try {
                    IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)this.editingDomain.getCommandStack();
                    operation.addContext(commandStack.getDefaultUndoContext());
                    commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), (IAdaptable)this.activePart);
                }
                catch (ExecutionException ee) {
                    Logger.logException(ee);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

