/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.notation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mdht.uml.common.internal.Logger;
import org.eclipse.mdht.uml.common.notation.INotationProvider;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;

public class NotationRegistry {
    public static final NotationRegistry INSTANCE = new NotationRegistry();
    private Map<String, INotationProvider> providers = null;
    private static final String EXTENSION_POINT = "org.eclipse.mdht.uml.common.notation";
    private static final String PROVIDER_ELEMENT = "provider";
    private static final String ATT_PROFILE_URI = "profileURI";
    private static final String ATT_CLASS = "class";

    private NotationRegistry() {
    }

    private void load() {
        IExtensionPoint point;
        this.providers = new HashMap<String, INotationProvider>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null && (point = registry.getExtensionPoint(EXTENSION_POINT)) != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (PROVIDER_ELEMENT.equals(element.getName()) && this.validateProvider(element)) {
                        try {
                            Object providerInstance = element.createExecutableExtension(ATT_CLASS);
                            if (providerInstance instanceof INotationProvider) {
                                String profileURI = element.getAttribute(ATT_PROFILE_URI);
                                this.providers.put(profileURI.toLowerCase(), (INotationProvider)providerInstance);
                            } else {
                                String className = element.getAttribute(ATT_CLASS);
                                Logger.log(4, String.valueOf(className) + " is not instanceof INotationProvider.");
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            Logger.logException(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private boolean validateProvider(IConfigurationElement element) {
        return element.getAttribute(ATT_PROFILE_URI) != null && element.getAttribute(ATT_CLASS) != null;
    }

    private INotationProvider getProviderInstance(String profileURI) {
        if (this.providers == null) {
            this.load();
        }
        return this.providers.get(profileURI.toLowerCase());
    }

    public INotationProvider getNotationProvider(Element element) {
        if (this.providers == null) {
            this.load();
        }
        if (element.getNearestPackage() != null) {
            for (Profile profile : element.getNearestPackage().getAllAppliedProfiles()) {
                INotationProvider provider;
                String profileURI;
                if (profile.getDefinition() != null && profile.getDefinition().getNsURI() != null) {
                    profileURI = profile.getDefinition().getNsURI().toLowerCase();
                    for (String providerURI : this.providers.keySet()) {
                        if (!profileURI.startsWith(providerURI)) continue;
                        return this.providers.get(providerURI);
                    }
                }
                if (profile.eResource() == null || (provider = INSTANCE.getProviderInstance(profileURI = profile.eResource().getURI().toString())) == null) continue;
                return provider;
            }
        }
        return null;
    }
}

