/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.mdht.api.CDAOCLHandler;
import org.eclipse.mdht.api.transform.APITransformationBuilder;
import org.eclipse.mdht.transform.core.ITransformMonitor;
import org.eclipse.mdht.transform.core.NullTransformMonitor;
import org.eclipse.mdht.transform.core.TransformationBuilder;
import org.eclipse.mdht.transformation.ocl.OCLTransformation;
import org.eclipse.mdht.uml.cda.core.profile.SeverityKind;
import org.eclipse.mdht.uml.cda.core.profile.Validation;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.core.util.ClinicalDocumentCreator;
import org.eclipse.mdht.uml.cda.core.util.ModelStatus;
import org.eclipse.mdht.uml.cda.transform.EcoreTransformationBuilder;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.mdht.uml.term.core.profile.TermPackage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import traceability.LogEntry;
import traceability.Trace;
import traceability.TraceabilityFactory;
import traceability.Traces;
import traceability.util.TraceabilityUtils;

public abstract class GenerateAPIAction
implements IObjectActionDelegate {
    protected static final String DEL_CDA_BODY_LEVEL_3 = "CDA Body Level 3";
    protected static final String DEL_CDA_BODY_LEVEL_2 = "CDA Body Level 2";
    protected static final String DEL_CDA_HEADER = "CDA Header";
    protected static final String DEL_CDA_NA = "N/A";
    protected ClinicalDocumentCreator creator;
    private List<IFile> files = new ArrayList<IFile>();
    protected File genfolder;
    protected Class umlClinicalDocument;
    protected List<Class> umlClinicalDocuments = new ArrayList<Class>();
    private String specName;
    private String specInitials;
    protected String specContractedName;
    protected File summaryFile;
    protected OCLTransformation<Package, Classifier, ?, Property, ?, ?, ?, ?, ?, ?, ?, ?> trafo;
    protected List<Class> classes;
    protected Set<Class> processedClasses = new HashSet<Class>();
    protected String template;
    private Object[] templateVariableParameters;
    private Map<Object[], String> cachedResolve = new WeakHashMap<Object[], String>();
    protected List<ModelStatus> statuses = new ArrayList<ModelStatus>();
    private Profile profile;
    protected boolean removeTabAndNewline;
    protected Resource resource;
    protected List<Resource> irResources;
    protected IFile umlFile;
    protected Traces currentCategory;
    private static Set<String> ambiguousTemplateVariables = new HashSet<String>(Arrays.asList("{pdf-section-number}", "{pdf-section-order}", "{level-2-pdf-section-number}", "{level-2-pdf-section-name}", "{uml-context}", "{data-element-level}", "{data-element-level-abbr}", "{full-xpath}", "{xpath-context}"));
    private Collection<Object[]> ambiguousTemplateBindings = new ArrayList<Object[]>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.files = new ArrayList<IFile>();
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        for (IFile file : sSelection) {
            this.files.add(file);
        }
        action.setEnabled(!this.files.isEmpty());
    }

    public boolean isEnabled() {
        return !this.files.isEmpty();
    }

    public void run(IAction action) {
        this.statuses.clear();
        for (final IFile modelFile : this.files) {
            final Shell shell = Display.getDefault().getActiveShell();
            Job job = new Job("Generate " + this.getTargetLanguage() + " for " + modelFile.getName().substring(0, modelFile.getName().length() - ".uml".length())){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        GenerateAPIAction duplicate = (GenerateAPIAction)GenerateAPIAction.this.getClass().newInstance();
                        return duplicate.genAPI(modelFile, monitor, shell);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            job.schedule();
        }
    }

    protected abstract String getTargetLanguage();

    protected IStatus genAPI(IFile modelFile, IProgressMonitor monitor, Shell shell) {
        IStatus status;
        Package pack;
        ResourceSetImpl resourceSet;
        String modelname;
        block20: {
            this.umlFile = modelFile;
            modelname = modelFile.getName().substring(0, modelFile.getName().lastIndexOf("."));
            this.specName = "Undefined Clinical Document";
            monitor.setTaskName("Load UML model");
            resourceSet = new ResourceSetImpl(){

                public Resource getResource(URI uri, boolean loadOnDemand) {
                    if (uri.toString().contains("///")) {
                        uri = URI.createURI((String)uri.toString().replace("///", "/"));
                    }
                    return super.getResource(uri, loadOnDemand);
                }
            };
            CDACommonUtils.patchResourceSet((ResourceSet)resourceSet);
            this.trafo = this.createTrafo((ResourceSet)resourceSet);
            this.genfolder = this.genfolder(modelFile.getLocation().toFile().getParentFile());
            this.summaryFile = new File(this.genfolder, "summary.html");
            this.resource = resourceSet.getResource(URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true), true);
            pack = (Package)this.resource.getContents().get(0);
            this.irResources = new ArrayList<Resource>();
            this.irResources.add(this.resource);
            Resource profileRes = pack.eResource().getResourceSet().getResource(URI.createURI((String)"platform:/plugin/org.eclipse.mdht.api/model/api.profile.uml"), true);
            this.profile = (Profile)profileRes.getContents().get(0);
            monitor.worked(1);
            monitor.setTaskName("Building OCL constraints");
            if (monitor.isCanceled()) {
                throw new RuntimeException("Canceled by user");
            }
            this.umlClinicalDocument = null;
            for (NamedElement ne : pack.getPackagedElements()) {
                if (!(ne instanceof Class) || !CDACommonUtils.isClinicalDocument((Type)((Class)ne))) continue;
                this.umlClinicalDocument = (Class)ne;
                CDACommonUtils.buildupPropertyForClinicalDocument((Class)this.umlClinicalDocument);
                this.specName = CDACommonUtils.getBusinessName((NamedElement)ne);
                this.umlClinicalDocuments.add(this.umlClinicalDocument);
            }
            if (this.umlClinicalDocument != null || "datatypes".equals(pack.getName())) break block20;
            CDACommonUtils.addStatus(this.statuses, (int)4, (String)this.getPlugin(), (int)3, (String)"Cannot find a clinical document template in the UML model!", (EObject[])new EObject[0]);
            IStatus iStatus = this.alertGenerationResult(shell, null);
            monitor.setTaskName("Refresh workspace");
            try {
                modelFile.getParent().getParent().refreshLocal(2, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            monitor.setTaskName("Finished");
            return iStatus;
        }
        try {
            try {
                this.calcClasses();
                for (Class clazz : this.classes) {
                    if (clazz.eResource() == null || this.irResources.contains(clazz.eResource())) continue;
                    this.irResources.add(clazz.eResource());
                }
                URI tracesUri = URI.createFileURI((String)new File(this.genfolder, String.valueOf(modelname) + ".schematron.uml.anytraces").toString());
                this.currentCategory = TraceabilityUtils.createTraceModel((URI)tracesUri, (String)this.resource.getURI().toString(), (ResourceSet)resourceSet, (boolean)false, (String)this.getTargetLanguage());
                this.currentCategory.setSourceModel((EObject)pack);
                this.specContractedName = this.specName.replace(" ", "");
                this.specInitials = WordUtils.initials((String)this.specName);
                this.creator = new ClinicalDocumentCreator(this.umlClinicalDocument, this.resource.getResourceSet(), this.statuses);
                this.fixUMLModel();
                boolean directSave = Boolean.getBoolean("USE_FLATTENED_ORIGINAL_OCL_GENERATOR");
                if (directSave) {
                    this.saveModelCopies(monitor, true);
                }
                if (this.trafo != null) {
                    for (Resource resource : this.irResources) {
                        TransformationBuilder builder = Boolean.getBoolean("USE_FLATTENED_ORIGINAL_OCL_GENERATOR") ? EcoreTransformationBuilder.create() : APITransformationBuilder.create();
                        builder.build().execute((Iterable)CDACommonUtils.getAllContents((Resource)resource), (ITransformMonitor)new NullTransformMonitor());
                    }
                    monitor.worked(19);
                    if (monitor.isCanceled()) {
                        throw new RuntimeException("Canceled by user");
                    }
                }
                this.calcClasses();
                long start = System.currentTimeMillis();
                monitor.setTaskName("Building " + this.getTargetLanguage() + " file");
                this.genAPICode(pack, monitor);
                long end = System.currentTimeMillis();
                System.out.println(String.valueOf(this.getTargetLanguage()) + " generation took " + (end - start) + "ms");
                if (!directSave) {
                    this.saveModelCopies(monitor, false);
                }
                status = this.alertGenerationResult(shell, null);
            }
            catch (Exception e) {
                status = this.alertGenerationResult(shell, e);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            monitor.setTaskName("Refresh workspace");
            try {
                modelFile.getParent().getParent().refreshLocal(2, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            monitor.setTaskName("Finished");
        }
        return status;
    }

    private void calcClasses() {
        this.classes = new ArrayList<Class>();
        if (this.umlClinicalDocuments.isEmpty()) {
            this.classes.addAll(CDACommonUtils.getAllContents(this.irResources, Class.class));
        } else {
            for (Class class1 : this.umlClinicalDocuments) {
                this.calcClasses(class1, this.classes);
            }
        }
    }

    private void saveModelCopies(IProgressMonitor monitor, boolean changeURIOnly) throws IOException, FileNotFoundException {
        if (this.trafo == null) {
            return;
        }
        for (Resource resource : this.irResources) {
            File file = this.getModelCopyFile(resource);
            if (changeURIOnly) {
                resource.setURI(URI.createFileURI((String)file.toString()));
                continue;
            }
            monitor.setTaskName("Writing " + file.getName());
            resource.save((OutputStream)new FileOutputStream(file), null);
        }
    }

    private File getModelCopyFile(Resource resource) {
        File file = new File(this.genfolder, resource.getURI().trimFileExtension().appendFileExtension("schematron.uml").lastSegment());
        return file;
    }

    protected abstract String getRootFileExtension();

    protected String getPlugin() {
        return "org.eclipse.mdht.api";
    }

    protected abstract File genfolder(File var1);

    private IStatus alertGenerationResult(Shell shell, Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
        if (e != null) {
            CDACommonUtils.addStatus(this.statuses, (int)4, (String)this.getPlugin(), (int)0, (String)"Transformation terminated with an exception", (Exception)e, (EObject[])new EObject[0]);
        }
        if (this.currentCategory != null) {
            for (ModelStatus status : this.statuses) {
                LogEntry trace = TraceabilityFactory.eINSTANCE.createLogEntry();
                trace.setMessage(status.getMessage());
                trace.setSeverity(status.getSeverity() == 4 ? 0 : (status.getSeverity() == 2 ? 1 : 2));
                trace.setMessageType(status.getCode());
                EObject[] eObjectArray = status.getParticipants();
                int n = eObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject participant = eObjectArray[n2];
                    if (participant != null) {
                        URI resolved;
                        Property property;
                        if (participant instanceof Property && (property = (Property)participant).getAssociation() != null) {
                            participant = property.getAssociation();
                        }
                        Resource res = participant.eResource();
                        if (participant instanceof Constraint && this.irResources.contains(res)) {
                            URI uri = URI.createFileURI((String)this.getModelCopyFile(res).toString()).appendFragment(res.getURIFragment(participant));
                            ((InternalEObject)participant).eSetProxyURI(uri);
                        } else if (res != null && !(resolved = res.getResourceSet().getURIConverter().normalize(res.getURI())).equals(res.getURI())) {
                            URI uri = resolved.appendFragment(res.getURIFragment(participant));
                            ((InternalEObject)participant).eSetProxyURI(uri);
                        }
                        trace.getParticipants().add((Object)participant);
                    }
                    ++n2;
                }
                TraceabilityUtils.addTrace((Traces)this.currentCategory, (Object)trace);
            }
            try {
                this.currentCategory.eResource().save(null);
                if (e == null) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                URIEditorInput i = new URIEditorInput(GenerateAPIAction.this.currentCategory.eResource().getURI());
                                IPath location = Path.fromOSString((String)GenerateAPIAction.this.currentCategory.eResource().getURI().toFileString());
                                IFile file = GenerateAPIAction.this.umlFile.getWorkspace().getRoot().getFileForLocation(location);
                                if (file != null) {
                                    i = new FileEditorInput(file);
                                }
                                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)i, (String)"traceability.presentation.ReflectiveTraceabilityEditorID");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (this.statuses.isEmpty()) {
            return Status.OK_STATUS;
        }
        String message = String.valueOf(this.specName) + ": " + this.getTargetLanguage() + (e != null ? " generation did not finish" : " generation finished with problems");
        return new MultiStatus(this.getPlugin(), 4, this.statuses.toArray(new IStatus[0]), message, (Throwable)e);
    }

    private void fixUMLModel() {
        for (Property property : CDACommonUtils.getAllContents(this.irResources, Property.class)) {
            property.setIsReadOnly(true);
            if ("ENV".equals(property.getDefault())) {
                property.setDefault("EVN");
            }
            if (property.getDefault() == null && CDACommonUtils.getDefault((Property)property) != null) {
                property.setStringDefaultValue(CDACommonUtils.getDefault((Property)property));
            }
            if (property.getName() == null || !(property.eContainer() instanceof Class)) continue;
            CDACommonUtils.getCDAProperty((Property)property, this.statuses);
        }
        if (this.trafo == null) {
            return;
        }
        for (Class clazz : CDACommonUtils.getAllContents(this.irResources, Class.class)) {
            for (Property property1 : clazz.getAttributes()) {
                Property baseProperty1 = CDACommonUtils.getCDAProperty((Property)property1);
                if (baseProperty1 == null || !(property1.getType() instanceof Class) || this.trafo == null) continue;
                Class class1 = (Class)property1.getType();
                String xpath1 = this.trafo.getTypeCheck((Object)class1);
                for (Property property2 : clazz.getAttributes()) {
                    Property baseProperty2 = CDACommonUtils.getCDAProperty((Property)property2);
                    if (baseProperty2 == null || !(property2.getType() instanceof Class) || clazz.getAttributes().indexOf((Object)property1) >= clazz.getAttributes().indexOf((Object)property2)) continue;
                    Class class2 = (Class)property2.getType();
                    String xpath2 = this.trafo.getTypeCheck((Object)class2);
                    if (property1 != property2 && baseProperty1 == baseProperty2 && xpath1 != null && xpath1.equals(xpath2)) {
                        CDACommonUtils.addStatus(this.statuses, (int)2, (String)this.getPlugin(), (int)14, (String)(String.valueOf(property1.getQualifiedName()) + " and  " + property2.getQualifiedName() + " have the same xpath type expression " + xpath1), (EObject[])new EObject[]{property1, property2});
                    }
                    if (property1 == property2 || baseProperty1 != baseProperty2 || xpath1 != null && xpath2 != null) continue;
                    Property property = xpath1 == null ? property1 : property2;
                    Class class_ = (Class)property.getType();
                    CDACommonUtils.addStatus(this.statuses, (int)2, (String)this.getPlugin(), (int)15, (String)this.mentionSection(String.valueOf(class_.getQualifiedName()) + " is missing a OCL filter, template ID, code or classCode definition", clazz, (NamedElement)property), (EObject[])new EObject[]{class_});
                }
            }
        }
        for (Association association : CDACommonUtils.getAllContents(this.irResources, Association.class)) {
            Object severity;
            Property property;
            if (!(CDACommonUtils.getMDHTRepresentative((NamedElement)association) instanceof Property) || !((property = (Property)CDACommonUtils.getMDHTRepresentative((NamedElement)association)).eContainer() instanceof Class) || !CDACommonUtils.hasPropertyPath((Property)property)) continue;
            Class class1 = (Class)property.eContainer();
            Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)association, (String)"AssociationValidation");
            Object object = severity = stereotype != null ? association.getValue(stereotype, "severity") : null;
            if (severity != null) continue;
            CDACommonUtils.addStatus(this.statuses, (int)2, (String)this.getPlugin(), (int)30, (String)this.mentionSection(String.valueOf(property.getQualifiedName()) + " has no severity applied, hence this association will have no constraint generated", class1, (NamedElement)property), (EObject[])new EObject[]{property});
        }
        for (Property property : CDACommonUtils.getAllContents(this.irResources, Property.class)) {
            Object severity;
            if (property.getAssociation() != null || !(property.eContainer() instanceof Class) || !CDACommonUtils.hasPropertyPath((Property)property)) continue;
            Class class1 = (Class)property.eContainer();
            Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)property, (String)"PropertyValidation");
            Object object = severity = stereotype != null ? property.getValue(stereotype, "severity") : null;
            if (severity != null) continue;
            CDACommonUtils.addStatus(this.statuses, (int)2, (String)this.getPlugin(), (int)31, (String)this.mentionSection(String.valueOf(property.getQualifiedName()) + " has no severity applied, hence this property will have no constraint generated", class1, (NamedElement)property), (EObject[])new EObject[]{property});
        }
        HashMap<String, NamedElement> nameCheck = new HashMap<String, NamedElement>();
        for (NamedElement namedElement : CDACommonUtils.getAllContents(this.irResources, NamedElement.class)) {
            NamedElement existing;
            if (namedElement.getName() == null || namedElement.getQualifiedName() == null || namedElement instanceof InstanceValue || namedElement instanceof Constraint || (existing = nameCheck.put(namedElement.getQualifiedName(), namedElement)) == null || existing == namedElement) continue;
            CDACommonUtils.addStatus(this.statuses, (int)2, (String)this.getPlugin(), (int)32, (String)("Two UML elements share the same qualified name: " + namedElement.getQualifiedName()), (EObject[])new EObject[]{namedElement, existing});
            System.out.println("Two UML elements share the same qualified name: " + namedElement.getQualifiedName());
        }
    }

    protected String getStereotype(NamedElement element, String name) {
        Object object;
        Stereotype stereotype = (Stereotype)this.profile.getPackagedElement(element instanceof Package ? "SchematronSupport" : "SchematronConfig");
        if (element.hasValue(stereotype, name) && (object = element.getValue(stereotype, name)) != null) {
            return "" + object;
        }
        return stereotype.getAttribute(name, null).getDefault();
    }

    protected abstract String toValidFileName(String var1);

    protected abstract void genAPICode(Package var1, IProgressMonitor var2) throws Exception;

    protected abstract OCLTransformation<Package, Classifier, ?, Property, ?, ?, ?, ?, ?, ?, ?, ?> createTrafo(ResourceSet var1);

    protected NamedElement getConstrainedElement(Constraint constraint) {
        OpaqueExpression spec;
        NamedElement element;
        if (constraint.getConstrainedElements().isEmpty()) {
            return null;
        }
        Element x = (Element)constraint.getConstrainedElements().get(0);
        if (constraint.getConstrainedElements().size() >= 2) {
            x = constraint.getContext();
        }
        if (Boolean.parseBoolean(this.getStereotype(element = CDACommonUtils.getMDHTRepresentative((NamedElement)((NamedElement)x)), "noSchematronGen"))) {
            return null;
        }
        Class clazz = (Class)constraint.getContext();
        if (constraint.getName() != null && constraint.getName().endsWith("TemplateId") && this.creator.getTemplateIdProperty(clazz) != null && element instanceof Class) {
            element = this.creator.getTemplateIdProperty(clazz);
        } else if (element == constraint.getContext()) {
            element = constraint;
        } else if (CDACommonUtils.getParentingProperty((Constraint)constraint) != null) {
            element = constraint;
        }
        OpaqueExpression opaqueExpression = spec = constraint.getSpecification() instanceof OpaqueExpression ? (OpaqueExpression)constraint.getSpecification() : null;
        if (spec == null) {
            return null;
        }
        return element;
    }

    protected String getFullXPath(Class clazz, NamedElement element) {
        Property property;
        if (element instanceof Property && (property = (Property)element).getType() instanceof Class) {
            List propertyPath = CDACommonUtils.getPropertyPath((Class)clazz);
            propertyPath.add(property);
            return this.getCdaContext(propertyPath, false);
        }
        return this.getCdaContext(clazz, false);
    }

    protected String getCdaContext(Class clazz, boolean checkRedefines) {
        List propertyPath = CDACommonUtils.getPropertyPath((Class)clazz);
        return this.getCdaContext(propertyPath, checkRedefines);
    }

    protected String getCdaContext(List<Property> propertyPath, boolean checkRedefines) {
        if (this.trafo == null) {
            return null;
        }
        String context = "/cda:ClinicalDocument";
        EObject lastPredicate = null;
        int nextProperty = 0;
        for (Property childProperty : propertyPath) {
            ++nextProperty;
            context = this.trafo.step(context, (Object)childProperty);
            String i = this.trafo.newVar();
            if (lastPredicate != null) {
                context = this.trafo.predicate(context, ((CDAOCLHandler)this.trafo.getDomainSpecificOCLHandler()).getCodeOrClasscodeCheckForPredicate(lastPredicate, i), i);
                lastPredicate = null;
                continue;
            }
            if (checkRedefines && this.isRedefines(childProperty)) continue;
            Property cdaProperty = CDACommonUtils.getCDAProperty((Property)childProperty);
            if (!checkRedefines && cdaProperty != null && !cdaProperty.isMultivalued() || !(childProperty.getType() instanceof Class)) continue;
            Class class1 = (Class)childProperty.getType();
            if (propertyPath.size() > nextProperty && propertyPath.get(nextProperty) == CDACommonUtils.getPropertyForTypeCheck((Class)class1)) {
                lastPredicate = CDACommonUtils.getPredicateForTypeCheck((Class)class1);
                continue;
            }
            String predicate = this.trafo.getTypeCheck((Object)class1, i);
            if (predicate == null) continue;
            context = this.trafo.predicate(context, predicate, i);
        }
        return context.toString();
    }

    private boolean isRedefines(Property property) {
        Property baseProperty = CDACommonUtils.getCDAProperty((Property)property);
        if (baseProperty != null && baseProperty != property && (property.getName().equals(baseProperty.getName()) || property.getRedefinedProperties().contains((Object)baseProperty)) && property.eContainer() instanceof Class) {
            Class clazz = (Class)property.eContainer();
            for (Property otherProperty : clazz.getAttributes()) {
                if (otherProperty == property || CDACommonUtils.getCDAProperty((Property)otherProperty) != baseProperty) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String getXPathTest(Constraint constraint) {
        if (this.trafo == null) {
            return null;
        }
        String xpath = this.getBody(constraint, "XPath");
        String ocl = this.getBody(constraint, "OCL");
        if (xpath == null && ocl != null) {
            Classifier classifier = (Classifier)constraint.getContext();
            if (CDACommonUtils.getCDAType((Classifier)classifier) != null) {
                classifier = CDACommonUtils.getCDAType((Classifier)classifier);
            }
            ocl = ocl.replace("assignedPerson", "xyz").replace("self.xyz", "self.assignedPerson");
            xpath = this.trafo.transform((Object)classifier, ocl);
        } else if (xpath == null) {
            xpath = this.trafo.cosmetics("true()");
        }
        return xpath;
    }

    protected String resolve(String template, String name, String value) {
        if (value == null) {
            value = "n/a";
            if (this.removeTabAndNewline && "{uml-multiplicity}".equals(name)) {
                Validation validation = CDAProfileUtil.getValidation((Element)((Element)this.templateVariableParameters[1]));
                value = validation != null && SeverityKind.ERROR == validation.getSeverity() ? "1..1" : "0..1";
            }
        }
        return template.replace(name, value);
    }

    protected boolean needResolve(Object ... params) {
        String name = (String)params[0];
        if (!this.template.contains(name)) {
            return false;
        }
        if (this.cachedResolve.containsKey(params)) {
            this.template = this.resolve(this.template, name, this.cachedResolve.get(params));
            return false;
        }
        this.templateVariableParameters = params;
        return true;
    }

    protected void resolve(String value) {
        this.cachedResolve.put(this.templateVariableParameters, value);
        String name = (String)this.templateVariableParameters[0];
        this.template = this.resolve(this.template, name, value);
        if (ambiguousTemplateVariables.contains(name)) {
            this.ambiguousTemplateBindings.add(this.templateVariableParameters);
        }
    }

    protected String resolve(String template, Class clazz, NamedElement element) {
        this.template = template;
        if (this.needResolve("{test-types-covered}", clazz, element)) {
            this.resolve("");
        }
        if (this.needResolve("{test-file-anchors}", clazz, element)) {
            this.resolve("");
        }
        if (this.needResolve("{uml-element-name}", element)) {
            this.resolve(element.getName());
        }
        if (this.needResolve("{uml-business-name}", element)) {
            this.resolve(this.getBusinessName(element));
        }
        if (this.needResolve("{uml-context-class-business-name}", clazz)) {
            this.resolve(this.getBusinessName((NamedElement)clazz));
        }
        if (this.needResolve("{conformance-rule}", clazz, element)) {
            this.resolve(this.getConformance(clazz, (Element)element));
        }
        if (this.needResolve("{pdf-section-number}", clazz, element)) {
            this.resolve(GenerateAPIAction.getPDFSection(clazz, (Element)element));
        }
        if (this.needResolve("{pdf-section-order}", clazz, element)) {
            this.resolve(GenerateAPIAction.getPDFSectionOrder(clazz, (Element)element));
        }
        if (this.needResolve("{level-2-pdf-section-number}", clazz, element)) {
            this.resolve(GenerateAPIAction.getLevel2PDFSectionNumber(clazz, (Element)element));
        }
        if (this.needResolve("{level-2-pdf-section-name}", clazz, element)) {
            this.resolve(GenerateAPIAction.getLevel2PDFSectionName(clazz, (Element)element));
        }
        if (this.needResolve("{clinical-document-code}")) {
            this.resolve(this.getClinicalDocumentCode(TermPackage.eINSTANCE.getCodeSystemConstraint_Code()));
        }
        if (this.needResolve("{clinical-document-code-system}")) {
            this.resolve(this.getClinicalDocumentCode(TermPackage.eINSTANCE.getCodeSystemConstraint_Identifier()));
        }
        if (this.needResolve("{clinical-document-code-system-name}")) {
            this.resolve(this.getClinicalDocumentCode(TermPackage.eINSTANCE.getCodeSystemConstraint_Name()));
        }
        if (this.needResolve("{clinical-document-display-name}")) {
            this.resolve(this.getClinicalDocumentCode(TermPackage.eINSTANCE.getCodeSystemConstraint_DisplayName()));
        }
        if (this.needResolve("{uml-context}", clazz)) {
            this.resolve(CDACommonUtils.getUmlContext((Class)clazz));
        }
        if (this.needResolve("{clinical-document-business-name}")) {
            this.resolve(this.specName);
        }
        if (this.needResolve("{document-name-abbr}")) {
            this.resolve(this.specInitials);
        }
        if (this.needResolve("{cda-property-name}", element)) {
            this.resolve(this.getCdaPropertyName(element));
        }
        if (this.needResolve("{cda-type}", element)) {
            this.resolve(this.getCdaType(element));
        }
        if (this.needResolve("{uml-multiplicity}", element)) {
            this.resolve(this.getMultiplicityString(clazz, element));
        }
        if (this.needResolve("{uml-default-value}", element)) {
            this.resolve(this.getDefault(element));
        }
        if (this.needResolve("{template-id}", clazz)) {
            this.resolve(CDACommonUtils.getTemplateId((Class)clazz));
        }
        if (this.needResolve("{data-element-level}", clazz, element)) {
            this.resolve(this.getDataElementLevel(clazz, (Element)element));
        }
        if (this.needResolve("{data-element-level-abbr}", clazz, element)) {
            this.resolve(this.getDEL(this.getDataElementLevel(clazz, (Element)element)));
        }
        if (this.needResolve("{full-xpath}", clazz, element)) {
            this.resolve(this.getFullXPath(clazz, element));
        }
        if (this.needResolve("{xpath-context}", clazz)) {
            this.resolve(this.getCdaContext(clazz, false));
        }
        if (this.needResolve("{custom-validation-message}")) {
            this.resolve(this.getStereotype(element, "validationMessageTemplate"));
        }
        if (this.needResolve("{severity}", element)) {
            this.resolve(this.getSeverity(element));
        }
        if (this.removeTabAndNewline) {
            this.template = this.resolve(this.template, "\"", "'");
            this.template = this.resolve(this.template, "\r", " ");
            this.template = this.resolve(this.template, "\n", " ");
            this.template = this.resolve(this.template, "\t", " ");
        }
        if (this.needResolve("{tab}")) {
            this.resolve("\t");
        }
        if (this.needResolve("{newline}")) {
            this.resolve("\n");
        }
        return this.template;
    }

    private String getClinicalDocumentCode(EAttribute attribute) {
        if (this.umlClinicalDocument != null) {
            for (Property property : this.umlClinicalDocument.getAllAttributes()) {
                CodeSystemConstraint codeSystemConstraint = CDACommonUtils.getCodeSystemConstraint((Property)property);
                if (codeSystemConstraint == null) continue;
                String result = (String)codeSystemConstraint.eGet((EStructuralFeature)attribute);
                if (result == null && attribute == TermPackage.eINSTANCE.getCodeSystemConstraint_Identifier() && codeSystemConstraint.getReference() != null) {
                    return codeSystemConstraint.getReference().getIdentifier();
                }
                return result;
            }
        }
        return null;
    }

    private String getSeverity(NamedElement element) {
        Validation cv;
        if (element instanceof Property && ((Property)element).getAssociation() != null) {
            element = ((Property)element).getAssociation();
        }
        return (cv = CDAProfileUtil.getValidation((Element)element)) != null ? cv.getSeverity().toString() : null;
    }

    protected String resolve(String template, Class clazz, NamedElement element, String testType) {
        this.template = template;
        if (this.needResolve("{test-type}", testType)) {
            this.resolve(testType);
        }
        return this.resolve(this.template, clazz, element);
    }

    protected String resolve(String template, Class clazz, NamedElement element, Constraint constraint) {
        this.template = template;
        if (this.needResolve("{ocl-constraint-name}", constraint)) {
            this.resolve(this.getConstraintName(constraint));
        }
        if (this.needResolve("{ocl-constraint}", constraint)) {
            this.resolve(this.getBody(constraint, "OCL"));
        }
        if (this.needResolve("{analysis}", constraint)) {
            this.resolve(this.getBody(constraint, "Analysis"));
        }
        if (this.needResolve("{xpath}", constraint)) {
            this.resolve(this.getBody(constraint, "XPath"));
        }
        if (this.needResolve("{xpath-test}", constraint)) {
            this.resolve(this.getXPathTest(constraint));
        }
        return this.resolve(this.template, clazz, element);
    }

    protected abstract String getEntityMimeType();

    private String getDefault(NamedElement element) {
        if (element instanceof Property) {
            return CDACommonUtils.getDefault((Property)((Property)element));
        }
        return null;
    }

    private String getCdaType(NamedElement element) {
        Type cdaT = CDACommonUtils.getType((NamedElement)element);
        if (cdaT != null) {
            if (cdaT.eIsProxy()) {
                return ((BasicEObjectImpl)cdaT).eProxyURI().toString();
            }
            return cdaT.getName();
        }
        return null;
    }

    private String getCdaPropertyName(NamedElement element) {
        Property baseProperty;
        if (element instanceof Property && (baseProperty = CDACommonUtils.getCDAProperty((Property)((Property)element))) != null) {
            return baseProperty.getName();
        }
        return null;
    }

    private String getBody(Constraint constraint, String language) {
        OpaqueExpression spec;
        OpaqueExpression opaqueExpression = spec = constraint.getSpecification() instanceof OpaqueExpression ? (OpaqueExpression)constraint.getSpecification() : null;
        if (spec == null) {
            return null;
        }
        int analysisIndex = spec.getLanguages().indexOf((Object)language);
        if (analysisIndex >= 0 && analysisIndex < spec.getBodies().size()) {
            return (String)spec.getBodies().get(analysisIndex);
        }
        return null;
    }

    protected String getConstraintName(Constraint constraint) {
        if (constraint.getName() != null && !"".equals(constraint.getName())) {
            return constraint.getName();
        }
        return String.valueOf(constraint.getContext().getName()) + "(" + (constraint.getContext().getOwnedRules().indexOf((Object)constraint) + 1) + ")";
    }

    protected String escapeAttributeValue(String value) {
        return StringEscapeUtils.escapeHtml((String)value.replace("\"", "'"));
    }

    private String getDEL(String result) {
        if (DEL_CDA_HEADER == result) {
            return "1A";
        }
        if (DEL_CDA_BODY_LEVEL_2 == result) {
            return "2";
        }
        if (DEL_CDA_BODY_LEVEL_3 == result) {
            return "3A";
        }
        return "NA";
    }

    protected String getDataElementLevel(Class context, Element constrainedElement) {
        StringBuilder unpredicatedContext = new StringBuilder("/cda:ClinicalDocument");
        List propertyPath = CDACommonUtils.getPropertyPath((Class)context);
        if (constrainedElement instanceof Property) {
            propertyPath.add((Property)constrainedElement);
        }
        for (Property childProperty : propertyPath) {
            Property cdaProperty = CDACommonUtils.getCDAProperty((Property)childProperty);
            if (cdaProperty == null) continue;
            unpredicatedContext.append("/cda:" + cdaProperty.getName());
        }
        unpredicatedContext.append("/");
        String path = unpredicatedContext.toString();
        if (!path.startsWith("/cda:ClinicalDocument/cda:component")) {
            return DEL_CDA_HEADER;
        }
        if (!path.contains("cda:entry/")) {
            return DEL_CDA_BODY_LEVEL_2;
        }
        if (path.contains("cda:component/cda:section/")) {
            return DEL_CDA_BODY_LEVEL_3;
        }
        return DEL_CDA_NA;
    }

    protected String getBusinessName(NamedElement element) {
        if (element instanceof Constraint) {
            return this.getConstraintName((Constraint)element);
        }
        String businessName = CDACommonUtils.getBusinessName((NamedElement)element);
        if (businessName != null) {
            return businessName;
        }
        return element.getName();
    }

    public static boolean isTemplateId(Element element) {
        if (element instanceof Property) {
            Property property = (Property)element;
            return "templateId".equals(property.getName()) && CDACommonUtils.getCDAProperty((Property)property) == property;
        }
        return false;
    }

    public static String getPDFSection(Class context, Element constrainedElement) {
        if (GenerateAPIAction.isTemplateId(constrainedElement)) {
            return String.valueOf(CDACommonUtils.getPDFSection((Element)context, (boolean)true)) + "." + CDACommonUtils.getCustomizedBulletItem((Element)context, (int)0);
        }
        return CDACommonUtils.getPDFSection((Element)constrainedElement, (boolean)true);
    }

    public static String getPDFSectionOrder(Class context, Element constrainedElement) {
        String result = "";
        String[] stringArray = GenerateAPIAction.getPDFSection(context, constrainedElement).split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result = "ix".equals(part) ? String.valueOf(result) + "vix." : String.valueOf(result) + (part.length() == 1 && Character.isDigit(part.charAt(0)) ? "0" + part : part) + ".";
            ++n2;
        }
        return result;
    }

    public static String getLevel2PDFSectionNumber(Class context, Element constrainedElement) {
        String result = CDACommonUtils.getPDFSection((Element)(GenerateAPIAction.isTemplateId(constrainedElement) ? context : constrainedElement), (boolean)true, (boolean)true);
        if (result.indexOf(" ") != -1) {
            return result.substring(0, result.indexOf(" "));
        }
        return result;
    }

    public static String getLevel2PDFSectionName(Class context, Element constrainedElement) {
        String result = CDACommonUtils.getPDFSection((Element)(GenerateAPIAction.isTemplateId(constrainedElement) ? context : constrainedElement), (boolean)true, (boolean)true);
        if (result.indexOf(" ") != -1) {
            return result.substring(result.indexOf(" ") + 1);
        }
        return result;
    }

    public String getConformance(Class context, Element constrainedElement) {
        String result = GenerateAPIAction.isTemplateId(constrainedElement) ? CDAModelUtil.computeConformanceMessage((Class)context, (boolean)true).trim() : CDACommonUtils.getConformance((Element)constrainedElement).trim();
        if (this.removeTabAndNewline) {
            result = CDACommonUtils.withoutTags((String)result);
        }
        return result;
    }

    public String getMultiplicityString(Class context, NamedElement constrainedElement) {
        if (GenerateAPIAction.isTemplateId((Element)constrainedElement)) {
            String result = CDACommonUtils.getMultiplicityRange((Class)context);
            if (result != null) {
                return result;
            }
            return "1..1";
        }
        return CDACommonUtils.getMultiplicityString((NamedElement)constrainedElement);
    }

    public void calcClasses(Class clazz, List<Class> processed) {
        if (clazz == null) {
            processed.addAll(CDACommonUtils.getAllContents(this.irResources, Class.class));
            return;
        }
        if (processed.contains(clazz)) {
            return;
        }
        processed.add(clazz);
        for (Property property : CDACommonUtils.allAttributes((Class)clazz)) {
            if (!(property.getType() instanceof Class) || !CDACommonUtils.inSameModel((Class)((Class)property.getType()), (Class)clazz)) continue;
            Class class1 = (Class)property.getType();
            this.calcClasses(class1, processed);
        }
    }

    protected void recurseModel() throws IOException {
        this.processedClasses.clear();
        CDACommonUtils.cachePropertyForClass.keySet().removeAll(CDACommonUtils.getAllContents((Collection)this.resource.getResourceSet().getResources(), Class.class));
        for (Class umlClinicalDocument : !this.umlClinicalDocuments.isEmpty() ? this.umlClinicalDocuments : this.classes) {
            CDACommonUtils.cachePropertyForClass.put(umlClinicalDocument, null);
            this.recursePropertyPaths(umlClinicalDocument);
        }
    }

    protected void recursePropertyPaths(Class clazz) throws IOException {
        Collection allProperties = CDACommonUtils.allAttributes((Class)clazz);
        CDACommonUtils.propertyStepCache.keySet().removeAll(allProperties);
        CDACommonUtils.propertyStepCache.keySet().removeAll((Collection<?>)clazz.getOwnedRules());
        CDACommonUtils.propertyStepCache.keySet().remove(clazz);
        for (Property property : allProperties) {
            Class nestedClass;
            if (property.eContainer() instanceof Class && CDACommonUtils.inSameModel((Class)((Class)property.eContainer()), (Class)clazz)) {
                CDACommonUtils.cacheClassForProperty.put(property, clazz);
            }
            if (!(property.getType() instanceof Class) || !CDACommonUtils.inSameModel((Class)((Class)property.getType()), (Class)clazz) || CDACommonUtils.cachePropertyForClass.containsKey(nestedClass = (Class)property.getType())) continue;
            CDACommonUtils.cachePropertyForClass.put(nestedClass, property);
            this.recursePropertyPaths(nestedClass);
            CDACommonUtils.cachePropertyForClass.keySet().remove(nestedClass);
        }
        this.cachedResolve.keySet().removeAll(this.ambiguousTemplateBindings);
        this.ambiguousTemplateBindings.clear();
    }

    protected String mentionSection(String message, Class clazz, NamedElement element) {
        return "Section " + GenerateAPIAction.getPDFSection(clazz, (Element)element) + ": " + message;
    }

    protected String getAnchor(File file, String string, String media) {
        java.nio.file.Path pathRelative = Paths.get(this.genfolder.toURI()).relativize(Paths.get(file.toURI()));
        return "<a href=\"" + pathRelative + "\" type=\"" + media + "\">" + string + "</a> ";
    }

    protected void trace(String string, EObject source, EObject ... targets) {
        Trace trace = TraceabilityFactory.eINSTANCE.createTrace();
        trace.setDescription(string);
        trace.getSource().add((Object)source);
        EObject[] eObjectArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            EObject participant = eObjectArray[n2];
            trace.getTarget().add((Object)participant);
            ++n2;
        }
        TraceabilityUtils.addTrace((Traces)this.currentCategory, (Object)trace);
    }

    protected void resolvePathmapsInResourceURIs() {
        for (Resource res : this.irResources) {
            URI normURI = res.getResourceSet().getURIConverter().normalize(res.getURI());
            if (res.getURI().equals(normURI)) continue;
            res.setURI(normURI);
        }
    }

    protected void printMetaData(Package pack, String cstart, String cend, String br, StringBuilder sb) throws Exception {
        Version version = FrameworkUtil.getBundle(CDACommonUtils.class).getVersion();
        sb.append(br);
        sb.append(String.valueOf(cstart) + "MDHT CDA Version: " + version.toString() + cend);
        version = FrameworkUtil.getBundle(this.getClass()).getVersion();
        sb.append(String.valueOf(cstart) + this.getTargetLanguage() + " Generator Version: " + version + cend);
        sb.append(String.valueOf(cstart) + "Eclipse Version: " + System.getProperty("eclipse.buildId") + cend);
        version = Platform.getBundle((String)"org.eclipse.platform").getVersion();
        sb.append(String.valueOf(cstart) + "Platform Bundle Version: " + version + cend);
        sb.append(String.valueOf(cstart) + "Java Version: " + System.getProperty("java.runtime.version") + cend);
        for (Resource resource : new ArrayList(pack.eResource().getResourceSet().getResources())) {
            if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof Package)) continue;
            Package package1 = (Package)resource.getContents().get(0);
            if (!this.irResources.contains(resource) && !CDAModelUtil.isCDAModel((Element)package1) && !CDAModelUtil.isDatatypeModel((Element)package1)) continue;
            URI eUri = resource.getURI();
            eUri = resource.getResourceSet().getURIConverter().normalize(eUri);
            if (!eUri.isPlatformResource()) continue;
            String platformString = eUri.toPlatformString(true);
            IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
            if (r == null) continue;
            sb.append(br);
            sb.append(String.valueOf(cstart) + "Git Information for " + r.getName() + cend);
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)r);
            if (mapping == null) continue;
            Repository repository = mapping.getRepository();
            Throwable throwable = null;
            Object var16_17 = null;
            try (RevWalk walk = new RevWalk(repository);){
                ObjectId headCommitId = repository.resolve("HEAD");
                RevCommit c = walk.parseCommit((AnyObjectId)headCommitId);
                PersonIdent committer = c.getCommitterIdent();
                GitDateFormatter formatter = new GitDateFormatter(GitDateFormatter.Format.LOCALE);
                String s = String.valueOf(c.getId().abbreviate(7).name()) + ": <b>" + c.getShortMessage() + "</b> from <i>" + committer.getName() + "</i> at " + formatter.formatDate(committer);
                sb.append(String.valueOf(cstart) + "General Information: " + s + cend);
                try {
                    String remote;
                    String url;
                    String branch = repository.getBranch();
                    StoredConfig config = mapping.getRepository().getConfig();
                    Set branches = config.getSubsections("branch");
                    if (!branches.contains(branch) && !branches.isEmpty()) {
                        branch = (String)branches.iterator().next();
                    }
                    if ((url = config.getString("remote", remote = config.getString("branch", branch, "remote"), "url")) != null) {
                        sb.append(String.valueOf(cstart) + "URL: " + url + cend);
                    }
                    if (branch != null) {
                        sb.append(String.valueOf(cstart) + "Branch: " + branch + cend);
                    }
                    if (remote == null) continue;
                    sb.append(String.valueOf(cstart) + "Remote:" + remote + cend);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        sb.append(br);
    }
}

