/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.api.GenerateAPIAction;
import org.eclipse.mdht.uml.cda.core.profile.TextValue;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.mdht.uml.cda.core.util.CDASampler;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public abstract class GenerateAPIForProgrammingLanguageAction
extends GenerateAPIAction {
    @Override
    protected String getEntityMimeType() {
        return "text/plain";
    }

    protected abstract void writeEntity(String var1, String var2) throws IOException;

    @Override
    protected String toValidFileName(String filename) {
        filename = filename.replace(".", "_").replace(" ", "");
        filename = filename.replaceAll("[:\\\\/*\"?|<>']", "");
        filename = filename.replace("-", "_").replace("(", "").replace(")", "");
        return filename;
    }

    private String getFacadeNamespace(Type context) {
        String version;
        String packagePrefix = "facade";
        if (context == null) {
            return packagePrefix;
        }
        if (context.getPackage() != null && (version = this.getStereotype((NamedElement)context.getPackage(), "version")) != null) {
            packagePrefix = String.valueOf(packagePrefix) + "." + this.toValidFileName(version);
        }
        return String.valueOf(packagePrefix) + "." + context.getNamespace().getQualifiedName().toLowerCase().replace("::", ".");
    }

    @Override
    protected void genAPICode(Package pack, IProgressMonitor monitor) throws Exception {
        monitor = new SubProgressMonitor(monitor, 80);
        monitor.beginTask("", this.classes.size());
        this.resolvePathmapsInResourceURIs();
        String errorMessageTemplate = this.getStereotype((NamedElement)pack, "errorMessageTemplate");
        String summaryRowTemplate = this.getStereotype((NamedElement)pack, "summaryRowTemplate");
        StringBuilder summary = new StringBuilder("<table border=\"1\">\n" + summaryRowTemplate.replace("{", "").replace("}", ""));
        ArrayList<String> summaryRows = new ArrayList<String>();
        for (Class clazz : this.classes) {
            EObject codePredicate;
            monitor.worked(1);
            if (clazz.getName() == null || "".equals(clazz.getName().trim())) continue;
            monitor.subTask(CDACommonUtils.getUmlContext((Class)clazz));
            if (monitor.isCanceled()) {
                throw new RuntimeException("Canceled by user");
            }
            String fileName = String.valueOf(this.getFacadeNamespace((Type)clazz)) + "." + clazz.getName() + "Facade";
            ArrayList<String> validationMethods = new ArrayList<String>();
            StringBuilder validationCode = new StringBuilder();
            for (Constraint constraint : CDACommonUtils.getAllRules((Class)clazz)) {
                try {
                    NamedElement element = this.getConstrainedElement(constraint);
                    if (element == null) continue;
                    String analysis = CDACommonUtils.withoutTags((String)this.resolve(errorMessageTemplate, clazz, element, constraint).replace("\n", "\n\t\t"));
                    String test = this.resolve("{xpath-test}", clazz, element, constraint);
                    String method = this.toValidFileName("Validate" + this.getConstraintName(constraint));
                    validationMethods.add(method);
                    validationCode.append("\t\t/**\n");
                    validationCode.append("\t\t * OCL: " + this.resolve("{ocl-constraint}", clazz, element, constraint).replace("\n", " ") + "\n");
                    validationCode.append("\t\t * Context: " + CDACommonUtils.getUmlContext((Class)clazz) + "\n");
                    validationCode.append("\t\t * Context Class: " + clazz.getQualifiedName() + "\n");
                    validationCode.append("\t\t * Constraint Name: " + constraint.getQualifiedName() + "\n");
                    validationCode.append("\t\t */\n");
                    validationCode.append("\t\tpublic bool " + method + "(ValidationBuilder vb, DataElementLevel? del)\n");
                    validationCode.append("\t\t{\n");
                    validationCode.append("\t\t\tif (del != null && del != DataElementLevel." + this.getLiteralForDEL(this.getDataElementLevel(clazz, (Element)element)) + ")\n");
                    validationCode.append("\t\t\t{\n");
                    validationCode.append("\t\t\t\treturn true;\n");
                    validationCode.append("\t\t\t}\n");
                    validationCode.append("\t\t\tbool result = " + test + ";\n");
                    validationCode.append("\t\t\tif (!result && vb != null)\n");
                    validationCode.append("\t\t\t{\n");
                    validationCode.append("\t\t\t\t" + this.printAddValidationError(analysis) + "\n");
                    validationCode.append("\t\t\t}\n");
                    validationCode.append("\t\t\treturn result;\n");
                    validationCode.append("\t\t}\n\n");
                    summaryRows.add(this.resolve(summaryRowTemplate, clazz, element, constraint));
                }
                catch (Exception e) {
                    CDACommonUtils.addStatus((Collection)this.statuses, (int)4, (String)this.getPlugin(), (int)17, (String)("Could not transform OCL constraint \"" + constraint.getName() + "\""), (Exception)e, (EObject[])new EObject[]{constraint});
                }
            }
            StringBuilder code = new StringBuilder();
            String className = String.valueOf(clazz.getName()) + "Facade";
            this.addStandardImports(code, fileName, "facade.FacadeBase");
            Classifier baseType = CDACommonUtils.getCDAType((Classifier)clazz);
            if (baseType == null) {
                CDACommonUtils.getCDAType((Classifier)clazz);
            }
            String selfType = this.getProgrammingType((Type)clazz);
            code.append("\t\tpublic " + selfType + " self;\n\n");
            String templateId = CDACommonUtils.getTemplateId((Class)clazz);
            Property templateIdProperty = this.creator.getTemplateIdProperty(clazz);
            if (templateId != null && templateIdProperty != null) {
                code.append("\t\tpublic static string TEMPLATEID = \"" + templateId + "\";\n\n");
            }
            if ((codePredicate = CDACommonUtils.getPredicateForCodeOrClasscodeCheck(null, (Class)clazz)) instanceof CodeSystemConstraint) {
                CodeSystemConstraint codeSystemConstraint = (CodeSystemConstraint)codePredicate;
                if (codeSystemConstraint != null && codeSystemConstraint.getCode() != null) {
                    code.append("\t\tpublic static string CODE = \"" + codeSystemConstraint.getCode() + "\";\n\n");
                }
                if (codeSystemConstraint != null && GenerateAPIForProgrammingLanguageAction.getCodeSystem(codeSystemConstraint) != null) {
                    code.append("\t\tpublic static string CODESYSTEM = \"" + GenerateAPIForProgrammingLanguageAction.getCodeSystem(codeSystemConstraint) + "\";\n\n");
                }
            }
            ArrayList<Property> atts = new ArrayList<Property>();
            for (Property prop : GenerateAPIForProgrammingLanguageAction.editableAttributes(clazz)) {
                boolean remove = false;
                if ("URG_PQ".equals(clazz.getName()) || "IVL_INT".equals(clazz.getName()) || "IVL_PQ".equals(clazz.getName()) || "IVL_TS".equals(clazz.getName())) {
                    remove = "center".equals(prop.getName()) || "high".equals(prop.getName()) || "low".equals(prop.getName()) || "width".equals(prop.getName());
                } else if ("ON".equals(clazz.getName())) {
                    remove = "family".equals(prop.getName()) || "given".equals(prop.getName()) || "nullFlavor".equals(prop.getName());
                } else if ("RegionOfInterest".equals(clazz.getName())) {
                    remove = "regionOfInterestId".equals(prop.getName());
                } else if ("ObservationMedia".equals(clazz.getName())) {
                    remove = "observationMediaId".equals(prop.getName());
                } else {
                    boolean bl = remove = prop.getName().startsWith("sDTC") || "sectionId".equals(prop.getName());
                }
                if (remove) continue;
                atts.add(prop);
            }
            atts.retainAll(CDACommonUtils.allAttributes((Class)clazz));
            for (Property property : atts) {
                Property baseProperty = CDACommonUtils.getCDAProperty((Property)property);
                TextValue textValue = CDACommonUtils.getTextValue((Property)property);
                if (baseProperty == null || !"title".equals(baseProperty.getName()) || textValue == null || textValue.getValue() == null) continue;
                String text = textValue.getValue().trim();
                code.append("\t\tpublic static string TITLE = \"" + StringEscapeUtils.escapeJava((String)text) + "\";\n\n");
            }
            if (!clazz.isAbstract()) {
                code.append("\t\tpublic " + className + "()\n");
                code.append("\t\t{\n");
                code.append("\t\t\tthis.self = " + this.printConstructor((Type)clazz) + ";\n");
                code.append("\t\t}\n\n");
            }
            code.append("\t\tpublic " + className + "(" + selfType + " self)\n");
            code.append("\t\t{\n");
            code.append("\t\t\tthis.self = self;\n");
            code.append("\t\t}\n\n");
            code.append("\t\tpublic static bool isKindOf(" + selfType + " self)\n");
            code.append("\t\t{\n");
            String typeCheck = this.trafo.getTypeCheck((Object)clazz);
            code.append("\t\t\treturn " + (typeCheck != null ? typeCheck : "true") + ";\n");
            code.append("\t\t}\n\n");
            code.append("\t\toverride public object getModelElement()\n");
            code.append("\t\t{\n");
            code.append("\t\t\treturn self;\n");
            code.append("\t\t}\n\n");
            code.append("\t\tpublic void Init()\n");
            code.append("\t\t{\n");
            if (templateId != null && templateIdProperty != null && templateIdProperty.getType() instanceof Class) {
                this.setOrAdd(code, CDACommonUtils.findAttribute((Class)((Class)templateIdProperty.getType()), (String)"root"), "\"" + templateId + "\"", String.valueOf(this.getGetOrCreateGetter(templateIdProperty)) + "().self");
            }
            this.initProperties(clazz, code, "self.", atts);
            code.append("\t\t}\n\n");
            code.append("\t\t/**\n");
            code.append("\t\t *UML path: " + CDACommonUtils.getUmlContext((Class)clazz) + "\n");
            code.append("\t\t *UML root path: " + CDACommonUtils.getUmlContext((Class)clazz, (boolean)false) + "\n");
            code.append("\t\t*/\n");
            code.append("\t\tpublic void Validate(ValidationBuilder vb, DataElementLevel? del)\n");
            code.append("\t\t{\n");
            for (String method : validationMethods) {
                code.append("\t\t\t\t" + method + "(vb, del);\n");
            }
            code.append("\n");
            for (Property property : atts) {
                if (!this.hasFacade(property.getType())) continue;
                code.append("\t\t\t\t" + this.getMultivaluedGetter(property) + "().ForEach(x => x.Validate(vb, del));\n");
            }
            code.append("\t\t}\n");
            code.append((CharSequence)validationCode);
            for (Property property : atts) {
                Property baseProperty = CDACommonUtils.getCDAProperty((Property)property);
                if (this.hasFacade(property.getType())) {
                    String type = this.getProgrammingType(property);
                    String facade = this.getFacadeClass(property.getType());
                    code.append("\t\tpublic " + this.printStreamClass() + "<" + facade + "> " + this.getMultivaluedGetter(property) + "()\n");
                    code.append("\t\t{\n");
                    if ("datatypes".equals(property.getType().getNearestPackage().getName())) {
                        code.append("\t\t\treturn Set(self." + this.trafo.getQualifiedName((Object)baseProperty) + ").FindAll( x => " + this.trafo.instanceOf("x", type) + ").ConvertAll( x => " + this.trafo.typeCast("x", type) + ").ConvertAll( x => new " + facade + "(x))" + ";\n");
                    } else {
                        code.append("\t\t\treturn Set(self." + this.trafo.getQualifiedName((Object)baseProperty) + ").FindAll( x => " + facade + ".isKindOf(x)).ConvertAll( x => new " + facade + "(x))" + ";\n");
                    }
                    code.append("\t\t}\n\n");
                    this.printGetOrCreate(code, property, facade);
                    code.append("\t\tpublic " + facade + " " + this.getCreateAnotherGetter(property) + "()\n");
                    code.append("\t\t{\n");
                    code.append("\t\t\t" + type + " element = " + this.printConstructor(property) + ";\n");
                    code.append("\t\t\t" + facade + " elementFacade = new " + facade + "(element);\n");
                    code.append("\t\t\telementFacade.Init();\n");
                    this.setOrAdd(code, baseProperty, "element", "self");
                    code.append("\t\t\treturn elementFacade;\n");
                    code.append("\t\t}\n\n");
                    this.defineProperty(code, property, facade, String.valueOf(this.getGetOrCreateGetter(property)) + "()", null);
                    continue;
                }
                this.createCdaBaseGetters(code, property, baseProperty);
            }
            code.append("}\n");
            this.closeNamespace(code);
            this.writeEntity(code.toString(), fileName);
        }
        InputStream inputStream = new URL(this.getFacadeBaseURL()).openConnection().getInputStream();
        this.writeEntity(CDACommonUtils.toString((InputStream)inputStream), "facade.FacadeBase");
        monitor.subTask("Write " + this.summaryFile.getName());
        Collections.sort(summaryRows);
        summary.append(StringUtils.join(summaryRows, (String)""));
        summary.append("</table>\n");
        this.printMetaData(pack, "", "<br>", "<br>", summary);
        CDACommonUtils.stringToFile((String)summary.toString(), (File)this.summaryFile);
        if (this.umlClinicalDocument == null) {
            monitor.done();
            return;
        }
        StringBuilder sampleCode = new StringBuilder();
        String sampleFileName = String.valueOf(this.getFacadeNamespace((Type)this.umlClinicalDocument)) + ".SampleGenerator";
        this.addStandardImports(sampleCode, sampleFileName, null);
        sampleCode.append("        public static " + this.getFacadeClass((Type)this.umlClinicalDocument) + " GetSample()\n");
        sampleCode.append("        {\n\n");
        sampleCode.append("            " + this.getFacadeClass((Type)this.umlClinicalDocument) + " doc = new " + this.getFacadeClass((Type)this.umlClinicalDocument) + "();\n\n");
        sampleCode.append("            doc.Init();\n\n");
        this.generateSamples(this.umlClinicalDocument, sampleCode, new CDASampler(), "doc", new HashSet<Type>());
        sampleCode.append("\n            return doc;\n");
        sampleCode.append("\n      }\n\n\n");
        sampleCode.append("    }\n");
        this.closeNamespace(sampleCode);
        this.writeEntity(sampleCode.toString(), sampleFileName);
        monitor.done();
    }

    protected String getFacadeBaseURL() {
        return "platform:/plugin/" + this.getPlugin() + "/resources/FacadeBase" + this.getRootFileExtension();
    }

    private void printGetOrCreate(StringBuilder pattern, Property property, String facade) {
        pattern.append("\t\tpublic " + facade + " " + this.getGetOrCreateGetter(property) + "()\n");
        pattern.append("\t\t{\n");
        pattern.append("\t\t\t" + this.printOptional(facade) + " lastOrDefault = " + this.getMultivaluedGetter(property) + "()" + this.printLastOrDefault() + ";\n");
        pattern.append("\t\t\tif (" + this.printIsOptionalPresent("lastOrDefault") + ")\n");
        pattern.append("\t\t\t{\n");
        pattern.append("\t\t\t\tMarkSpecified(self, " + this.getFeaturePointer(CDACommonUtils.getCDAProperty((Property)property)) + ");\n");
        pattern.append("\t\t\t\treturn " + this.printRetrieveOptional("lastOrDefault") + ";\n");
        pattern.append("\t\t\t}\n");
        pattern.append("\t\t\treturn " + this.getCreateAnotherGetter(property) + "();\n");
        pattern.append("\t\t}\n\n");
    }

    protected void setOrAdd(StringBuilder pattern, Property baseProperty, String value, String self) {
        if (baseProperty == null) {
            return;
        }
        pattern.append("\t\t\t" + this.setOrAdd(baseProperty, value, self));
    }

    protected String getMultivaluedGetter(Property property) {
        return WordUtils.uncapitalize((String)this.getFacadePropertyName(property));
    }

    protected String getFacadePropertyName(Property property) {
        if ("mixed".equals(property.getName())) {
            return "Text";
        }
        return WordUtils.capitalize((String)property.getName().trim());
    }

    private String getGetOrCreateGetter(Property property) {
        return "GetOrCreate" + this.getFacadePropertyName(property);
    }

    private String getCreateAnotherGetter(Property property) {
        return "CreateAnother" + this.getFacadePropertyName(property);
    }

    protected String facadeProperty(Property property) {
        return this.getFacadePropertyName(property);
    }

    protected boolean hasFacade(Type type) {
        return type instanceof Class && (this.irResources.contains(type.eResource()) || "datatypes".equals(type.getNearestPackage().getName()) || "cda".equals(type.getNearestPackage().getName()) || "nehta".equals(type.getNearestPackage().getName()));
    }

    private String getFacadeClass(Type type) {
        return String.valueOf(this.getFacadeNamespace(type)) + "." + type.getName() + "Facade";
    }

    protected void generateSamples(Class parentClass, StringBuilder sampleCode, CDASampler sampler, String context, Set<Type> handled) {
        if (handled.contains(parentClass) && !sampler.hasData()) {
            return;
        }
        handled.add((Type)parentClass);
        sampler.mergeSampleXML(parentClass, null);
        for (Property property : CDACommonUtils.allAttributes((Class)parentClass)) {
            int index = 1;
            boolean structuralRequired = property.getType().eResource() == this.resource;
            sampler.descentProperty(property);
            while (sampler.hasData() || structuralRequired) {
                try {
                    String propContext = String.valueOf(context) + "." + this.retrieveProperty(property);
                    if (index > 1) {
                        sampleCode.append("            " + context + "." + this.getCreateAnotherGetter(property) + "();\n");
                    }
                    if (sampler.getSample() != null) {
                        sampleCode.append("            " + this.assignProperty(propContext, this.trafo.getValue((Object)property, sampler.getSample())) + ";\n");
                    }
                    if (property.getType() instanceof Class && property.getType() != parentClass) {
                        Class class1 = (Class)property.getType();
                        this.generateSamples(class1, sampleCode, sampler, propContext, new HashSet<Type>(handled));
                    }
                }
                finally {
                    sampler.ascentProperty();
                }
                ++index;
                structuralRequired = false;
                sampler.descentProperty(property);
            }
            sampler.ascentProperty();
        }
    }

    private String retrieveProperty(Property property) {
        if (this.hasPropertiesSupport()) {
            return this.facadeProperty(property);
        }
        return String.valueOf(this.facadeProperty(property)) + "()";
    }

    protected String assignProperty(String propContext, String value) {
        if (this.hasPropertiesSupport()) {
            return String.valueOf(propContext) + " = " + value;
        }
        return String.valueOf(propContext.substring(0, propContext.length() - "()".length())) + "(" + value + ")";
    }

    protected String getLiteralForDEL(String result) {
        if ("CDA Header" == result) {
            return "DEL_CDA_HEADER";
        }
        if ("CDA Body Level 2" == result) {
            return "DEL_CDA_BODY_LEVEL_2";
        }
        if ("CDA Body Level 3" == result) {
            return "DEL_CDA_BODY_LEVEL_3";
        }
        return "NA";
    }

    private void createCdaBaseGetters(StringBuilder pattern, Property property, Property baseProperty) {
        String type = this.getProgrammingType(property);
        pattern.append("\t\tpublic " + this.printStreamClass() + "<" + type + "> " + this.getMultivaluedGetter(property) + "()\n");
        pattern.append("\t\t{\n");
        if (property.getType() != baseProperty.getType()) {
            pattern.append("\t\t\treturn Set(self." + this.trafo.getQualifiedName((Object)baseProperty) + ").FindAll( x => " + this.trafo.instanceOf("x", type) + ").ConvertAll( x => (" + type + ") x)" + ";\n");
        } else {
            pattern.append("\t\t\treturn Set(self." + this.trafo.getQualifiedName((Object)baseProperty) + ")" + ";\n");
        }
        pattern.append("\t\t}\n\n");
        this.printGetOrCreate(pattern, property, type);
        pattern.append("\t\tpublic " + type + " " + this.getCreateAnotherGetter(property) + "()\n");
        pattern.append("\t\t{\n");
        pattern.append("\t\t\tMarkSpecified(self, " + this.getFeaturePointer(baseProperty) + ");\n");
        pattern.append("\t\t\t" + type + " element = " + this.printConstructor(property) + ";\n");
        this.setOrAdd(pattern, baseProperty, "element", "self");
        pattern.append("\t\t\treturn element;\n");
        pattern.append("\t\t}\n\n");
        this.defineProperty(pattern, property, type, String.valueOf(this.getGetOrCreateGetter(property)) + "()", this.setOrAdd(baseProperty, "value", "self"));
    }

    protected boolean hasPropertiesSupport() {
        return false;
    }

    private void initProperties(Class parentClass, StringBuilder pattern, String self, List<Property> atts) {
        for (Property property : atts) {
            String dv;
            TextValue textValue;
            CodeSystemConstraint codeSystemConstraint;
            if (property.getLower() <= 0 && CDACommonUtils.getPropertyForTypeCheck((Class)parentClass) != property && CDACommonUtils.getPropertyForCodeOrClasscodeCheck((Class)parentClass) != property) continue;
            Property baseProperty = CDACommonUtils.getCDAProperty((Property)property);
            if (!"string".equals(this.getProgrammingType(property))) {
                pattern.append("\t\t\t" + this.getGetOrCreateGetter(property) + "();\n");
            }
            if ((codeSystemConstraint = CDACommonUtils.getCodeSystemConstraint((Property)property)) != null && codeSystemConstraint.getCode() != null && baseProperty.getType() instanceof Class) {
                this.setOrAdd(pattern, CDACommonUtils.findAttribute((Class)((Class)baseProperty.getType()), (String)"code"), "\"" + codeSystemConstraint.getCode() + "\"", String.valueOf(this.getGetOrCreateGetter(property)) + "().self");
            }
            if (codeSystemConstraint != null && GenerateAPIForProgrammingLanguageAction.getCodeSystem(codeSystemConstraint) != null && baseProperty.getType() instanceof Class) {
                this.setOrAdd(pattern, CDACommonUtils.findAttribute((Class)((Class)baseProperty.getType()), (String)"codeSystem"), "\"" + GenerateAPIForProgrammingLanguageAction.getCodeSystem(codeSystemConstraint) + "\"", String.valueOf(this.getGetOrCreateGetter(property)) + "().self");
            }
            if ((textValue = CDACommonUtils.getTextValue((Property)property)) != null && textValue.getValue() != null && baseProperty.getType() instanceof Class) {
                String text = textValue.getValue().trim();
                this.setOrAdd(pattern, CDACommonUtils.findAttribute((Class)((Class)baseProperty.getType()), (String)"mixed"), "\"" + text + "\"", String.valueOf(this.getGetOrCreateGetter(property)) + "().self");
            }
            if ((dv = CDACommonUtils.getDefault((Property)property)) == null || "".equals(dv)) continue;
            this.setOrAdd(pattern, baseProperty, this.adjustProgrammingType(this.trafo.getValue((Object)property, CDACommonUtils.getDefault((Property)property))), "self");
            if (property.getLower() != 0 || !(property.getType() instanceof Enumeration)) continue;
            pattern.append("\t\t\t" + self + baseProperty.getName() + "Specified = true;\n");
        }
    }

    public static Collection<Property> editableAttributes(Class cls) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (Property property : CDACommonUtils.allAttributes((Class)cls)) {
            if (CDACommonUtils.getCDAProperty((Property)property) == null) continue;
            result.add(property);
        }
        return result;
    }

    protected abstract String printIsOptionalPresent(String var1);

    protected abstract String printRetrieveOptional(String var1);

    protected abstract String printOptional(String var1);

    protected abstract String printLastOrDefault();

    protected abstract String printStreamClass();

    protected abstract String printAddValidationError(String var1);

    protected abstract String printConstructor(Type var1);

    protected abstract String printConstructor(Property var1);

    protected abstract String setOrAdd(Property var1, String var2, String var3);

    protected abstract void addStandardImports(StringBuilder var1, String var2, String var3);

    protected abstract void closeNamespace(StringBuilder var1);

    protected abstract String getFeaturePointer(Property var1);

    protected abstract void defineProperty(StringBuilder var1, Property var2, String var3, String var4, String var5);

    protected abstract String getProgrammingType(Type var1);

    protected abstract String adjustProgrammingType(String var1);

    protected abstract String getProgrammingType(Property var1);

    public static String getCodeSystem(CodeSystemConstraint codeSystemConstraint) {
        if (codeSystemConstraint.getReference() != null) {
            return codeSystemConstraint.getReference().getIdentifier();
        }
        return codeSystemConstraint.getIdentifier();
    }
}

