/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.navigator;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class DecoratorAdapterFactoryLabelProvider
extends AdapterFactoryLabelProvider
implements IColorDecorator,
IFontDecorator {
    private IDecoratorManager decorator = PlatformUI.getWorkbench().getDecoratorManager();
    private ILabelProviderListener labelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            DecoratorAdapterFactoryLabelProvider.this.fireLabelProviderChanged();
        }
    };

    public DecoratorAdapterFactoryLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.decorator.addListener(this.labelProviderListener);
    }

    public void dispose() {
        super.dispose();
        this.decorator.removeListener(this.labelProviderListener);
    }

    public Image getImage(Object element) {
        Image decorated;
        Image image = super.getImage(element);
        if (image != null && this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
            return decorated;
        }
        return image;
    }

    public String getText(Object element) {
        String decorated;
        String text = super.getText(element);
        if (this.decorator != null && (decorated = this.decorator.decorateText(text, element)) != null) {
            return decorated;
        }
        return text;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image decorated;
        Image image = super.getColumnImage(element, columnIndex);
        if (columnIndex == 0 && image != null && this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
            return decorated;
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String decorated;
        String text = super.getColumnText(element, columnIndex);
        if (columnIndex == 0 && text != null && this.decorator != null && (decorated = this.decorator.decorateText(text, element)) != null) {
            return decorated;
        }
        return text;
    }

    public Color decorateBackground(Object element) {
        Color decorated;
        if (this.decorator != null && this.decorator instanceof IColorDecorator && (decorated = ((IColorDecorator)this.decorator).decorateBackground(element)) != null) {
            return decorated;
        }
        return null;
    }

    public Color decorateForeground(Object element) {
        Color decorated;
        if (this.decorator != null && this.decorator instanceof IColorDecorator && (decorated = ((IColorDecorator)this.decorator).decorateForeground(element)) != null) {
            return decorated;
        }
        return null;
    }

    public Font decorateFont(Object element) {
        Font decorated;
        if (this.decorator != null && this.decorator instanceof IFontDecorator && (decorated = ((IFontDecorator)this.decorator).decorateFont(element)) != null) {
            return decorated;
        }
        return null;
    }
}

