/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.validation.internal.provider;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IParameterizedConstraintDescriptor;
import org.eclipse.mdht.uml.validation.ConstraintProvider;
import org.eclipse.mdht.uml.validation.Diagnostic;
import org.eclipse.mdht.uml.validation.EvaluationModeKind;
import org.eclipse.mdht.uml.validation.internal.provider.ValidationProfileUtil;
import org.eclipse.ocl.uml.UMLPackage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ProfileConstraintDescriptor
implements IParameterizedConstraintDescriptor {
    private static final String PARENT_CATEGORY_ID = "org.eclipse.mdht.uml.validation.profile";
    private final String bundleName;
    private final List<EClass> targets;
    private final String id;
    private final String name;
    private final EvaluationMode<?> evaluationMode;
    private final int code;
    private final ConstraintSeverity severity;
    private final String messagePattern;
    private final String language;
    private final String body;
    private Category category;
    private Throwable exception;

    public ProfileConstraintDescriptor(String bundleName, Diagnostic diagnostic) {
        Constraint constraint = diagnostic.getBase_Constraint();
        this.bundleName = bundleName;
        this.targets = diagnostic.getTargets();
        this.name = constraint.getQualifiedName();
        this.id = String.format("%s.profile.%s", bundleName, this.name.replace("::", "."));
        this.evaluationMode = diagnostic.getEvaluationMode() == EvaluationModeKind.LIVE ? EvaluationMode.LIVE : EvaluationMode.BATCH;
        this.code = diagnostic.getCode();
        this.messagePattern = diagnostic.getMessage();
        OpaqueExpression spec = (OpaqueExpression)constraint.getSpecification();
        this.language = spec.getLanguages().isEmpty() ? "Java" : (String)spec.getLanguages().get(0);
        this.body = spec.getBodies().isEmpty() ? "" : (String)spec.getBodies().get(0);
        switch (diagnostic.getSeverity()) {
            case INFORMATIONAL: {
                this.severity = ConstraintSeverity.INFO;
                break;
            }
            case WARNING: {
                this.severity = ConstraintSeverity.WARNING;
                break;
            }
            default: {
                this.severity = ConstraintSeverity.ERROR;
            }
        }
        ConstraintProvider provider = diagnostic.getConstraintProvider();
        if (provider != null) {
            EList ownedComments = provider.getBase_Namespace().getOwnedComments();
            Comment description = ownedComments.isEmpty() ? null : (Comment)ownedComments.get(0);
            this.category = this.createCategory(provider.getCategoryName(), provider.getCategoryID(), provider.getParentCategoryID(), description == null ? null : description.getBody());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getPluginId() {
        return this.bundleName;
    }

    public String getDescription() {
        return "";
    }

    public boolean targetsTypeOf(EObject eObject) {
        boolean result = false;
        block0: for (EClass next : this.targets) {
            if (this.isStereotype(next)) {
                if (!(eObject instanceof Element)) continue;
                for (EObject application : ((Element)eObject).getStereotypeApplications()) {
                    if (!next.isInstance((Object)application)) continue;
                    result = true;
                    break block0;
                }
                continue;
            }
            if (!next.isInstance((Object)eObject)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isStereotype(EClass eClass) {
        return eClass.getEPackage() != UMLPackage.eINSTANCE && UMLUtil.getProfile((EPackage)eClass.getEPackage()) != null;
    }

    public ConstraintSeverity getSeverity() {
        return this.severity;
    }

    public int getStatusCode() {
        return this.code;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getBody() {
        return this.body;
    }

    public String getParameterValue(String name) {
        String result = null;
        if ("class".equals(name)) {
            result = ValidationProfileUtil.nullSafeTrim(this.getBody());
        } else if ("bundle".equals(name)) {
            result = this.bundleName;
        }
        return result;
    }

    public EvaluationMode<?> getEvaluationMode() {
        return this.evaluationMode;
    }

    public boolean targetsEvent(Notification notification) {
        Object notifier = notification.getNotifier();
        return notifier instanceof EObject && this.targetsTypeOf((EObject)notifier);
    }

    public boolean isBatch() {
        return this.getEvaluationMode().isBatch();
    }

    public boolean isLive() {
        return this.getEvaluationMode().isLive();
    }

    public boolean isError() {
        return this.exception != null;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setError(Throwable exception) {
        this.exception = exception;
    }

    public boolean isEnabled() {
        return !this.isError();
    }

    public void setEnabled(boolean enabled) {
    }

    public Set<Category> getCategories() {
        if (this.category == null) {
            this.category = this.createCategory(null, null, null, null);
        }
        return Collections.singleton(this.category);
    }

    private Category createCategory(String name, String id, String parentID, String description) {
        if (ProfileConstraintDescriptor.isNullOrEmpty(name)) {
            name = this.getName().substring(0, this.getName().indexOf("::"));
        }
        if (ProfileConstraintDescriptor.isNullOrEmpty(id)) {
            id = String.format("%s.%s", this.getPluginId(), UML2Util.getValidJavaIdentifier((String)name));
        }
        if (ProfileConstraintDescriptor.isNullOrEmpty(parentID)) {
            parentID = PARENT_CATEGORY_ID;
        }
        if (ProfileConstraintDescriptor.isNullOrEmpty(description)) {
            description = NLS.bind((String)"Constraints defined in the {0} profile.", (Object)name);
        }
        Category result = CategoryManager.getInstance().getCategory(CategoryManager.getInstance().getCategory(parentID), id);
        result.setMandatory(true);
        result.setName(name);
        result.setDescription(description);
        return result;
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public void addCategory(Category category) {
    }

    public void removeCategory(Category category) {
    }
}

