/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAModelConsolidator;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.transform.GenDomainProperty;
import org.eclipse.mdht.uml.cda.transform.TransformFacade;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class GenDomainInterface
extends TransformFacade {
    private GenDomainProperty genDomainProperty;

    public GenDomainInterface(TransformerOptions options, CDAModelConsolidator consolidator, IBaseModelReflection baseModelReflection) {
        super(options, consolidator, baseModelReflection);
        this.genDomainProperty = new GenDomainProperty(this.transformerOptions, consolidator, baseModelReflection);
    }

    public Object caseElementImport(ElementImport elementImport) {
        PackageableElement element = elementImport.getImportedElement();
        if (element instanceof Class) {
            return this.caseClass((Class)element);
        }
        return null;
    }

    public Object caseClass(Class umlClass) {
        if (CDAModelUtil.getCDAClass((Classifier)umlClass) == null) {
            System.err.println("Does not inherit from CDA: " + umlClass.getQualifiedName());
            return null;
        }
        Classifier domainInterface = this.getDomainInterface((Type)umlClass);
        if (this.consolidator != null) {
            this.consolidator.getImportedClassifiers().remove(umlClass);
            this.consolidator.addProcessedClassifier((Classifier)umlClass);
        }
        if (this.transformerOptions.isIncludeInterfaceRealization() && domainInterface instanceof Interface) {
            umlClass.createInterfaceRealization(null, (Interface)domainInterface);
        }
        for (Comment comment : umlClass.getOwnedComments()) {
            Comment clone = (Comment)EcoreUtil.copy((EObject)comment);
            clone.getAnnotatedElements().clear();
            clone.getAnnotatedElements().add((Object)domainInterface);
            domainInterface.getOwnedComments().add((Object)clone);
        }
        Comment igLink = domainInterface.createOwnedComment();
        igLink.getAnnotatedElements().add((Object)domainInterface);
        String igURL = "http://www.cdatools.org/infocenter/index.jsp";
        igLink.setBody("<p>Refer to full implementation guide <a href=\"" + igURL + "\"/>specification</a>.</p>");
        for (Generalization generalization : umlClass.getGeneralizations()) {
            Classifier extendsInterface;
            if (!UMLUtil.isSameModel((Element)umlClass, (Element)generalization.getGeneral()) || (extendsInterface = this.getDomainInterface((Type)generalization.getGeneral())) == null) continue;
            domainInterface.createGeneralization(extendsInterface);
        }
        Class cdaType = CDAModelUtil.getCDAClass((Classifier)umlClass);
        if (cdaType != null) {
            if (domainInterface instanceof Interface) {
                String operationName = "getCDAType";
                Operation operation = ((Interface)domainInterface).createOwnedOperation(operationName, null, null, (Type)cdaType);
                operation.setIsQuery(true);
                StringBuffer operationBody = new StringBuffer();
                operationBody.append("self.oclAsType(" + cdaType.getQualifiedName() + ")");
                this.addBodyExpression(operation, "OCL", operationBody.toString());
            } else {
                ((Class)domainInterface).createOwnedAttribute("cDAType", (Type)cdaType);
            }
        }
        Object allProperties = this.consolidator != null ? this.consolidator.getAllProperties((Classifier)umlClass) : umlClass.getOwnedAttributes();
        for (Property property : allProperties) {
            this.genDomainProperty.addProperty(property, umlClass);
        }
        return domainInterface;
    }

    protected void addBodyAnnotation(Operation operation, String body) {
        EcoreUtil.setAnnotation((EModelElement)operation, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"body", (String)body);
    }

    protected void addBodyExpression(Operation operation, String language, String body) {
        Constraint bodyConstraint = operation.createBodyCondition("body");
        bodyConstraint.getConstrainedElements().add((Object)operation);
        OpaqueExpression bodyExpression = (OpaqueExpression)bodyConstraint.createSpecification(null, null, UMLPackage.eINSTANCE.getOpaqueExpression());
        bodyExpression.getLanguages().add((Object)language);
        bodyExpression.getBodies().add((Object)body);
    }
}

