/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.mdht.uml.cda.core.profile.Validation;
import org.eclipse.mdht.uml.cda.core.profile.ValidationKind;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.TransformAssociation;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class TransformCDAAssociation
extends TransformAssociation {
    protected boolean isOpen(Association association) {
        Validation validation = (Validation)UMLUtil.getStereotypeApplication((Element)association, Validation.class);
        return validation == null || !validation.getKind().equals((Object)ValidationKind.CLOSED);
    }

    public TransformCDAAssociation(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
    }

    protected boolean isImplicitAssociation(Property sourceProperty, Class sourceClass, Class targetClass) {
        return CDAModelUtil.isEntry((Type)targetClass);
    }

    protected boolean handleSpecialAssociation(StringBuilder constraintBody, StringBuilder operationBody, Property sourceProperty, Class sourceClass, Class targetClass, String constraintTargetQName) {
        boolean result = false;
        if ((CDAModelUtil.isClinicalDocument((Type)sourceClass) || CDAModelUtil.isSection((Type)sourceClass)) && CDAModelUtil.isSection((Type)targetClass)) {
            operationBody.append("self.getAllSections()->select(");
            operationBody.append("section : cda::Section | not section.oclIsUndefined() and section.oclIsKindOf(" + constraintTargetQName + "))");
            if (sourceProperty.getUpper() == 1) {
                constraintBody.append(operationBody.toString().replace("select", "one"));
            } else {
                constraintBody.append(operationBody.toString()).append("->size() >= ").append(sourceProperty.getLower() == 0 ? "1" : Integer.valueOf(sourceProperty.getLower()));
                if (sourceProperty.getUpper() != -1) {
                    constraintBody.append(" and ").append(operationBody.toString()).append("->size() <= ").append(sourceProperty.getUpper());
                }
            }
            result = true;
        }
        return result;
    }

    protected boolean getAssociationEndAndIteratorDeclaration(Property sourceProperty, Class sourceClass, Class baseSourceClass, Class targetClass, Class baseTargetClass, String[] associationEndOut, String[] variableDeclarationOut) {
        boolean result = false;
        if (CDAModelUtil.isSection((Type)sourceClass) && (CDAModelUtil.isClinicalStatement((Type)targetClass) || CDAModelUtil.isEntry((Type)targetClass))) {
            associationEndOut[0] = "entry";
            variableDeclarationOut[0] = "entry : cda::Entry";
        } else if (CDAModelUtil.isOrganizer((Type)sourceClass) && CDAModelUtil.isClinicalStatement((Type)targetClass)) {
            associationEndOut[0] = "component";
            variableDeclarationOut[0] = "component : cda::Component4";
        } else if (CDAModelUtil.isClinicalStatement((Type)sourceClass) && CDAModelUtil.isClinicalStatement((Type)targetClass)) {
            associationEndOut[0] = "entryRelationship";
            variableDeclarationOut[0] = "entryRelationship : cda::EntryRelationship";
        } else if (CDAModelUtil.isClinicalStatement((Type)sourceClass) && "ParticipantRole".equals(baseTargetClass.getName())) {
            associationEndOut[0] = "participant";
            variableDeclarationOut[0] = "participant : cda::Participant2";
        } else if (CDAModelUtil.isClinicalStatement((Type)sourceClass) && "AssignedEntity".equals(baseTargetClass.getName())) {
            associationEndOut[0] = "performer";
            variableDeclarationOut[0] = "performer : cda::Performer2";
        }
        Property property = CDAModelUtil.getCDAProperty((Property)sourceProperty);
        if (property == null) {
            property = baseSourceClass.getOwnedAttribute(null, (Type)baseTargetClass, true, null, false);
        }
        if (property == null) {
            for (Classifier c : targetClass.allParents()) {
                property = baseSourceClass.getOwnedAttribute(null, (Type)c, true, null, false);
                if (property != null || this.isBaseModel((Element)targetClass, (Element)c)) break;
            }
        }
        if (property == null) {
            property = baseSourceClass.getOwnedAttribute(sourceProperty.getName(), null, true, null, false);
        }
        if (property != null) {
            associationEndOut[0] = property.getName();
            variableDeclarationOut[0] = String.valueOf(property.getName()) + " : " + property.getType().getQualifiedName();
            result = true;
        }
        return result;
    }

    private Stereotype getAssociationStereotype(Association association, Class sourceClass, Class targetClass) {
        Stereotype result = null;
        if (CDAModelUtil.isSection((Type)sourceClass) && (CDAModelUtil.isClinicalStatement((Type)targetClass) || CDAModelUtil.isEntry((Type)targetClass))) {
            result = CDAProfileUtil.getAppliedCDAStereotype((Element)association, (String)"Entry");
        } else if (CDAModelUtil.isClinicalStatement((Type)sourceClass) && CDAModelUtil.isClinicalStatement((Type)targetClass) && !CDAModelUtil.isOrganizer((Type)sourceClass)) {
            result = CDAProfileUtil.getAppliedCDAStereotype((Element)association, (String)"EntryRelationship");
        }
        return result;
    }

    protected boolean appendAssociationStereotypeConditions(StringBuilder constraintBody, Association association, String associationEnd, Class sourceClass, Class targetClass) {
        boolean result = false;
        Stereotype stereotype = this.getAssociationStereotype(association, sourceClass, targetClass);
        if (stereotype != null) {
            Object value = association.getValue(stereotype, "typeCode");
            String typeCode = null;
            if (value instanceof EnumerationLiteral) {
                typeCode = ((EnumerationLiteral)value).getName();
            } else if (value instanceof Enumerator) {
                typeCode = ((Enumerator)value).getName();
            }
            if (typeCode != null) {
                String enumerationQName = CDAModelUtil.isSection((Type)sourceClass) ? "vocab::x_ActRelationshipEntry" : "vocab::x_ActRelationshipEntryRelationship";
                constraintBody.append(" and " + associationEnd + ".typeCode = " + enumerationQName + "::" + typeCode);
            }
            result = true;
        }
        return result;
    }

    protected String addPrefix(Class baseSourceClass) {
        if (CDAModelUtil.isSection((Type)baseSourceClass)) {
            return "self.nullFlavor <> vocab::NullFlavor::NI implies ";
        }
        return super.addPrefix(null);
    }
}

