/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.uml.cda.core.profile.Validation;
import org.eclipse.mdht.uml.cda.core.profile.ValidationKind;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.transform.internal.Logger;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.term.transform.ecore.TransformPropertyTerminologyConstraint;
import org.eclipse.mdht.uml.transform.EcoreTransformUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.AnnotationsUtil;
import org.eclipse.mdht.uml.transform.ecore.IEcoreProfileReflection;
import org.eclipse.mdht.uml.transform.ecore.TransformPropertyConstraint;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class TransformCDAPropertyConstraint
extends TransformPropertyTerminologyConstraint {
    public TransformCDAPropertyConstraint(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
    }

    protected TransformPropertyConstraint.PropertyConstraintHandler createConstraintHandler(IEcoreProfileReflection.ValidationStereotypeKind stereotypeKind) {
        TransformPropertyConstraint.PropertyConstraintHandler result;
        switch (stereotypeKind) {
            case PROPERTY: {
                result = new PropertyValidationHandler("P");
                break;
            }
            case VOCAB_SPECIFICATION: {
                result = new VocabSpecificationHandler("Vo");
                break;
            }
            default: {
                result = super.createConstraintHandler(stereotypeKind);
            }
        }
        return result;
    }

    @Deprecated
    private String getVocabSpecificationOCL(Property property, Stereotype vocabSpecification) {
        String codeSystem = (String)property.getValue(vocabSpecification, "codeSystem");
        String codeSystemName = (String)property.getValue(vocabSpecification, "codeSystemName");
        String code = (String)property.getValue(vocabSpecification, "code");
        StringBuffer body = new StringBuffer();
        boolean needsAnd = false;
        if (code != null && code.length() > 0) {
            body.append("value.code = '");
            body.append(code);
            body.append("'");
            needsAnd = true;
        }
        if (codeSystem != null && codeSystem.length() > 0) {
            if (needsAnd) {
                body.append(" and ");
            }
            body.append("value.codeSystem = '");
            body.append(codeSystem);
            body.append("'");
            needsAnd = true;
        }
        if ((codeSystem == null || codeSystem.length() == 0) && codeSystemName != null && codeSystemName.length() > 0) {
            if (needsAnd) {
                body.append(" and ");
            }
            body.append("value.codeSystemName = '");
            body.append(codeSystemName);
            body.append("'");
            needsAnd = true;
        }
        return body.toString();
    }

    private boolean isTextProperty(Property property) {
        Classifier type = (Classifier)property.getType();
        if (type == null) {
            Property cdaProperty = this.getBaseProperty(property);
            if (cdaProperty != null) {
                type = (Classifier)cdaProperty.getType();
            } else {
                return false;
            }
        }
        ArrayList<Classifier> allTypes = new ArrayList<Classifier>((Collection<Classifier>)type.allParents());
        allTypes.add(0, type);
        for (Classifier classifier : allTypes) {
            if (!"datatypes::ED".equals(classifier.getQualifiedName()) && !"datatypes::EN".equals(classifier.getQualifiedName()) && !"datatypes::ON".equals(classifier.getQualifiedName()) && !"datatypes::AD".equals(classifier.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeString(Type type) {
        Stereotype eDataType = EcoreTransformUtil.getEcoreStereotype((EObject)type, (String)"EDataType");
        String instanceClassName = null;
        if (type.isStereotypeApplied(eDataType)) {
            instanceClassName = (String)type.getValue(eDataType, "instanceClassName");
        }
        return UMLUtil.isTypeString((Type)type) || "java.lang.String".equals(instanceClassName);
    }

    class PropertyValidationHandler
    extends TransformPropertyConstraint.PropertyConstraintHandler {
        PropertyValidationHandler(String suffix) {
            super((TransformPropertyConstraint)TransformCDAPropertyConstraint.this, IEcoreProfileReflection.ValidationStereotypeKind.PROPERTY, suffix);
        }

        protected boolean addAnnotation(TransformPropertyConstraint.PropertyContext context) {
            return false;
        }

        protected Constraint addConstraint(TransformPropertyConstraint.PropertyContext context) {
            String value;
            Stereotype textValue;
            AnnotationsUtil annotationUtil;
            Class class_;
            String templateTypeQName;
            String message;
            Property property = context.property();
            if (property.getAssociation() != null) {
                return null;
            }
            Property cdaProperty = TransformCDAPropertyConstraint.this.getBaseProperty(property);
            Property inheritedProperty = TransformCDAPropertyConstraint.this.getInheritedProperty(property);
            if (cdaProperty == null) {
                String message2 = "Cannot find CDA property for: " + property.getQualifiedName();
                Logger.log(4, message2);
                TransformCDAPropertyConstraint.this.removeModelElement((Element)property);
                return null;
            }
            if (inheritedProperty == null) {
                String message3 = "Cannot find inherited property for: " + property.getQualifiedName();
                Logger.log(4, message3);
                TransformCDAPropertyConstraint.this.removeModelElement((Element)property);
                return null;
            }
            if (inheritedProperty.getType() == null) {
                message = "Redefined property has no type: " + inheritedProperty.getQualifiedName();
                Logger.log(4, message);
            }
            if (property.getType() == null) {
                message = "Property has no type: " + property.getQualifiedName();
                Logger.log(2, message);
                TransformCDAPropertyConstraint.this.removeModelElement((Element)property);
                return null;
            }
            Classifier inheritedPropertyType = TransformCDAPropertyConstraint.this.getNormalizedType(inheritedProperty);
            Classifier propertyType = TransformCDAPropertyConstraint.this.getNormalizedType(property);
            StringBuffer body = new StringBuffer();
            String selfName = "self." + cdaProperty.getName();
            String inheritedTypeQName = inheritedPropertyType.getQualifiedName();
            String string = templateTypeQName = propertyType == null ? inheritedTypeQName : propertyType.getQualifiedName();
            if (!inheritedPropertyType.conformsTo(cdaProperty.getType())) {
                templateTypeQName = inheritedTypeQName = cdaProperty.getType().getQualifiedName();
            } else if (propertyType != null && !propertyType.conformsTo((Type)inheritedPropertyType)) {
                if (!(propertyType instanceof Enumeration)) {
                    String message4 = "Property type does not conform to redefined property type: " + property.getQualifiedName();
                    Logger.log(4, message4);
                }
                templateTypeQName = inheritedTypeQName;
            }
            String qname = "CDA::PropertyValidation";
            Stereotype stereotype = property.getApplicableStereotype(qname);
            Validation validation = (Validation)property.getStereotypeApplication(stereotype);
            if (property.getLower() != inheritedProperty.getLower() || property.getUpper() != inheritedProperty.getUpper()) {
                if (cdaProperty.getUpper() == 1) {
                    if (property.getLower() == 1) {
                        if (propertyType instanceof Enumeration) {
                            body.append("isDefined('" + cdaProperty.getName() + "')");
                        } else {
                            body.append("not " + selfName + ".oclIsUndefined()");
                        }
                    } else if (property.getUpper() == 0) {
                        if (propertyType instanceof Enumeration) {
                            body.append(" not isDefined('" + cdaProperty.getName() + "')");
                        } else {
                            body.append(" " + selfName + ".oclIsUndefined()");
                        }
                    }
                } else if (property.getLower() == property.getUpper()) {
                    body.append(selfName).append("->size() =  ").append(property.getLower());
                } else if (validation != null && validation.getKind().equals((Object)ValidationKind.OPEN)) {
                    if (!TransformCDAPropertyConstraint.this.enableVariation_UseOriginalLowerbound()) {
                        body.append("( not " + selfName + "->isEmpty()) ");
                    }
                } else {
                    body.append(" ( ");
                    int lower = property.getLower();
                    if (property.getLower() == 0 && !TransformCDAPropertyConstraint.this.enableVariation_UseOriginalLowerbound()) {
                        lower = 1;
                    }
                    body.append(String.valueOf(selfName) + "->size() >= " + lower);
                    if (property.getUpper() != -1) {
                        body.append(" and ");
                        body.append(String.valueOf(selfName) + "->size() <= " + property.getUpper());
                    }
                    body.append(" ) ");
                }
            }
            if (!templateTypeQName.equals(inheritedTypeQName)) {
                if (body.length() > 0) {
                    body.append(" and ");
                }
                if (cdaProperty.getUpper() == 1) {
                    body.append(String.valueOf(selfName) + ".oclIsTypeOf(" + templateTypeQName + ")");
                } else {
                    body.append(String.valueOf(selfName) + "->forAll(element | element.oclIsTypeOf(" + templateTypeQName + "))");
                }
            }
            if ((propertyType instanceof Enumeration || propertyType instanceof PrimitiveType) && property.getDefault() != null) {
                AnnotationsUtil annotationsUtil = TransformCDAPropertyConstraint.this.getEcoreProfile().annotate((Element)property.getClass_());
                annotationsUtil.setAnnotation(property.getName(), property.getDefault());
                annotationsUtil.saveAnnotations();
                if (property.isReadOnly()) {
                    if (body.length() > 0) {
                        body.append(" and ");
                    }
                    if (propertyType instanceof Enumeration) {
                        body.append(String.valueOf(selfName) + "=" + templateTypeQName + "::" + property.getDefault());
                    } else if (TransformCDAPropertyConstraint.this.isTypeString((Type)propertyType)) {
                        body.append(String.valueOf(selfName) + "='" + property.getDefault() + "'");
                    } else {
                        body.append(String.valueOf(selfName) + "=" + property.getDefault());
                    }
                }
            }
            String constraintName = null;
            Stereotype nullFlavor = TransformCDAPropertyConstraint.this.getEcoreProfile().getAppliedValidationStereotype((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.NULL_FLAVOR);
            if (nullFlavor != null) {
                Object value2 = property.getValue(nullFlavor, "nullFlavor");
                String nullFlavorValue = null;
                if (value2 instanceof EnumerationLiteral) {
                    nullFlavorValue = ((EnumerationLiteral)value2).getName();
                } else if (value2 instanceof Enumerator) {
                    nullFlavorValue = ((Enumerator)value2).getName();
                }
                if (nullFlavorValue != null && (class_ = property.getClass_()) != null) {
                    if (body.length() > 0) {
                        body.append(" and ");
                    }
                    body.append("self." + property.getName() + ".nullFlavor = vocab::NullFlavor::" + nullFlavorValue);
                    annotationUtil = TransformCDAPropertyConstraint.this.getEcoreProfile().annotate((Element)class_);
                    annotationUtil.setAnnotation(String.valueOf(property.getName()) + ".nullFlavor", nullFlavorValue);
                    annotationUtil.saveAnnotations();
                    constraintName = TransformCDAPropertyConstraint.this.createConstraintName((NamedElement)property, "NullFlavor");
                }
            }
            if ((textValue = TransformCDAPropertyConstraint.this.getEcoreProfile().getAppliedValidationStereotype((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.TEXT_VALUE)) != null && TransformCDAPropertyConstraint.this.isTextProperty(property) && (value = (String)property.getValue(textValue, "value")) != null && (class_ = property.getClass_()) != null) {
                if (body.length() > 0) {
                    body.append(" and ");
                }
                if (cdaProperty.getUpper() == 1) {
                    body.append("self." + cdaProperty.getName() + ".getText() = " + "'" + value + "'");
                } else {
                    body.append("self." + cdaProperty.getName() + "->reject(" + cdaProperty.getName() + " : datatypes::" + cdaProperty.getType().getName() + " |" + cdaProperty.getName() + ".getText()='" + value + "')->size() = 0");
                }
                annotationUtil = TransformCDAPropertyConstraint.this.getEcoreProfile().annotate((Element)class_);
                annotationUtil.setAnnotation(String.valueOf(property.getName()) + ".mixed", value);
                annotationUtil.saveAnnotations();
            }
            context.consume();
            Constraint result = null;
            IEcoreProfileReflection.ValidationSeverityKind severity = TransformCDAPropertyConstraint.this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.PROPERTY);
            if (severity != null) {
                if (body.length() > 0) {
                    this.addConstraint(context, IEcoreProfileReflection.ValidationStereotypeKind.PROPERTY, constraintName, body);
                } else {
                    if (cdaProperty.getUpper() == 1) {
                        if (propertyType instanceof Enumeration) {
                            body.append("isDefined('" + cdaProperty.getName() + "')");
                        } else {
                            body.append("not " + selfName + ".oclIsUndefined()");
                        }
                    } else {
                        body.append("not " + selfName + "->isEmpty()");
                    }
                    result = this.addConstraint(context, IEcoreProfileReflection.ValidationStereotypeKind.PROPERTY, constraintName, body);
                }
            } else {
                IEcoreProfileReflection.ValidationSeverityKind csSeverity = TransformCDAPropertyConstraint.this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.CODE_SYSTEM);
                IEcoreProfileReflection.ValidationSeverityKind vsSeverity = TransformCDAPropertyConstraint.this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.VALUE_SET);
                if (csSeverity == null && vsSeverity == null) {
                    body = new StringBuffer();
                    body.append("true");
                    result = this.addConstraint(context, IEcoreProfileReflection.ValidationStereotypeKind.PROPERTY, constraintName, body);
                }
            }
            return result;
        }

        protected boolean isDuplicateInitialization(Property property) {
            boolean isDuplicate = false;
            for (Property redefinedProperty : property.getRedefinedProperties()) {
                if (CDAModelUtil.isCDAModel((Element)redefinedProperty.getOwner())) break;
                if (redefinedProperty.getDefault() == null || !redefinedProperty.getDefault().equals(property.getDefault())) continue;
                isDuplicate = true;
            }
            return isDuplicate;
        }
    }

    @Deprecated
    class VocabSpecificationHandler
    extends TransformPropertyConstraint.PropertyConstraintHandler {
        VocabSpecificationHandler(String suffix) {
            super((TransformPropertyConstraint)TransformCDAPropertyConstraint.this, IEcoreProfileReflection.ValidationStereotypeKind.VOCAB_SPECIFICATION, suffix);
        }

        protected boolean addAnnotation(TransformPropertyConstraint.PropertyContext context) {
            Property property = context.property();
            boolean result = false;
            Stereotype vocabSpecification = TransformCDAPropertyConstraint.this.getEcoreProfile().getAppliedValidationStereotype((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.VOCAB_SPECIFICATION);
            String codeSystem = null;
            String codeSystemName = null;
            String codeSystemVersion = null;
            String code = null;
            String displayName = null;
            if (vocabSpecification != null) {
                codeSystem = (String)property.getValue(vocabSpecification, "codeSystem");
                codeSystemName = (String)property.getValue(vocabSpecification, "codeSystemName");
                codeSystemVersion = (String)property.getValue(vocabSpecification, "codeSystemVersion");
                if (code == null) {
                    code = (String)property.getValue(vocabSpecification, "code");
                }
                displayName = (String)property.getValue(vocabSpecification, "displayName");
                result = this.addAnnotation(property, IEcoreProfileReflection.ValidationStereotypeKind.VOCAB_SPECIFICATION, codeSystem, codeSystemName, code, displayName, codeSystemVersion);
            }
            return result;
        }

        protected Constraint addConstraint(TransformPropertyConstraint.PropertyContext context) {
            Property property = context.property();
            Constraint result = null;
            Stereotype vocabSpecification = TransformCDAPropertyConstraint.this.getEcoreProfile().getAppliedValidationStereotype((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.VOCAB_SPECIFICATION);
            if (vocabSpecification != null) {
                result = this.addVocabConstraint(context, IEcoreProfileReflection.ValidationStereotypeKind.VOCAB_SPECIFICATION, TransformCDAPropertyConstraint.this.getVocabSpecificationOCL(property, vocabSpecification));
            }
            return result;
        }

        protected boolean isDuplicateInitialization(Property property) {
            boolean isDuplicate = false;
            for (Property redefinedProperty : property.getRedefinedProperties()) {
                if (CDAModelUtil.isCDAModel((Element)redefinedProperty.getOwner())) break;
                if (redefinedProperty.getDefault() == null || !redefinedProperty.getDefault().equals(property.getDefault())) continue;
                isDuplicate = true;
            }
            return isDuplicate;
        }
    }
}

