/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.editors;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.mdht.cda.xml.ui.internal.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.osgi.framework.Bundle;

public class CDAXSL
extends EditorPart {
    Browser browser;
    IFile source;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.source = fileInput.getFile();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 2048);
        try {
            CDAXSL.open(this.browser, this.source);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private static void open(Browser browser, IFile sourceFile) throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mdht.cda.xml.ui");
        URL fileURL = bundle.getEntry("resources/xsl/vha/cda.xsl");
        File tempFile = File.createTempFile(sourceFile.getName(), ".html");
        Path temporaryDirectory = Paths.get(tempFile.getParent(), new String[0]);
        URI csspath = URIUtil.toURI((URL)FileLocator.toFileURL((URL)bundle.getEntry("resources/xsl/vha")));
        DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(csspath), "*.css");
        for (Path entry : stream) {
            Files.copy(entry, temporaryDirectory.resolve(entry.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        }
        CDAXSL.applyXSL(sourceFile, tempFile, fileURL);
        browser.setUrl(tempFile.toURI().toURL().toString());
    }

    private static void applyXSL(IFile cdaFileName, File temporaryFile, URL styleSheetURL) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Templates template = factory.newTemplates(new StreamSource(styleSheetURL.openConnection().getInputStream()));
        Transformer xformer = template.newTransformer();
        StreamSource source = new StreamSource(cdaFileName.getContents());
        StreamResult result = new StreamResult(new FileOutputStream(temporaryFile));
        xformer.transform(source, result);
    }

    public void setFocus() {
    }
}

