/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.views;

import org.apache.commons.lang.StringUtils;
import org.eclipse.mdht.cda.xml.ui.editors.CDAAnalyzer;
import org.eclipse.mdht.uml.cda.Act;
import org.eclipse.mdht.uml.cda.ClinicalStatement;
import org.eclipse.mdht.uml.cda.Component4;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.Entry;
import org.eclipse.mdht.uml.cda.EntryRelationship;
import org.eclipse.mdht.uml.cda.Observation;
import org.eclipse.mdht.uml.cda.Organizer;
import org.eclipse.mdht.uml.cda.Procedure;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.SubstanceAdministration;
import org.eclipse.mdht.uml.hl7.datatypes.ANY;
import org.eclipse.mdht.uml.hl7.datatypes.CD;
import org.eclipse.mdht.uml.hl7.datatypes.CE;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.datatypes.TS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.part.ViewPart;

public class EntriesView
extends ViewPart {
    Browser browser;

    private static StringBuffer getCDRow(CD cd, String rowStyle) {
        StringBuffer result = new StringBuffer();
        if (cd != null) {
            ClinicalStatement clinicalStatement;
            result.append("<tr ").append(rowStyle).append(" >");
            result.append("<td><small>").append(cd.eContainingFeature().getName()).append("</small></td>");
            result.append("<td><small>").append(cd.getCode() != null ? cd.getCode() : "").append("</small></td>");
            result.append("<td><small>").append(cd.getDisplayName() != null ? cd.getDisplayName() : "").append("</small></td>");
            result.append("<td><small>").append(cd.getOriginalText() != null ? cd.getOriginalText().getText() : "");
            if (cd.getOriginalText() != null && cd.getOriginalText().getReference() != null && cd.getOriginalText().getReference().getValue() != null && cd.eContainer() instanceof ClinicalStatement && (clinicalStatement = (ClinicalStatement)cd.eContainer()).getSection() != null && clinicalStatement.getSection().getText() != null) {
                result.append(clinicalStatement.getSection().getText().getText(cd.getOriginalText().getReference().getValue().substring(1)));
            }
            result.append("</small></td>");
            result.append("<td><small>").append(cd.getCodeSystemName() != null ? cd.getCodeSystemName() : "").append("</small></td>");
            result.append("<td><small>").append(cd.getCodeSystem() != null ? cd.getCodeSystem() : "").append("</small></td>");
            result.append("<td><small>").append(cd.getCodeSystemVersion() != null ? cd.getCodeSystemVersion() : "").append("</small></td>");
            result.append("</tr>");
            for (CD translation : cd.getTranslations()) {
                result.append(EntriesView.getCDRow(translation, "style=\"background-color: #FFF5EE\""));
            }
        }
        return result;
    }

    private static StringBuffer getProcedureDetails(Procedure procedure) {
        StringBuffer result = new StringBuffer();
        result.append("<table width=\"100%\"  ><tbody>");
        result.append("<tr><td>").append(EntriesView.getClinicalStatementDetails((ClinicalStatement)procedure)).append("</td></tr>");
        for (II ii : procedure.getIds()) {
            result.append("<tr><td><small>").append(ii.getRoot()).append("</small></td></tr>");
        }
        result.append("<tr><td><table  width=\"100%\" ><thead><tr><th><small>Attribute</small></th><th><small>Code</small></th><th><small>DisplayName</small></th><th><small>OriginalText</small></th><th><small>CodeSystemName</small></th><th><small>CodeSystem</small></th><th><small>CodeSystemVersion</small></th></tr></thead> <tbody>");
        if (procedure.getStatusCode() != null) {
            result.append(EntriesView.getCDRow((CD)procedure.getStatusCode(), ""));
        }
        if (procedure.getCode() != null) {
            result.append(EntriesView.getCDRow(procedure.getCode(), ""));
        }
        for (CE ce : procedure.getMethodCodes()) {
            result.append(EntriesView.getCDRow((CD)ce, ""));
        }
        result.append("</tbody></table></td></tr>");
        for (EntryRelationship er : procedure.getEntryRelationships()) {
            result.append("<tr><td>").append(EntriesView.getEntryRelationshipDetails(er)).append("</td></tr>");
        }
        result.append("</tbody></table>");
        return result;
    }

    private static StringBuffer getOrganizerDetails(Organizer organizer) {
        StringBuffer result = new StringBuffer();
        result.append("<table width=\"100%\"  ><tbody>");
        result.append("<tr><td>").append(EntriesView.getClinicalStatementDetails((ClinicalStatement)organizer)).append("</td></tr>");
        for (II ii : organizer.getIds()) {
            result.append("<tr><td><small>").append(ii.getRoot()).append("</small></td></tr>");
        }
        result.append("<tr><td><table  width=\"100%\" ><thead><tr><th><small>Attribute</small></th><th><small>Code</small></th><th><small>DisplayName</small></th><th><small>OriginalText</small></th><th><small>CodeSystemName</small></th><th><small>CodeSystem</small></th><th><small>CodeSystemVersion</small></th></tr></thead> <tbody>");
        if (organizer.getStatusCode() != null) {
            result.append(EntriesView.getCDRow((CD)organizer.getStatusCode(), ""));
        }
        if (organizer.getCode() != null) {
            result.append(EntriesView.getCDRow(organizer.getCode(), ""));
        }
        result.append("</tbody></table></td></tr>");
        for (Component4 component4 : organizer.getComponents()) {
            if (component4.getObservation() == null) continue;
            result.append("<tr><td>").append(EntriesView.getObservationDetails(component4.getObservation())).append("</td></tr>");
        }
        result.append("</tbody></table>");
        return result;
    }

    private static StringBuffer getObservationDetails(Observation observation) {
        StringBuffer result = new StringBuffer();
        result.append("<table width=\"100%\"  ><tbody>");
        result.append("<tr><td>").append(EntriesView.getClinicalStatementDetails((ClinicalStatement)observation)).append("</td></tr>");
        for (II ii : observation.getIds()) {
            result.append("<tr><td><small>").append(ii.getRoot()).append("</small></td></tr>");
        }
        result.append("<tr><td><table  width=\"100%\" ><thead><tr><th><small>Attribute</small></th><th><small>Code</small></th><th><small>DisplayName</small></th><th><small>OriginalText</small></th><th><small>CodeSystemName</small></th><th><small>CodeSystem</small></th><th><small>CodeSystemVersion</small></th></tr></thead> <tbody>");
        if (observation.getStatusCode() != null) {
            result.append(EntriesView.getCDRow((CD)observation.getStatusCode(), ""));
        }
        if (observation.getCode() != null) {
            result.append(EntriesView.getCDRow(observation.getCode(), ""));
        }
        for (ANY any : observation.getValues()) {
            if (!(any instanceof CD)) continue;
            result.append(EntriesView.getCDRow((CD)any, "style=\"background-color:#FFFFAA\""));
        }
        result.append("</tbody></table></td></tr>");
        for (EntryRelationship er : observation.getEntryRelationships()) {
            result.append("<tr><td>").append(EntriesView.getEntryRelationshipDetails(er)).append("</td></tr>");
        }
        result.append("</tbody></table>");
        return result;
    }

    private static StringBuffer getEncountersDetails(Encounter encounter) {
        StringBuffer result = new StringBuffer();
        result.append("<table width=\"100%\"  ><tbody>");
        result.append("<tr><td>").append(EntriesView.getClinicalStatementDetails((ClinicalStatement)encounter)).append("</td></tr>");
        for (II ii : encounter.getIds()) {
            result.append("<tr><td><small>").append(ii.getRoot()).append("</small></td></tr>");
        }
        result.append("<tr><td><table  width=\"100%\" ><thead><tr><th><small>Attribute</small></th><th><small>Code</small></th><th><small>DisplayName</small></th><th><small>OriginalText</small></th><th><small>CodeSystemName</small></th><th><small>CodeSystem</small></th><th><small>CodeSystemVersion</small></th></tr></thead> <tbody>");
        if (encounter.getStatusCode() != null) {
            result.append(EntriesView.getCDRow((CD)encounter.getStatusCode(), ""));
        }
        if (encounter.getCode() != null) {
            result.append(EntriesView.getCDRow(encounter.getCode(), ""));
        }
        result.append("</tbody></table></td></tr>");
        for (EntryRelationship er : encounter.getEntryRelationships()) {
            result.append("<tr><td>").append(EntriesView.getEntryRelationshipDetails(er)).append("</td></tr>");
        }
        result.append("</tbody></table>");
        return result;
    }

    private static StringBuffer getClinicalStatementDetails(ClinicalStatement cs) {
        StringBuffer result = new StringBuffer();
        result.append("<table style=\"background-color:#F0F0F0\" width=\"100%\"  ><thead><tr><th><small>Clinical Statement</small></th><th><small>Template ID(s)</small></th></tr></thead><tbody>");
        StringBuffer templateIds = new StringBuffer();
        for (II ii : cs.getTemplateIds()) {
            templateIds.append(templateIds.length() > 0 ? ", " : "").append(ii.getRoot());
        }
        String prefix = "";
        if (cs.eContainer() instanceof EntryRelationship && cs.eContainer().eContainer() instanceof ClinicalStatement) {
            prefix = String.valueOf(cs.eContainer().eContainer().eClass().getName()) + "->";
        }
        result.append("<tr><td><small>").append(prefix).append(cs.eClass().getName()).append("</small></td><td><small>").append(templateIds).append("</small></td></tr></tbody></table>");
        return result;
    }

    private static StringBuffer getEntryRelationshipDetails(EntryRelationship er) {
        StringBuffer result = new StringBuffer();
        if (er.getAct() != null) {
            result.append("<tr><td>").append(EntriesView.getActDetails(er.getAct())).append("</td></tr>");
        }
        if (er.getObservation() != null) {
            result.append("<tr><td>").append(EntriesView.getObservationDetails(er.getObservation())).append("</td></tr>");
        }
        if (er.getEncounter() != null) {
            result.append("<tr><td>").append(EntriesView.getEncountersDetails(er.getEncounter())).append("</td></tr>");
        }
        if (er.getOrganizer() != null) {
            result.append("<tr><td>").append(EntriesView.getOrganizerDetails(er.getOrganizer())).append("</td></tr>");
        }
        if (er.getProcedure() != null) {
            result.append("<tr><td>").append(EntriesView.getProcedureDetails(er.getProcedure())).append("</td></tr>");
        }
        return result;
    }

    private static String getValue(TS xxx) {
        if (xxx != null && !StringUtils.isEmpty((String)xxx.getValue())) {
            return xxx.getValue();
        }
        return "";
    }

    private static StringBuffer getActDetails(Act act) {
        StringBuffer result = new StringBuffer();
        result.append("<table width=\"100%\" ><tbody>");
        result.append("<tr><td colspan=\"30\" >").append(EntriesView.getClinicalStatementDetails((ClinicalStatement)act)).append("</td></tr>");
        for (II ii : act.getIds()) {
            result.append("<tr><td colspan=\"30\" >").append(ii.getRoot()).append("</td></tr>");
        }
        result.append("<tr>");
        if (act.getEffectiveTime() != null) {
            result.append("<td>").append(EntriesView.getValue((TS)act.getEffectiveTime().getLow())).append("</td>");
            result.append("<td>").append(EntriesView.getValue(act.getEffectiveTime().getCenter())).append("</td>");
            result.append("<td>").append(EntriesView.getValue((TS)act.getEffectiveTime().getHigh())).append("</td>");
        }
        result.append("</tr>");
        result.append("<tr><td colspan=\"30\" ><table  width=\"100%\"  ><thead><tr><th><small>Attribute</small></th><th><small>Code</small></th><th><small>DisplayName</small></th><th><small>OriginalText</small></th><th><small>CodeSystemName</small></th><th><small>CodeSystem</small></th><th><small>CodeSystemVersion</small></th></tr></thead> <tbody>");
        if (act.getStatusCode() != null) {
            result.append(EntriesView.getCDRow((CD)act.getStatusCode(), ""));
        }
        if (act.getCode() != null) {
            result.append(EntriesView.getCDRow(act.getCode(), ""));
        }
        result.append("</tbody></table>").append("</td></tr>");
        for (EntryRelationship er : act.getEntryRelationships()) {
            result.append("");
            result.append("<tr><td>").append(EntriesView.getEntryRelationshipDetails(er)).append("</td></tr>");
        }
        result.append("</tbody></table>");
        return result;
    }

    private static StringBuffer getSubstanceAdministrationDetails(SubstanceAdministration substanceAdministration) {
        StringBuffer result = new StringBuffer();
        result.append("<table width=\"100%\" ><tbody>");
        result.append("<tr><td colspan=\"30\" >").append(EntriesView.getClinicalStatementDetails((ClinicalStatement)substanceAdministration)).append("</td></tr>");
        for (II ii : substanceAdministration.getIds()) {
            result.append("<tr><td colspan=\"30\" >").append(ii.getRoot()).append("</td></tr>");
        }
        result.append("<tr><td colspan=\"30\" ><table  width=\"100%\"  ><thead><tr><th><small>Attribute</small></th><th><small>Code</small></th><th><small>DisplayName</small></th><th><small>OriginalText</small></th><th><small>CodeSystemName</small></th><th><small>CodeSystem</small></th><th><small>CodeSystemVersion</small></th></tr></thead> <tbody>");
        if (substanceAdministration.getStatusCode() != null) {
            result.append(EntriesView.getCDRow((CD)substanceAdministration.getStatusCode(), ""));
        }
        if (substanceAdministration.getCode() != null) {
            result.append(EntriesView.getCDRow(substanceAdministration.getCode(), ""));
        }
        result.append("</tbody></table>").append("</td></tr>");
        if (substanceAdministration.getAdministrationUnitCode() != null) {
            result.append(EntriesView.getCDRow((CD)substanceAdministration.getAdministrationUnitCode(), ""));
        }
        for (CD cd : substanceAdministration.getApproachSiteCodes()) {
            result.append(EntriesView.getCDRow(cd, ""));
        }
        substanceAdministration.getConsumable().getManufacturedProduct();
        for (EntryRelationship er : substanceAdministration.getEntryRelationships()) {
            result.append("");
            result.append("<tr><td>").append(EntriesView.getEntryRelationshipDetails(er)).append("</td></tr>");
        }
        result.append("</tbody></table>");
        return result;
    }

    public void addTableListener(Table table) {
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.item.getData() instanceof Section) {
                    Section section = (Section)event.item.getData();
                    StringBuffer sbe = new StringBuffer();
                    sbe.append("<html><head><style type=\"text/css\">table{border-collapse:collapse;}table, td, th{border:1px solid black;}</style></head><body><table  width=\"100%\" border=\"1\" ><tbody>");
                    int entryCtr = 1;
                    for (Entry entry : section.getEntries()) {
                        if (entry.getAct() != null) {
                            sbe.append("<tr><td><h3 style=\"background-color:#B9D3EE\" > Entry ").append(entryCtr++).append("</h3></td></tr>");
                            sbe.append("<tr><td>").append(EntriesView.getActDetails(entry.getAct())).append("</td></tr>");
                            sbe.append("<tr><td>&nbsp;</td></tr>");
                        }
                        if (entry.getObservation() != null) {
                            sbe.append("<tr><td><h3 style=\"background-color:#B9D3EE\" > Entry ").append(entryCtr++).append("</h3></td></tr>");
                            sbe.append("<tr><td>").append(EntriesView.getObservationDetails(entry.getObservation())).append("</td></tr>");
                            sbe.append("<tr><td>&nbsp;</td></tr>");
                        }
                        if (entry.getOrganizer() != null) {
                            sbe.append("<tr><td><h3 style=\"background-color:#B9D3EE\" > Entry ").append(entryCtr++).append("</h3></td></tr>");
                            sbe.append("<tr><td>").append(EntriesView.getOrganizerDetails(entry.getOrganizer())).append("</td></tr>");
                            sbe.append("<tr><td>&nbsp;</td></tr>");
                        }
                        if (entry.getProcedure() != null) {
                            sbe.append("<tr><td><h3 style=\"background-color:#B9D3EE\" > Entry ").append(entryCtr++).append("</h3></td></tr>");
                            sbe.append("<tr><td>").append(EntriesView.getProcedureDetails(entry.getProcedure())).append("</td></tr>");
                            sbe.append("<tr><td>&nbsp;</td></tr>");
                        }
                        if (entry.getEncounter() != null) {
                            sbe.append("<tr><td><h3 style=\"background-color:#B9D3EE\" > Entry ").append(entryCtr++).append("</h3></td></tr>");
                            sbe.append("<tr><td>").append(EntriesView.getEncountersDetails(entry.getEncounter())).append("</td></tr>");
                            sbe.append("<tr><td>&nbsp;</td></tr>");
                        }
                        if (entry.getSubstanceAdministration() == null) continue;
                        sbe.append("<tr><td><h3 style=\"background-color:#B9D3EE\" > Entry ").append(entryCtr++).append("</h3></td></tr>");
                        sbe.append("<tr><td>").append(EntriesView.getSubstanceAdministrationDetails(entry.getSubstanceAdministration())).append("</td></tr>");
                        sbe.append("<tr><td>&nbsp;</td></tr>");
                    }
                    sbe.append("</tbody></table></body></html>");
                    EntriesView.this.browser.setText(sbe.toString());
                }
            }
        });
    }

    public void clearView() {
        this.browser.setText("");
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 2048);
        Menu menu = new Menu((Control)this.browser);
        MenuItem printMenuItem = new MenuItem(menu, 64);
        printMenuItem.setText("Print");
        printMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EntriesView.this.browser.execute("window.print();");
            }
        });
        this.browser.setMenu(menu);
        if (this.getSite().getPage().getPerspective() != null) {
            IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDAAnalyzer analyzer;
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if ("org.eclipse.mdht.cda.xml.ui.editors.CDAAnalyzer".equals(editorReference.getId()) && (analyzer = (CDAAnalyzer)editorReference.getEditor(false)) != null) {
                    this.addTableListener(analyzer.getTable());
                }
                ++n2;
            }
        }
    }

    public void setFocus() {
    }
}

