/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.properties;

import java.util.StringTokenizer;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.cda.core.profile.SeverityKind;
import org.eclipse.mdht.uml.cda.core.profile.Validation;
import org.eclipse.mdht.uml.cda.core.profile.ValidationKind;
import org.eclipse.mdht.uml.ui.properties.sections.ResettableModelerPropertySection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public abstract class ValidationSection
extends ResettableModelerPropertySection {
    protected Element modelElement;
    protected CCombo severityCombo;
    protected Button kindButton;
    protected boolean severityModified = false;
    protected boolean kindModified = false;
    protected boolean stringModified = false;
    protected Text ruleIdText;
    protected boolean ruleIdModified = false;
    protected Button strictButton;
    protected boolean strictModified = false;
    protected TabbedPropertySheetPage myTabbedPropertySheetPage;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (ValidationSection.this.ruleIdText == event.getSource()) {
                ValidationSection.this.ruleIdModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                ValidationSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            ValidationSection.this.modifyFields();
        }
    };
    private static final String KIND_TOOL_TIP = "If this is checked/ticked then the property becomes closed - a closed property can only contain instances conforming to these constraints";
    private static final String STRICT_TOOL_TIP = "If this is checked/ticked then the property becomes strict - a strict property can only contain instances of that are of the type designated";

    protected abstract Stereotype getValidationStereotype();

    protected void modifyFields() {
        if (!(this.ruleIdModified || this.severityModified || this.kindModified || this.strictModified)) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.modelElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Stereotype stereotype = ValidationSection.this.getValidationStereotype();
                    if (stereotype == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!ValidationSection.this.modelElement.isStereotypeApplied(stereotype)) {
                        ValidationSection.this.modelElement.applyStereotype(stereotype);
                    }
                    Validation validation = (Validation)ValidationSection.this.modelElement.getStereotypeApplication(stereotype);
                    if (ValidationSection.this.severityModified) {
                        ValidationSection.this.severityModified = false;
                        int index = ValidationSection.this.severityCombo.getSelectionIndex();
                        if (index >= 0) {
                            SeverityKind severity = null;
                            validation.setNegationIndicator(false);
                            switch (index) {
                                case 0: {
                                    severity = SeverityKind.ERROR;
                                    break;
                                }
                                case 1: {
                                    severity = SeverityKind.ERROR;
                                    break;
                                }
                                case 2: {
                                    severity = SeverityKind.WARNING;
                                    break;
                                }
                                case 3: {
                                    severity = SeverityKind.WARNING;
                                    validation.setNegationIndicator(true);
                                    break;
                                }
                                case 4: {
                                    severity = SeverityKind.INFO;
                                    break;
                                }
                                default: {
                                    severity = SeverityKind.ERROR;
                                }
                            }
                            validation.setSeverity(severity);
                        }
                    }
                    if (ValidationSection.this.ruleIdModified) {
                        ValidationSection.this.ruleIdModified = false;
                        validation.getRuleId().clear();
                        String value = ValidationSection.this.ruleIdText.getText().trim();
                        StringTokenizer tokenizer = new StringTokenizer(value, ",; ");
                        while (tokenizer.hasMoreTokens()) {
                            validation.getRuleId().add((Object)tokenizer.nextToken());
                        }
                    }
                    if (ValidationSection.this.kindModified) {
                        ValidationSection.this.kindModified = false;
                        if (ValidationSection.this.kindButton.getSelection()) {
                            validation.setKind(ValidationKind.CLOSED);
                        } else {
                            validation.setKind(ValidationKind.OPEN);
                        }
                    }
                    if (ValidationSection.this.strictModified) {
                        ValidationSection.this.strictModified = false;
                        validation.setStrict(ValidationSection.this.strictButton.getSelection());
                    }
                    ValidationSection.this.updateViews();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected void resetFields() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.modelElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Restore Default Values"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Stereotype stereotype = ValidationSection.this.getValidationStereotype();
                    if (stereotype == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (ValidationSection.this.modelElement.isStereotypeApplied(stereotype)) {
                        ValidationSection.this.modelElement.unapplyStereotype(stereotype);
                    }
                    ISelection currentSelection = ValidationSection.this.getSelection();
                    ValidationSection.this.myTabbedPropertySheetPage.selectionChanged(ValidationSection.this.getPart(), (ISelection)new StructuredSelection());
                    ValidationSection.this.myTabbedPropertySheetPage.selectionChanged(ValidationSection.this.getPart(), currentSelection);
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected void addValidationControls(Composite composite, int numerator, int offset) {
        FormData data = null;
        this.severityCombo = this.getWidgetFactory().createCCombo(composite, 0x800808);
        this.severityCombo.setItems(new String[]{"", "SHALL", "SHOULD", "SHOULD NOT", "MAY"});
        this.severityCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ValidationSection.this.severityModified = true;
                ValidationSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                ValidationSection.this.severityModified = true;
                ValidationSection.this.modifyFields();
            }
        });
        CLabel severityLabel = this.getWidgetFactory().createCLabel(composite, "Severity:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.severityCombo, 0, 0x1000000);
        severityLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)severityLabel, 0);
        data.top = new FormAttachment(numerator, offset, 4);
        this.severityCombo.setLayoutData((Object)data);
        this.ruleIdText = this.getWidgetFactory().createText(composite, "");
        CLabel ruleIdLabel = this.getWidgetFactory().createCLabel(composite, "Rule ID(s):");
        data = new FormData();
        data.left = new FormAttachment((Control)this.severityCombo, 5);
        data.top = new FormAttachment((Control)this.severityCombo, 0, 0x1000000);
        ruleIdLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)ruleIdLabel, 0);
        data.width = 300;
        data.top = new FormAttachment((Control)this.severityCombo, 0, 0x1000000);
        this.ruleIdText.setLayoutData((Object)data);
    }

    protected void addScope(Composite composite, int numerator, int offset) {
        FormData data = null;
        this.kindButton = this.getWidgetFactory().createButton(composite, "Exclude Other Kinds ", 32);
        this.kindButton.setToolTipText(KIND_TOOL_TIP);
        this.kindButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ValidationSection.this.kindModified = true;
                ValidationSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                ValidationSection.this.kindModified = true;
                ValidationSection.this.modifyFields();
            }
        });
        CLabel kindLabel = this.getWidgetFactory().createCLabel(composite, "Style: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.severityCombo, 0, 131072);
        kindLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)kindLabel, 0);
        data.top = new FormAttachment((Control)this.severityCombo, 0, 131072);
        this.kindButton.setLayoutData((Object)data);
        this.strictButton = this.getWidgetFactory().createButton(composite, "Strict", 32);
        this.strictButton.setToolTipText(STRICT_TOOL_TIP);
        data = new FormData();
        data.left = new FormAttachment((Control)this.kindButton, 0);
        data.top = new FormAttachment((Control)this.severityCombo, 0, 131072);
        this.strictButton.setLayoutData((Object)data);
        this.strictButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ValidationSection.this.strictModified = true;
                ValidationSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                ValidationSection.this.strictModified = true;
                ValidationSection.this.modifyFields();
            }
        });
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.myTabbedPropertySheetPage = aTabbedPropertySheetPage;
    }

    public void refresh() {
        Validation validation;
        if (this.modelElement == null || this.modelElement.eResource() == null) {
            return;
        }
        if (this.severityCombo != null) {
            this.severityCombo.select(0);
        }
        if (this.kindButton != null) {
            this.kindButton.setSelection(false);
        }
        if (this.ruleIdText != null) {
            this.ruleIdText.setText("");
        }
        if ((validation = (Validation)this.modelElement.getStereotypeApplication(this.getValidationStereotype())) == null) {
            return;
        }
        this.ruleIdText.removeModifyListener(this.modifyListener);
        this.ruleIdText.removeKeyListener(this.keyListener);
        this.ruleIdText.removeFocusListener(this.focusListener);
        StringBuffer ruleIdDisplay = new StringBuffer();
        for (String ruleId : validation.getRuleId()) {
            if (ruleIdDisplay.length() > 0) {
                ruleIdDisplay.append(", ");
            }
            ruleIdDisplay.append(ruleId);
        }
        this.ruleIdText.setText(ruleIdDisplay.toString());
        this.ruleIdText.addModifyListener(this.modifyListener);
        this.ruleIdText.addKeyListener(this.keyListener);
        this.ruleIdText.addFocusListener(this.focusListener);
        switch (validation.getSeverity()) {
            case ERROR: {
                this.severityCombo.select(1);
                break;
            }
            case WARNING: {
                int index = validation.isNegationIndicator() ? 3 : 2;
                this.severityCombo.select(index);
                break;
            }
            case INFO: {
                this.severityCombo.select(4);
                break;
            }
            default: {
                this.severityCombo.select(0);
            }
        }
        if (this.kindButton != null) {
            switch (validation.getKind()) {
                case OPEN: {
                    this.kindButton.setSelection(false);
                    break;
                }
                case CLOSED: {
                    this.kindButton.setSelection(true);
                    break;
                }
                default: {
                    this.kindButton.setSelection(false);
                }
            }
        }
        if (this.strictButton != null) {
            this.strictButton.setSelection(validation.isStrict());
        }
        if (this.isReadOnly()) {
            this.severityCombo.setEnabled(false);
            this.ruleIdText.setEnabled(false);
            if (this.kindButton != null) {
                this.kindButton.setEnabled(false);
            }
        } else {
            this.severityCombo.setEnabled(true);
            this.ruleIdText.setEnabled(true);
            if (this.kindButton != null) {
                this.kindButton.setEnabled(true);
            }
        }
    }

    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.modelElement != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.modelElement)) != null && editingDomain.isReadOnly(this.modelElement.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof Element));
        this.modelElement = (Element)element;
    }

    public void dispose() {
        super.dispose();
    }

    public void update(Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!ValidationSection.this.isDisposed() && ValidationSection.this.modelElement.eResource() != null) {
                        ValidationSection.this.refresh();
                    }
                }
            });
        }
    }

    protected void updateViews() {
        NotificationImpl notification = new NotificationImpl(1, null, this.modelElement.getOwnedComments()){

            public Object getNotifier() {
                return ValidationSection.this.modelElement;
            }

            public int getFeatureID(Class<?> expectedClass) {
                return 1;
            }
        };
        this.modelElement.eNotify((Notification)notification);
    }
}

