/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation.table;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import traceability.presentation.table.TraceabilityViewer;

public class TraceabilityMouseListener
implements MouseListener {
    private final TraceabilityViewer xViewer;
    private MouseEvent leftClickEvent;

    public TraceabilityMouseListener(TraceabilityViewer xViewer) {
        this.xViewer = xViewer;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent event) {
        if (this.isLeftClick(event)) {
            this.leftClickEvent = event;
        }
    }

    private boolean isRightClick(MouseEvent event) {
        return event.button == 3;
    }

    public void mouseUp(MouseEvent event) {
        TreeItem item = this.xViewer.getItemUnderMouseClick(new Point(event.x, event.y));
        if (item == null) {
            return;
        }
        try {
            TreeColumn column = this.xViewer.getColumnUnderMouseClick(new Point(event.x, event.y));
            if (column == null) {
                return;
            }
            if (this.isLeftClick(event) && this.shiftBeingHeld(event) && !this.altIsBeingHeld(event)) {
                this.xViewer.handleLeftShiftClick(column, item);
            }
            this.xViewer.updateStatusLabel();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public boolean shiftBeingHeld(MouseEvent event) {
        return (event.stateMask & SWT.MODIFIER_MASK) == 131072 || (event.stateMask & SWT.MODIFIER_MASK) == 262144 || (event.stateMask & SWT.MODIFIER_MASK) == 0x400000;
    }

    private boolean isLeftClick(MouseEvent event) {
        return event.button == 1;
    }

    private boolean altIsBeingHeld(MouseEvent event) {
        return (event.stateMask & SWT.MODIFIER_MASK) == 65536;
    }

    private boolean controlNotBeingHeld(MouseEvent event) {
        return !this.controlBeingHeld(event);
    }

    private boolean controlBeingHeld(MouseEvent event) {
        return (event.stateMask & SWT.MODIFIER_MASK) == 262144;
    }

    public MouseEvent getLeftClickEvent() {
        return this.leftClickEvent;
    }
}

